/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.modeler.annotation.FaultInfo;
import com.sun.tools.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.ws.processor.modeler.annotation.WrapperInfo;
import com.sun.tools.ws.wsdl.document.soap.SOAPUse;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AnnotationProcessorContext {
    private Map<String, SEIContext> seiContextMap = new HashMap<String, SEIContext>();
    private int round = 1;
    private boolean modelCompleted = false;

    public void addSEIContext(String seiName, SEIContext seiContext) {
        this.seiContextMap.put(seiName, seiContext);
    }

    public SEIContext getSEIContext(String seiName) {
        SEIContext context = this.seiContextMap.get(seiName);
        if (context == null) {
            context = new SEIContext(seiName);
            this.addSEIContext(seiName, context);
        }
        return context;
    }

    public SEIContext getSEIContext(TypeDeclaration d) {
        SEIContext context = this.getSEIContext(d.getQualifiedName());
        return context;
    }

    public Collection<SEIContext> getSEIContexts() {
        return this.seiContextMap.values();
    }

    public int getRound() {
        return this.round;
    }

    public void incrementRound() {
        ++this.round;
    }

    public static boolean isEncoded(Model model) {
        if (model == null) {
            return false;
        }
        for (Service service : model.getServices()) {
            for (Port port : service.getPorts()) {
                for (Operation operation : port.getOperations()) {
                    if (operation.getUse() == null || !operation.getUse().equals(SOAPUse.LITERAL)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setModelCompleted(boolean modelCompleted) {
        this.modelCompleted = modelCompleted;
    }

    public boolean isModelCompleted() {
        return this.modelCompleted;
    }

    public static class SEIContext {
        private Map<String, WrapperInfo> reqOperationWrapperMap = new HashMap<String, WrapperInfo>();
        private Map<String, WrapperInfo> resOperationWrapperMap = new HashMap<String, WrapperInfo>();
        private Map<String, FaultInfo> exceptionBeanMap = new HashMap<String, FaultInfo>();
        private String seiName;
        private String seiImplName;
        private boolean implementsSEI = false;
        private String namespaceURI = null;

        public SEIContext(String seiName) {
            this.seiName = seiName;
        }

        public void setImplementsSEI(boolean implementsSEI) {
            this.implementsSEI = implementsSEI;
        }

        public boolean getImplementsSEI() {
            return this.implementsSEI;
        }

        public void setNamespaceURI(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getSEIImplName() {
            return this.seiImplName;
        }

        public void setSEIImplName(String implName) {
            this.seiImplName = implName;
        }

        public void setReqWrapperOperation(MethodDeclaration method, WrapperInfo wrapperInfo) {
            this.reqOperationWrapperMap.put(this.methodToString(method), wrapperInfo);
        }

        public WrapperInfo getReqOperationWrapper(MethodDeclaration method) {
            return this.reqOperationWrapperMap.get(this.methodToString(method));
        }

        public void setResWrapperOperation(MethodDeclaration method, WrapperInfo wrapperInfo) {
            this.resOperationWrapperMap.put(this.methodToString(method), wrapperInfo);
        }

        public WrapperInfo getResOperationWrapper(MethodDeclaration method) {
            return this.resOperationWrapperMap.get(this.methodToString(method));
        }

        public String methodToString(MethodDeclaration method) {
            StringBuffer buf = new StringBuffer(method.getSimpleName());
            for (ParameterDeclaration param : method.getParameters()) {
                buf.append(";" + param.getType().toString());
            }
            return buf.toString();
        }

        public void clearExceptionMap() {
            this.exceptionBeanMap.clear();
        }

        public void addExceptionBeanEntry(String exception, FaultInfo faultInfo, ModelBuilder builder) {
            this.exceptionBeanMap.put(exception, faultInfo);
        }

        public FaultInfo getExceptionBeanName(String exception) {
            return this.exceptionBeanMap.get(exception);
        }
    }
}

