/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.DataSourceProvider;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

final class ConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(ConnectionManager.class);
    private final DataSourceProvider dataSourceProvider;

    public static ConnectionManager getInstance(DataSourceProvider dataSourceProvider) {
        return new ConnectionManager(dataSourceProvider);
    }

    private ConnectionManager(DataSourceProvider dataSourceProvider) {
        this.dataSourceProvider = dataSourceProvider;
    }

    Connection getConnection(boolean autoCommit) throws PersistenceException {
        try {
            Connection connection = this.dataSourceProvider.getDataSource().getConnection();
            connection.setAutoCommit(autoCommit);
            return connection;
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to setup required JDBC connection parameters", ex))));
        }
    }

    PreparedStatement prepareStatement(Connection sqlConnection, String sqlStatement) throws SQLException {
        LOGGER.finer(String.format("Preparing SQL statement:\n%s", sqlStatement));
        return sqlConnection.prepareStatement(sqlStatement, 1004, 1007);
    }

    void recycle(ResultSet ... resources) {
        for (ResultSet resource : resources) {
            if (resource == null) continue;
            try {
                resource.close();
            }
            catch (SQLException ex) {
                LOGGER.logException((Throwable)ex, Level.WARNING);
            }
        }
    }

    void recycle(PreparedStatement ... resources) {
        for (PreparedStatement resource : resources) {
            if (resource == null) continue;
            try {
                resource.close();
            }
            catch (SQLException ex) {
                LOGGER.logException((Throwable)ex, Level.WARNING);
            }
        }
    }

    void recycle(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                LOGGER.logException((Throwable)ex, Level.WARNING);
            }
        }
    }

    void rollback(Connection sqlConnection) {
        try {
            sqlConnection.rollback();
        }
        catch (SQLException ex) {
            LOGGER.warning("Unexpected exception occured while performing transaction rollback", (Throwable)ex);
        }
    }

    void commit(Connection sqlConnection) throws PersistenceException {
        try {
            sqlConnection.commit();
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unexpected exception occured while performing transaction commit", ex))));
        }
    }
}

