/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.StaticPolicyContext;
import com.sun.xml.wss.impl.policy.mls.DynamicSecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecurityAnnotator {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static void secureMessage(ProcessingContext context) throws XWSSecurityException {
        HarnessUtil.validateContext(context);
        SecurityPolicy policy = context.getSecurityPolicy();
        SecurityEnvironment handler = context.getSecurityEnvironment();
        StaticPolicyContext staticContext = context.getPolicyContext();
        FilterProcessingContext fpContext = SecurityAnnotator.setFilterProcessingContext(context);
        fpContext.isInboundMessage(false);
        if (fpContext.resetMustUnderstand()) {
            fpContext.getSecurableSoapMessage().setDoNotSetMU(true);
        }
        if (PolicyTypeUtil.messagePolicy(policy) && ((MessagePolicy)policy).enableDynamicPolicy() && ((MessagePolicy)policy).size() == 0) {
            policy = new DynamicSecurityPolicy();
        }
        if (PolicyTypeUtil.dynamicSecurityPolicy(policy)) {
            DynamicApplicationContext dynamicContext = new DynamicApplicationContext(staticContext);
            dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
            dynamicContext.inBoundMessage(false);
            ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
            DynamicPolicyCallback dpCallback = new DynamicPolicyCallback(policy, dynamicContext);
            try {
                HarnessUtil.makeDynamicPolicyCallback(dpCallback, handler.getCallbackHandler());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0237_FAILED_DYNAMIC_POLICY_CALLBACK(), e);
                throw new XWSSecurityException(e);
            }
            SecurityPolicy result = dpCallback.getSecurityPolicy();
            fpContext.setSecurityPolicy(result);
            if (PolicyTypeUtil.messagePolicy(result)) {
                SecurityAnnotator.processMessagePolicy(fpContext);
            } else if (result instanceof WSSPolicy) {
                HarnessUtil.processWSSPolicy(fpContext);
            } else if (result != null) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0260_INVALID_DSP());
                throw new XWSSecurityException("Invalid dynamic security policy returned by callback handler");
            }
        } else if (PolicyTypeUtil.messagePolicy(policy)) {
            fpContext.enableDynamicPolicyCallback(((MessagePolicy)policy).enableDynamicPolicy());
            SecurityAnnotator.processMessagePolicy(fpContext);
        } else if (policy instanceof WSSPolicy) {
            HarnessUtil.processWSSPolicy(fpContext);
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0251_INVALID_SECURITY_POLICY_INSTANCE());
            throw new XWSSecurityException("SecurityPolicy instance should be of type: WSSPolicy OR MessagePolicy OR DynamicSecurityPolicy");
        }
    }

    private static void processMessagePolicy(FilterProcessingContext fpContext) throws XWSSecurityException {
        MessagePolicy policy = (MessagePolicy)fpContext.getSecurityPolicy();
        if (policy.enableWSS11Policy()) {
            fpContext.setExtraneousProperty("EnableWSS11PolicySender", "true");
        }
        ArrayList scList = new ArrayList();
        fpContext.setExtraneousProperty("SignatureConfirmation", scList);
        Iterator i = policy.iterator();
        while (i.hasNext()) {
            SecurityPolicy sPolicy = (SecurityPolicy)i.next();
            fpContext.setSecurityPolicy(sPolicy);
            HarnessUtil.processDeep(fpContext);
        }
        if (!(fpContext instanceof JAXBFilterProcessingContext) && policy.dumpMessages()) {
            DumpFilter.process(fpContext);
        }
    }

    public static void handleFault(ProcessingContext context) {
    }

    public static FilterProcessingContext setFilterProcessingContext(ProcessingContext context) throws XWSSecurityException {
        if (context instanceof JAXBFilterProcessingContext) {
            return (JAXBFilterProcessingContext)context;
        }
        return new FilterProcessingContext(context);
    }
}

