/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common.endpoint;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.tx.at.WSATException;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATImplInjection;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.common.CoordinatorIF;
import com.sun.xml.ws.tx.at.common.WSATVersion;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.runtime.TransactionServices;
import java.util.logging.Level;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coordinator<T>
implements CoordinatorIF<T> {
    private static final Class LOGGERCLASS = Coordinator.class;
    private WebServiceContext context;
    private WSATVersion<T> version;

    public Coordinator(WebServiceContext m_context, WSATVersion<T> m_version) {
        this.context = m_context;
        this.version = m_version;
    }

    @Override
    public void preparedOperation(T parameters) {
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4509_PREPARED_OPERATION_ENTERED", parameters, null);
        }
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4510_PREPARED_OPERATION", xidFromWebServiceContextHeaderList, null);
        }
        if (!this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "Prepared")) {
            this.replayOperation(parameters);
        }
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4511_PREPARED_OPERATION_EXITED", parameters, null);
        }
    }

    @Override
    public void abortedOperation(T parameters) {
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4512_ABORTED_OPERATION_ENTERED", parameters, null);
        }
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4513_ABORTED_OPERATION", xidFromWebServiceContextHeaderList, null);
        }
        this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "Aborted");
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4514_ABORTED_OPERATION_EXITED", parameters, null);
        }
    }

    @Override
    public void readOnlyOperation(T parameters) {
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4515_READ_ONLY_OPERATION_ENTERED", parameters, null);
        }
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4516_READ_ONLY_OPERATION", xidFromWebServiceContextHeaderList, null);
        }
        this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "ReadOnly");
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4517_READ_ONLY_OPERATION_EXITED", parameters, null);
        }
    }

    @Override
    public void committedOperation(T parameters) {
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4518_COMMITTED_OPERATION_ENTERED", parameters, null);
        }
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4519_COMMITTED_OPERATION", xidFromWebServiceContextHeaderList, null);
        }
        this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "Committed");
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4520_COMMITTED_OPERATION_EXITED", parameters, null);
        }
    }

    @Override
    public void replayOperation(T parameters) {
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4521_REPLAY_OPERATION_ENTERED", parameters, null);
        }
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        String wsatTid = this.getWSATHelper().getWSATTidFromWebServiceContextHeaderList(this.context);
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4522_REPLAY_OPERATION", xidFromWebServiceContextHeaderList, null);
        }
        try {
            this.getTransactionServices().replayCompletion(wsatTid, this.createWSATXAResourceForXidFromReplyTo(xidFromWebServiceContextHeaderList));
        }
        catch (WSATException e) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.SEVERE, "WSAT4523_REPLAY_OPERATION_SOAPEXCEPTION", xidFromWebServiceContextHeaderList, null);
        }
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4514_ABORTED_OPERATION_EXITED", parameters, null);
        }
    }

    protected TransactionServices getTransactionServices() {
        return WSATHelper.getTransactionServices();
    }

    WSATXAResource createWSATXAResourceForXidFromReplyTo(Xid xid) {
        HeaderList headerList = (HeaderList)this.context.getMessageContext().get((Object)"com.sun.xml.ws.api.message.HeaderList");
        WSEndpointReference wsReplyTo = headerList.getReplyTo(AddressingVersion.W3C, SOAPVersion.SOAP_12);
        EndpointReference replyTo = wsReplyTo.toSpec();
        return new WSATXAResource(this.version.getVersion(), replyTo, xid, true);
    }

    Xid getXid() {
        Xid xid = this.getWSATHelper().getXidFromWebServiceContextHeaderList(this.context);
        String bqual = this.getWSATHelper().getBQualFromWebServiceContextHeaderList(this.context);
        return new XidImpl(xid.getFormatId(), xid.getGlobalTransactionId(), bqual.getBytes());
    }

    boolean isDebugEnabled() {
        return WSATHelper.isDebugEnabled();
    }

    protected WSATHelper getWSATHelper() {
        return this.version.getWSATHelper();
    }
}

