/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Codecs;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.assembler.ServerPipelineHook;
import com.sun.xml.ws.assembler.dev.ClientPipelineHook;
import com.sun.xml.ws.assembler.dev.ClientTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.ServerTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.TubeFactory;
import com.sun.xml.ws.assembler.dev.TubelineAssemblyContextUpdater;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.security.encoding.LazyStreamCodec;
import com.sun.xml.ws.security.impl.policy.SecurityFeatureConfigurator;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.util.ServiceConfigurationError;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.wss.NonceManager;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.config.SecurityConfigProvider;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.jaxws.impl.SecurityClientTube;
import com.sun.xml.wss.jaxws.impl.SecurityServerTube;
import com.sun.xml.wss.provider.wsit.ClientPipeCreator;
import com.sun.xml.wss.provider.wsit.JMACAuthConfigFactory;
import com.sun.xml.wss.provider.wsit.ServerPipeCreator;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import com.sun.xml.xwss.XWSSClientTube;
import com.sun.xml.xwss.XWSSServerTube;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityTubeFactory
implements TubeFactory,
TubelineAssemblyContextUpdater {
    private static final Logger log = Logger.getLogger("com.sun.xml.wss.provider.wsit", "com.sun.xml.wss.provider.wsit.logging.LogStrings");
    private static final String SERVLET_CONTEXT_CLASSNAME = "javax.servlet.ServletContext";
    private static final String ENDPOINT = "ENDPOINT";
    private static final String NEXT_PIPE = "NEXT_PIPE";
    private static final String POLICY = "POLICY";
    private static final String SEI_MODEL = "SEI_MODEL";
    private static final String WSDL_MODEL = "WSDL_MODEL";
    private static final String GF_SERVER_SEC_PIPE = "com.sun.enterprise.webservice.CommonServerSecurityPipe";
    private static final boolean disable = Boolean.getBoolean("DISABLE_XWSS_SECURITY");
    private static long maxNonceAge = SecurityConfigProvider.INSTANCE.getMaxNonceAge();

    @Override
    public void prepareContext(ClientTubelineAssemblyContext context) throws WebServiceException {
        if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
            context.setCodec(this.createSecurityCodec(context.getBinding()));
        }
    }

    @Override
    public void prepareContext(ServerTubelineAssemblyContext context) throws WebServiceException {
        if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
            context.setCodec(this.createSecurityCodec(context.getEndpoint().getBinding()));
        }
    }

    @Override
    public Tube createTube(ServerTubelineAssemblyContext context) throws WebServiceException {
        if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            this.initHaBackingStores(context.getEndpoint());
        }
        ServerPipelineHook[] hooks = this.getServerTubeLineHooks();
        ServerPipelineHook hook = null;
        if (hooks != null && hooks.length > 0 && hooks[0] instanceof ServerPipeCreator) {
            hook = hooks[0];
            this.initializeJMAC();
        } else {
            hook = context.getEndpoint().getContainer().getSPI(ServerPipelineHook.class);
        }
        if (hook != null) {
            Tube securityTube;
            Tube head = context.getTubelineHead();
            if (head == (securityTube = hook.createSecurityTube(context))) {
                Pipe securityPipe = hook.createSecurityPipe(context.getPolicyMap(), context.getSEIModel(), context.getWsdlPort(), context.getEndpoint(), context.getAdaptedTubelineHead());
                securityTube = PipeAdapter.adapt(securityPipe);
            }
            return securityTube;
        }
        if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
            if (hooks != null && hooks.length == 0) {
                return this.createSecurityTube(context);
            }
            if (hooks != null && hooks.length > 0) {
                Tube securityTube;
                hook = hooks[0];
                Tube head = context.getTubelineHead();
                if (head == (securityTube = hook.createSecurityTube(context))) {
                    Pipe securityPipe = hook.createSecurityPipe(context.getPolicyMap(), context.getSEIModel(), context.getWsdlPort(), context.getEndpoint(), context.getAdaptedTubelineHead());
                    securityTube = PipeAdapter.adapt(securityPipe);
                }
                return securityTube;
            }
            log.log(Level.FINE, "cannot not use Unified Tube.");
            return new SecurityServerTube(context, context.getTubelineHead());
        }
        try {
            if (!context.isPolicyAvailable() && this.isSecurityConfigPresent(context)) {
                return this.initializeXWSSServerTube(context);
            }
        }
        catch (NoClassDefFoundError err) {
            // empty catch block
        }
        return context.getTubelineHead();
    }

    private void initHaBackingStores(WSEndpoint endpoint) {
        boolean wasNonceBsInitialized = false;
        boolean wasScBsInitialized = false;
        for (WebServiceFeature _feature : endpoint.getBinding().getFeatures()) {
            if (!(_feature instanceof SecurityFeatureConfigurator.SecurityStickyFeature)) continue;
            SecurityFeatureConfigurator.SecurityStickyFeature feature = (SecurityFeatureConfigurator.SecurityStickyFeature)_feature;
            if (!wasNonceBsInitialized && feature.isNonceManagerUsed()) {
                NonceManager.getInstance(maxNonceAge, endpoint);
                wasNonceBsInitialized = true;
            }
            if (wasScBsInitialized || !feature.isScUsed()) continue;
            SessionManager.getSessionManager(endpoint, true);
            wasScBsInitialized = true;
        }
    }

    @Override
    public Tube createTube(ClientTubelineAssemblyContext context) throws WebServiceException {
        ClientPipelineHook[] arr$;
        int len$;
        int i$;
        ClientPipelineHook hook = null;
        ClientPipelineHook[] hooks = this.getClientTublineHooks(context);
        if (context.getSEIModel() != null) {
            JAXBUtil.setSEIJAXBContext(context.getSEIModel().getJAXBContext());
        }
        if (hooks != null && hooks.length > 0 && (i$ = 0) < (len$ = (arr$ = hooks).length)) {
            ClientPipelineHook h = arr$[i$];
            if (h instanceof ClientPipeCreator) {
                hook = h;
                this.initializeJMAC();
            } else {
                hook = h;
            }
        }
        if (hook == null) {
            hook = context.getContainer().getSPI(ClientPipelineHook.class);
        }
        if (hook != null) {
            Tube securityTube;
            Tube head = context.getTubelineHead();
            if (head == (securityTube = hook.createSecurityTube(context))) {
                ClientPipeAssemblerContext pipeContext = new ClientPipeAssemblerContext(context.getAddress(), context.getWsdlPort(), context.getService(), context.getBinding(), context.getContainer());
                Pipe securityPipe = hook.createSecurityPipe(context.getPolicyMap(), pipeContext, context.getAdaptedTubelineHead());
                if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
                    context.setScInitiator((SecureConversationInitiator)((Object)securityPipe));
                }
                securityTube = PipeAdapter.adapt(securityPipe);
            }
            return securityTube;
        }
        if (this.isSecurityEnabled(context.getPolicyMap(), context.getWsdlPort())) {
            SecurityClientTube securityTube = new SecurityClientTube(context, context.getTubelineHead());
            context.setScInitiator(securityTube);
            return securityTube;
        }
        if (!context.isPolicyAvailable() && this.isSecurityConfigPresent(context)) {
            return this.initializeXWSSClientTube(context);
        }
        return context.getTubelineHead();
    }

    private ClientPipelineHook[] getClientTublineHooks(ClientTubelineAssemblyContext context) {
        try {
            ClientPipelineHook[] hooks = SecurityTubeFactory.loadSPs(ClientPipelineHook.class);
            if (hooks != null && hooks.length > 0) {
                return hooks;
            }
        }
        catch (ServiceConfigurationError ex) {
            if (ex.getCause() instanceof InstantiationException) {
                return new ClientPipelineHook[0];
            }
            return null;
        }
        return null;
    }

    private boolean isSecurityEnabled(PolicyMap policyMap, WSDLPort wsdlPort) {
        if (policyMap == null || wsdlPort == null) {
            return false;
        }
        try {
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName());
            Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
            if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY200512.namespaceUri))) {
                return true;
            }
            for (WSDLBoundOperation wSDLBoundOperation : wsdlPort.getBinding().getBindingOperations()) {
                PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName(), wSDLBoundOperation.getName());
                policy = policyMap.getOperationEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                    return true;
                }
                policy = policyMap.getInputMessageEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                    return true;
                }
                policy = policyMap.getOutputMessageEffectivePolicy(operationKey);
                if (policy != null && (policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) || policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri))) {
                    return true;
                }
                policy = policyMap.getFaultMessageEffectivePolicy(operationKey);
                if (policy == null || !policy.contains(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri) && !policy.contains(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri)) continue;
                return true;
            }
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
        return false;
    }

    private Codec createSecurityCodec(WSBinding binding) {
        StreamSOAPCodec primaryCodec = Codecs.createSOAPEnvelopeXmlCodec(binding.getSOAPVersion());
        LazyStreamCodec lsc = new LazyStreamCodec(primaryCodec);
        return Codecs.createSOAPBindingCodec(binding, lsc);
    }

    private static <P> P[] loadSPs(Class<P> svcClass) {
        return ServiceFinder.find(svcClass).toArray();
    }

    private ServerPipelineHook[] getServerTubeLineHooks() {
        try {
            ServerPipelineHook[] hooks = SecurityTubeFactory.loadSPs(ServerPipelineHook.class);
            if (hooks != null && hooks.length > 0) {
                return hooks;
            }
        }
        catch (ServiceConfigurationError ex) {
            if (ex.getCause() instanceof InstantiationException) {
                return new ServerPipelineHook[0];
            }
            return null;
        }
        return null;
    }

    private boolean isSecurityConfigPresent(ClientTubelineAssemblyContext context) {
        try {
            String configUrl = "META-INF/client_security_config.xml";
            URL url = SecurityUtil.loadFromClasspath(configUrl);
            if (url != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !disable;
    }

    private boolean isSecurityConfigPresent(ServerTubelineAssemblyContext context) {
        block10: {
            QName serviceQName = context.getEndpoint().getServiceName();
            String serviceLocalName = serviceQName.getLocalPart();
            Container container = context.getEndpoint().getContainer();
            Object ctxt = null;
            if (container != null) {
                try {
                    Class<?> contextClass = Class.forName(SERVLET_CONTEXT_CLASSNAME);
                    ctxt = container.getSPI(contextClass);
                }
                catch (ClassNotFoundException e) {
                    log.log(Level.WARNING, LogStringsMessages.WSITPVD_0066_SERVLET_CONTEXT_NOTFOUND(), e);
                }
            }
            String serverName = "server";
            if (ctxt != null) {
                try {
                    String serverConfig = "/WEB-INF/" + serverName + "_" + "security_config.xml";
                    URL url = SecurityUtil.loadFromContext(serverConfig, ctxt);
                    if (url == null) {
                        serverConfig = "/WEB-INF/" + serviceLocalName + "_" + "security_config.xml";
                        url = SecurityUtil.loadFromContext(serverConfig, ctxt);
                    }
                    if (url != null) {
                        return true;
                    }
                    break block10;
                }
                catch (XWSSecurityRuntimeException ex) {
                    return false;
                }
            }
            String serverConfig = "META-INF/" + serverName + "_" + "security_config.xml";
            URL url = SecurityUtil.loadFromClasspath(serverConfig);
            if (url == null) {
                serverConfig = "META-INF/" + serviceLocalName + "_" + "security_config.xml";
                url = SecurityUtil.loadFromClasspath(serverConfig);
            }
            if (url != null) {
                return true;
            }
        }
        return false;
    }

    private Tube initializeXWSSClientTube(ClientTubelineAssemblyContext context) {
        return new XWSSClientTube(context.getWsdlPort(), context.getService(), context.getBinding(), context.getTubelineHead());
    }

    private Tube initializeXWSSServerTube(ServerTubelineAssemblyContext context) {
        return new XWSSServerTube(context.getEndpoint(), context.getWsdlPort(), context.getTubelineHead());
    }

    private Tube createSecurityTube(ServerTubelineAssemblyContext context) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(POLICY, context.getPolicyMap());
        props.put(SEI_MODEL, context.getSEIModel());
        props.put(WSDL_MODEL, context.getWsdlPort());
        props.put(ENDPOINT, context.getEndpoint());
        props.put(NEXT_PIPE, context.getAdaptedTubelineHead());
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> gfServerPipeClass = null;
            gfServerPipeClass = loader != null ? loader.loadClass(GF_SERVER_SEC_PIPE) : Class.forName(GF_SERVER_SEC_PIPE);
            if (gfServerPipeClass != null) {
                Class<?>[] paramTypes;
                Constructor<?>[] ctors = gfServerPipeClass.getDeclaredConstructors();
                Constructor<?> ctor = null;
                for (int i = 0; i < ctors.length && !(paramTypes = (ctor = ctors[i]).getParameterTypes())[0].equals(Map.class); ++i) {
                }
                if (ctor != null) {
                    return PipeAdapter.adapt((Pipe)ctor.newInstance(props, context.getAdaptedTubelineHead(), false));
                }
            }
            return context.getTubelineHead();
        }
        catch (InstantiationException ex) {
            throw new WebServiceException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new WebServiceException((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new WebServiceException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new WebServiceException((Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new WebServiceException((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    private void initializeJMAC() {
        final ClassLoader loader = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AuthConfigFactory factory = AuthConfigFactory.getFactory();
                if (factory == null || !(factory instanceof JMACAuthConfigFactory)) {
                    AuthConfigFactory.setFactory((AuthConfigFactory)new JMACAuthConfigFactory(loader));
                }
                return null;
            }
        });
    }

    static {
        if (maxNonceAge == 900000L) {
            String maxNAge = System.getProperty("MAX_NONCE_AGE");
            maxNonceAge = maxNAge != null ? Long.parseLong(maxNAge) : 900000L;
        }
    }
}

