/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.istack.Nullable;
import com.sun.xml.ws.addressing.model.InvalidAddressingHeaderException;
import com.sun.xml.ws.addressing.model.MissingAddressingHeaderException;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLOutput;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.model.CheckedExceptionImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.model.wsdl.WSDLOperationImpl;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;

public abstract class WsaTubeHelper {
    protected SEIModel seiModel;
    protected WSDLPort wsdlPort;
    protected WSBinding binding;
    protected final SOAPVersion soapVer;
    protected final AddressingVersion addVer;

    public WsaTubeHelper(WSBinding binding, SEIModel seiModel, WSDLPort wsdlPort) {
        this.binding = binding;
        this.wsdlPort = wsdlPort;
        this.seiModel = seiModel;
        this.soapVer = binding.getSOAPVersion();
        this.addVer = binding.getAddressingVersion();
    }

    public String getFaultAction(Packet requestPacket, Packet responsePacket) {
        QName wsdlOp;
        String action = null;
        if (this.seiModel != null) {
            action = this.getFaultActionFromSEIModel(requestPacket, responsePacket);
        }
        if (action != null) {
            return action;
        }
        action = this.addVer.getDefaultFaultAction();
        if (this.wsdlPort != null && (wsdlOp = requestPacket.getWSDLOperation()) != null) {
            WSDLBoundOperation wbo = this.wsdlPort.getBinding().get(wsdlOp);
            return this.getFaultAction(wbo, responsePacket);
        }
        return action;
    }

    String getFaultActionFromSEIModel(Packet requestPacket, Packet responsePacket) {
        String action = null;
        if (this.seiModel == null || this.wsdlPort == null) {
            return action;
        }
        try {
            SOAPMessage sm = responsePacket.getMessage().copy().readAsSOAPMessage();
            if (sm == null) {
                return action;
            }
            if (sm.getSOAPBody() == null) {
                return action;
            }
            if (sm.getSOAPBody().getFault() == null) {
                return action;
            }
            Detail detail = sm.getSOAPBody().getFault().getDetail();
            if (detail == null) {
                return action;
            }
            String ns = detail.getFirstChild().getNamespaceURI();
            String name = detail.getFirstChild().getLocalName();
            QName wsdlOp = requestPacket.getWSDLOperation();
            JavaMethodImpl jm = (JavaMethodImpl)this.seiModel.getJavaMethodForWsdlOperation(wsdlOp);
            if (jm != null) {
                for (CheckedExceptionImpl ce : jm.getCheckedExceptions()) {
                    if (!ce.getDetailType().tagName.getLocalPart().equals(name) || !ce.getDetailType().tagName.getNamespaceURI().equals(ns)) continue;
                    return ce.getFaultAction();
                }
            }
            return action;
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    String getFaultAction(@Nullable WSDLBoundOperation wbo, Packet responsePacket) {
        String action = responsePacket.getMessage().getHeaders().getAction(this.addVer, this.soapVer);
        if (action != null) {
            return action;
        }
        action = this.addVer.getDefaultFaultAction();
        if (wbo == null) {
            return action;
        }
        try {
            SOAPMessage sm = responsePacket.getMessage().copy().readAsSOAPMessage();
            if (sm == null) {
                return action;
            }
            if (sm.getSOAPBody() == null) {
                return action;
            }
            if (sm.getSOAPBody().getFault() == null) {
                return action;
            }
            Detail detail = sm.getSOAPBody().getFault().getDetail();
            if (detail == null) {
                return action;
            }
            String ns = detail.getFirstChild().getNamespaceURI();
            String name = detail.getFirstChild().getLocalName();
            WSDLOperation o = wbo.getOperation();
            WSDLFault fault = o.getFault(new QName(ns, name));
            if (fault == null) {
                return action;
            }
            WSDLOperationImpl impl = (WSDLOperationImpl)o;
            action = fault.getAction();
            return action;
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public String getInputAction(Packet packet) {
        QName wsdlOp;
        String action = null;
        if (this.wsdlPort != null && (wsdlOp = packet.getWSDLOperation()) != null) {
            WSDLBoundOperation wbo = this.wsdlPort.getBinding().get(wsdlOp);
            WSDLOperation op = wbo.getOperation();
            action = op.getInput().getAction();
        }
        return action;
    }

    public String getEffectiveInputAction(Packet packet) {
        if (packet.soapAction != null && !packet.soapAction.equals("")) {
            return packet.soapAction;
        }
        String action = null;
        if (this.wsdlPort != null) {
            QName wsdlOp = packet.getWSDLOperation();
            if (wsdlOp != null) {
                WSDLBoundOperation wbo = this.wsdlPort.getBinding().get(wsdlOp);
                WSDLOperation op = wbo.getOperation();
                action = op.getInput().getAction();
            } else {
                action = packet.soapAction;
            }
        } else {
            action = packet.soapAction;
        }
        return action;
    }

    public boolean isInputActionDefault(Packet packet) {
        if (this.wsdlPort == null) {
            return false;
        }
        QName wsdlOp = packet.getWSDLOperation();
        if (wsdlOp == null) {
            return false;
        }
        WSDLBoundOperation wbo = this.wsdlPort.getBinding().get(wsdlOp);
        WSDLOperation op = wbo.getOperation();
        return ((WSDLOperationImpl)op).getInput().isDefaultAction();
    }

    public String getSOAPAction(Packet packet) {
        String action = "";
        if (packet == null || packet.getMessage() == null) {
            return action;
        }
        if (this.wsdlPort == null) {
            return action;
        }
        QName opName = packet.getWSDLOperation();
        if (opName == null) {
            return action;
        }
        WSDLBoundOperation op = this.wsdlPort.getBinding().get(opName);
        action = op.getSOAPAction();
        return action;
    }

    public String getOutputAction(Packet packet) {
        String action = null;
        QName wsdlOp = packet.getWSDLOperation();
        if (wsdlOp != null) {
            JavaMethodImpl jm;
            if (this.seiModel != null && (jm = (JavaMethodImpl)this.seiModel.getJavaMethodForWsdlOperation(wsdlOp)) != null && jm.getOutputAction() != null && !jm.getOutputAction().equals("")) {
                return jm.getOutputAction();
            }
            if (this.wsdlPort != null) {
                WSDLBoundOperation wbo = this.wsdlPort.getBinding().get(wsdlOp);
                return this.getOutputAction(wbo);
            }
        }
        return action;
    }

    String getOutputAction(@Nullable WSDLBoundOperation wbo) {
        WSDLOutput op;
        String action = "http://jax-ws.dev.java.net/addressing/output-action-not-set";
        if (wbo != null && (op = wbo.getOperation().getOutput()) != null) {
            action = op.getAction();
        }
        return action;
    }

    public SOAPFault createInvalidAddressingHeaderFault(InvalidAddressingHeaderException e, AddressingVersion av) {
        QName name = e.getProblemHeader();
        QName subsubcode = e.getSubsubcode();
        QName subcode = av.invalidMapTag;
        String faultstring = String.format(av.getInvalidMapText(), name, subsubcode);
        try {
            SOAPFault fault;
            if (this.soapVer == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.getSOAPFactory();
                fault = factory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
                fault.appendFaultSubcode(subsubcode);
                this.getInvalidMapDetail(name, (Element)fault.addDetail());
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.getSOAPFactory();
                fault = factory.createFault();
                fault.setFaultCode(subsubcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException se) {
            throw new WebServiceException((Throwable)se);
        }
    }

    public SOAPFault newMapRequiredFault(MissingAddressingHeaderException e) {
        QName subcode = this.addVer.mapRequiredTag;
        QName subsubcode = this.addVer.mapRequiredTag;
        String faultstring = this.addVer.getMapRequiredText();
        try {
            SOAPFault fault;
            if (this.soapVer == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.getSOAPFactory();
                fault = factory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
                fault.appendFaultSubcode(subsubcode);
                this.getMapRequiredDetail(e.getMissingHeaderQName(), (Element)fault.addDetail());
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.getSOAPFactory();
                fault = factory.createFault();
                fault.setFaultCode(subsubcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException se) {
            throw new WebServiceException((Throwable)se);
        }
    }

    public abstract void getProblemActionDetail(String var1, Element var2);

    public abstract void getInvalidMapDetail(QName var1, Element var2);

    public abstract void getMapRequiredDetail(QName var1, Element var2);
}

