/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.sdo;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAX2DOMContentHandler
implements ContentHandler {
    private Document doc;
    private Stack<Node> stack;
    private Map<String, String> prefixMappings;

    public SAX2DOMContentHandler() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            this.doc = documentBuilder.newDocument();
            this.stack = new Stack();
            this.stack.push(this.doc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.prefixMappings = new HashMap<String, String>();
    }

    public SAX2DOMContentHandler(Document d) {
        this.doc = d;
        this.stack = new Stack();
        this.stack.push(d);
        this.prefixMappings = new HashMap<String, String>();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMappings.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String string2) throws SAXException {
    }

    @Override
    public void startElement(String ns, String local, String qname, Attributes attributes) throws SAXException {
        if (this.stack.isEmpty()) {
            throw new SAXException("invalid state");
        }
        Element e = this.doc.createElementNS(ns, qname);
        if (!this.prefixMappings.isEmpty()) {
            Set<Map.Entry<String, String>> prefixMappingSet = this.prefixMappings.entrySet();
            String pname = null;
            for (Map.Entry<String, String> prefixMapping : prefixMappingSet) {
                String p = prefixMapping.getKey();
                String u = prefixMapping.getValue();
                pname = p == null || p.length() == 0 ? "xmlns" : "xmlns:" + p;
                e.setAttributeNS("http://www.w3.org/2000/xmlns/", pname, u);
            }
            this.prefixMappings.clear();
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                String uri = attributes.getURI(i);
                String value = attributes.getValue(i);
                e.setAttributeNS(uri, name, value);
            }
        }
        Node node = this.stack.peek();
        node.appendChild(e);
        this.stack.push(e);
    }

    @Override
    public void endElement(String string2, String string1, String string22) throws SAXException {
        this.stack.pop();
    }

    @Override
    public void characters(char[] chars, int i, int i1) throws SAXException {
        Text text = this.doc.createTextNode(new String(chars, i, i1));
        if (this.stack.isEmpty()) {
            throw new SAXException("invalid state");
        }
        Node node = this.stack.peek();
        node.appendChild(text);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    @Override
    public void processingInstruction(String string2, String string1) throws SAXException {
        ProcessingInstruction pi = this.doc.createProcessingInstruction(string2, string1);
        if (this.stack.isEmpty()) {
            throw new SAXException("invalid state");
        }
        Node node = this.stack.peek();
        node.appendChild(pi);
    }

    @Override
    public void skippedEntity(String string2) throws SAXException {
    }
}

