/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.sdo;

import com.sun.xml.ws.db.sdo.SDODatabindingException;
import com.sun.xml.ws.db.sdo.SDODatabindingSchemaResolver;
import com.sun.xml.ws.db.sdo.Xsd2JavaSDOModel;
import com.sun.xml.ws.util.xml.StAXSource;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SDOSchemaCompiler {
    private List<Source> schemas = null;
    private EntityResolver entityResolver = null;

    public SDOSchemaCompiler() {
        this.resetSchema();
    }

    public void parseSchema(Source schema) {
        this.schemas.add(schema);
    }

    public void parseSchema(String systemId, Element element) {
        DOMSource src = new DOMSource(element);
        src.setSystemId(systemId);
        this.schemas.add(src);
    }

    public void parseSchema(InputSource source) {
        this.schemas.add(new SAXSource(source));
    }

    public void parseSchemas(List<Source> inputSchemas) {
        this.schemas = inputSchemas;
    }

    public void parseSchema(String systemId, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        StAXSource src = new StAXSource(xmlStreamReader, false);
        src.setSystemId(systemId);
        this.schemas.add(src);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void forcePackageName(String packageName) {
        throw new SDODatabindingException("package change name not supported");
    }

    public void resetSchema() {
        if (this.schemas == null) {
            this.schemas = new ArrayList<Source>();
        } else {
            this.schemas.clear();
        }
    }

    public Xsd2JavaSDOModel bind() {
        SDOHelperContext hc = new SDOHelperContext();
        ArrayList<SDOType> types = new ArrayList<SDOType>();
        SDODatabindingSchemaResolver schemaResolver = new SDODatabindingSchemaResolver(this.schemas, this.entityResolver);
        for (Source schema : this.schemas) {
            List list = ((SDOXSDHelper)hc.getXSDHelper()).define(schema, (SchemaResolver)schemaResolver);
            types.addAll(list);
        }
        return new Xsd2JavaSDOModel((HelperContext)hc, types);
    }
}

