/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.kerb;

import com.sun.xml.ws.security.kerb.Krb5Context;
import com.sun.xml.ws.security.kerb.MessageToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

class MicToken
extends MessageToken {
    public MicToken(Krb5Context context, byte[] tokenBytes, int tokenOffset, int tokenLen, MessageProp prop) throws GSSException {
        super(257, context, tokenBytes, tokenOffset, tokenLen, prop);
    }

    public MicToken(Krb5Context context, InputStream is, MessageProp prop) throws GSSException {
        super(257, context, is, prop);
    }

    public void verify(byte[] data, int offset, int len) throws GSSException {
        if (!this.verifySignAndSeqNumber(null, data, offset, len, null)) {
            throw new GSSException(6, -1, "Corrupt checksum or sequence number in MIC token");
        }
    }

    public void verify(InputStream data) throws GSSException {
        byte[] dataBytes = null;
        try {
            dataBytes = new byte[data.available()];
            data.read(dataBytes);
        }
        catch (IOException e) {
            throw new GSSException(6, -1, "Corrupt checksum or sequence number in MIC token");
        }
        this.verify(dataBytes, 0, dataBytes.length);
    }

    public MicToken(Krb5Context context, MessageProp prop, byte[] data, int pos, int len) throws GSSException {
        super(257, context);
        if (prop == null) {
            prop = new MessageProp(0, false);
        }
        this.genSignAndSeqNumber(prop, null, data, pos, len, null);
    }

    public MicToken(Krb5Context context, MessageProp prop, InputStream data) throws GSSException, IOException {
        super(257, context);
        byte[] dataBytes = new byte[data.available()];
        data.read(dataBytes);
        if (prop == null) {
            prop = new MessageProp(0, false);
        }
        this.genSignAndSeqNumber(prop, null, dataBytes, 0, dataBytes.length, null);
    }

    protected int getSealAlg(boolean confRequested, int qop) {
        return 65535;
    }

    public int encode(byte[] outToken, int offset) throws IOException, GSSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        super.encode(bos);
        byte[] token = bos.toByteArray();
        System.arraycopy(token, 0, outToken, offset, token.length);
        return token.length;
    }

    public byte[] encode() throws IOException, GSSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(50);
        this.encode(bos);
        return bos.toByteArray();
    }
}

