/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.servicechannel;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelWSImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class ServiceChannelWSDLGenerator {
    private static final String TCP_ENDPOINT_ADDRESS_STUB = "vnd.sun.ws.tcp://CHANGED_BY_RUNTIME";

    public static void main(String[] args) throws Exception {
        QName serviceName = WSEndpoint.getDefaultServiceName(ServiceChannelWSImpl.class);
        QName portName = WSEndpoint.getDefaultPortName(serviceName, ServiceChannelWSImpl.class);
        BindingID bindingId = BindingID.parse(ServiceChannelWSImpl.class);
        WSBinding binding = bindingId.createBinding();
        ArrayList docs = new ArrayList(0);
        WSEndpoint<ServiceChannelWSImpl> endpoint = WSEndpoint.create(ServiceChannelWSImpl.class, true, null, serviceName, portName, null, binding, null, docs, (URL)null);
        DocumentAddressResolver resolver = new DocumentAddressResolver(){

            public String getRelativeAddressFor(SDDocument current, SDDocument referenced) {
                if (current.isWSDL() && referenced.isSchema() && referenced.getURL().getProtocol().equals("file")) {
                    return referenced.getURL().getFile().substring(1);
                }
                return referenced.getURL().toExternalForm();
            }
        };
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        for (SDDocument document : endpoint.getServiceDefinition()) {
            baos.reset();
            document.writeTo(new PortAddressResolver(){

                @Nullable
                public String getAddressFor(QName serviceName, @NotNull String portName) {
                    return ServiceChannelWSDLGenerator.TCP_ENDPOINT_ADDRESS_STUB;
                }
            }, resolver, baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            FileOutputStream fos = new FileOutputStream("./etc/" + document.getURL().getFile());
            StreamSource source = new StreamSource(bais);
            StreamResult result = new StreamResult(fos);
            transformer.transform(source, result);
            fos.close();
            bais.close();
        }
        baos.close();
    }
}

