/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.commons.AbstractMOMRegistrationAware;
import com.sun.xml.ws.commons.MOMRegistrationAware;
import com.sun.xml.ws.commons.WSEndpointCollectionBasedMOMListener;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.InVmSequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistentSequenceManager;
import com.sun.xml.ws.server.WSEndpointImpl;
import com.sun.xml.ws.server.WSEndpointMOMProxy;
import java.util.WeakHashMap;
import org.glassfish.gmbal.ManagedObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SequenceManagerFactory {
    INSTANCE;

    private final WSEndpointCollectionBasedMOMListener listener;
    private final WeakHashMap<WSEndpoint, SequenceManager> sequenceManagersForDeferredRegistration = new WeakHashMap();

    private SequenceManagerFactory() {
        this.listener = new WSEndpointCollectionBasedMOMListener<SequenceManager>((Object)this, "RMSequenceManager", this.sequenceManagersForDeferredRegistration);
        this.listener.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceManager createSequenceManager(boolean persistent, String uniqueEndpointId, DeliveryQueueBuilder inboundQueueBuilder, DeliveryQueueBuilder outboundQueueBuilder, RmConfiguration configuration) {
        SequenceManagerFactory sequenceManagerFactory = INSTANCE;
        synchronized (sequenceManagerFactory) {
            AbstractMOMRegistrationAware result = persistent ? new PersistentSequenceManager(uniqueEndpointId, inboundQueueBuilder, outboundQueueBuilder, configuration) : new InVmSequenceManager(uniqueEndpointId, inboundQueueBuilder, outboundQueueBuilder, configuration);
            ManagedObjectManager mom = configuration.getManagedObjectManager();
            this.handleMOMRegistration((SequenceManager)((Object)result), mom, true);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(SequenceManager manager, RmConfiguration configuration) {
        SequenceManagerFactory sequenceManagerFactory = INSTANCE;
        synchronized (sequenceManagerFactory) {
            manager.dispose();
            ManagedObjectManager mom = configuration.getManagedObjectManager();
            this.handleMOMRegistration(manager, mom, false);
        }
    }

    private void handleMOMRegistration(SequenceManager manager, ManagedObjectManager managedObjectManager, boolean register) {
        if (manager == null || managedObjectManager == null) {
            return;
        }
        if (!this.listener.canRegisterAtMOM() && managedObjectManager instanceof WSEndpointMOMProxy) {
            WSEndpointMOMProxy endpointMOMProxy = (WSEndpointMOMProxy)managedObjectManager;
            WSEndpointImpl wsEndpoint = endpointMOMProxy.getWsEndpoint();
            if (register) {
                this.sequenceManagersForDeferredRegistration.put(wsEndpoint, manager);
            } else {
                this.sequenceManagersForDeferredRegistration.remove(wsEndpoint);
            }
        } else if (register) {
            this.listener.registerAtMOM((MOMRegistrationAware)manager, managedObjectManager);
        } else {
            this.listener.unregisterFromMOM((MOMRegistrationAware)manager, managedObjectManager);
        }
    }
}

