/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.nometadata;

import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingRegistryInfo;
import com.sun.xml.rpc.processor.config.NoMetadataModelInfo;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.JavaSimpleTypeCreator;
import com.sun.xml.rpc.processor.modeler.Modeler;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import com.sun.xml.rpc.processor.modeler.wsdl.SchemaAnalyzer;
import com.sun.xml.rpc.processor.util.ClassNameCollector;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.Binding;
import com.sun.xml.rpc.wsdl.document.BindingFault;
import com.sun.xml.rpc.wsdl.document.BindingOperation;
import com.sun.xml.rpc.wsdl.document.Documentation;
import com.sun.xml.rpc.wsdl.document.Message;
import com.sun.xml.rpc.wsdl.document.MessagePart;
import com.sun.xml.rpc.wsdl.document.OperationStyle;
import com.sun.xml.rpc.wsdl.document.PortType;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.document.soap.SOAPAddress;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBinding;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBody;
import com.sun.xml.rpc.wsdl.document.soap.SOAPFault;
import com.sun.xml.rpc.wsdl.document.soap.SOAPHeader;
import com.sun.xml.rpc.wsdl.document.soap.SOAPOperation;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import com.sun.xml.rpc.wsdl.framework.GloballyKnown;
import com.sun.xml.rpc.wsdl.framework.NoSuchEntityException;
import com.sun.xml.rpc.wsdl.framework.ParseException;
import com.sun.xml.rpc.wsdl.framework.ParserListener;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import com.sun.xml.rpc.wsdl.parser.SOAPEntityReferenceValidator;
import com.sun.xml.rpc.wsdl.parser.WSDLParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;

public class NoMetadataModeler
implements Modeler {
    private Model model;
    private Properties options;
    private ProcessorEnvironment env;
    private NoMetadataModelInfo modelInfo;
    private NamespaceMappingRegistryInfo namespaceMappingRegistry;
    private SchemaAnalyzer analyzer;
    private LocalizableMessageFactory messageFactory;
    private JavaSimpleTypeCreator javaTypes;
    private Map javaExceptions;
    private static final String OPERATION_HAS_VOID_RETURN_TYPE = "com.sun.xml.rpc.processor.modeler.wsdl.operationHasVoidReturnType";
    private static final String WSDL_DOCUMENTATION = "com.sun.xml.rpc.processor.modeler.wsdl.documentation";
    private static final String WSDL_PARAMETER_ORDER = "com.sun.xml.rpc.processor.modeler.wsdl.parameterOrder";
    private static final String WSDL_RESULT_PARAMETER = "com.sun.xml.rpc.processor.modeler.wsdl.resultParameter";

    public NoMetadataModeler(NoMetadataModelInfo modelInfo, Properties options) {
        this.modelInfo = modelInfo;
        this.env = (ProcessorEnvironment)modelInfo.getConfiguration().getEnvironment();
        this.options = options;
        this.namespaceMappingRegistry = modelInfo.getNamespaceMappingRegistry();
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.modeler");
    }

    public ProcessorEnvironment getProcessorEnvironment() {
        return this.env;
    }

    public NamespaceMappingRegistryInfo getNamespaceMappingRegistryInfo() {
        return this.namespaceMappingRegistry;
    }

    public Model getModel() {
        return this.model;
    }

    public Model buildModel() {
        try {
            WSDLParser parser = new WSDLParser();
            InputSource inputSource = new InputSource(this.modelInfo.getLocation());
            parser.addParserListener(new ParserListener(){

                public void ignoringExtension(QName name, QName parent) {
                    if (parent.equals(WSDLConstants.QNAME_TYPES) && name.getLocalPart().equals("schema") && !name.getNamespaceURI().equals("")) {
                        NoMetadataModeler.this.warn("wsdlmodeler.warning.ignoringUnrecognizedSchemaExtension", name.getNamespaceURI());
                    }
                }

                public void doneParsingEntity(QName element, Entity entity) {
                }
            });
            boolean useWSIBasicProfile = Boolean.valueOf(this.options.getProperty("useWSIBasicProfile"));
            WSDLDocument document = parser.parse(inputSource, useWSIBasicProfile);
            document.validateLocally();
            boolean validateWSDL = Boolean.valueOf(this.options.getProperty("validationWSDL"));
            if (validateWSDL) {
                document.validate(new SOAPEntityReferenceValidator());
            }
            Model model = this.internalBuildModel(document);
            ClassNameCollector collector = new ClassNameCollector();
            collector.process(model);
            if (collector.getConflictingClassNames().isEmpty()) {
                Model model2 = model;
                return model2;
            }
            try {
                StringBuffer conflictList = new StringBuffer();
                boolean first = true;
                Iterator iter = collector.getConflictingClassNames().iterator();
                while (iter.hasNext()) {
                    if (!first) {
                        conflictList.append(", ");
                    } else {
                        first = false;
                    }
                    conflictList.append((String)iter.next());
                }
                throw new ModelerException("wsdlmodeler.unsolvableNamingConflicts", conflictList.toString());
            }
            catch (ModelException e) {
                throw new ModelerException(e);
            }
            catch (ParseException e) {
                throw new ModelerException(e);
            }
            catch (ValidationException e) {
                throw new ModelerException(e);
            }
        }
        finally {
            this.analyzer = null;
        }
    }

    private Model internalBuildModel(WSDLDocument document) {
        QName modelName = new QName(document.getDefinitions().getTargetNamespaceURI(), document.getDefinitions().getName() == null ? "model" : document.getDefinitions().getName());
        Model model = new Model(modelName);
        model.setProperty("com.sun.xml.rpc.processor.model.ModelerName", this.getClass().getName());
        this.javaTypes = new JavaSimpleTypeCreator();
        this.javaExceptions = new HashMap();
        this.analyzer = new SchemaAnalyzer(document, this.modelInfo, this.options, new HashSet(), this.javaTypes);
        model.setTargetNamespaceURI(document.getDefinitions().getTargetNamespaceURI());
        NoMetadataModeler.setDocumentationIfPresent(model, document.getDefinitions().getDocumentation());
        boolean hasServices = document.getDefinitions().services().hasNext();
        if (hasServices) {
            boolean gotOne = false;
            Iterator iter = document.getDefinitions().services();
            while (iter.hasNext()) {
                com.sun.xml.rpc.wsdl.document.Service service = (com.sun.xml.rpc.wsdl.document.Service)iter.next();
                if (gotOne) {
                    throw new ModelerException("nometadatamodeler.error.moreThanOneServiceDefinition");
                }
                this.processService(service, model, document);
                gotOne = true;
            }
        } else {
            throw new ModelerException("nometadatamodeler.error.noServiceDefinitionsFound");
        }
        return model;
    }

    protected void processService(com.sun.xml.rpc.wsdl.document.Service wsdlService, Model model, WSDLDocument document) {
        QName serviceQName = NoMetadataModeler.getQNameOf(wsdlService);
        if (this.modelInfo.getServiceName() != null && !this.modelInfo.getServiceName().equals(serviceQName)) {
            throw new ModelerException("nometadatamodeler.error.incorrectServiceName", serviceQName.toString());
        }
        String serviceInterface = null;
        if (this.modelInfo.getServiceInterfaceName() != null) {
            serviceInterface = this.modelInfo.getServiceInterfaceName();
        } else {
            serviceInterface = "";
            String javaPackageName = this.getJavaPackageName(serviceQName);
            if (javaPackageName == null && this.modelInfo.getJavaPackageName() != null && !this.modelInfo.getJavaPackageName().equals("")) {
                javaPackageName = this.modelInfo.getJavaPackageName();
            }
            if (javaPackageName == null) {
                throw new ModelerException("nometadatamodeler.error.cannotMapNamespace", serviceQName.getNamespaceURI());
            }
            serviceInterface = javaPackageName + ".";
            serviceInterface = serviceInterface + this.env.getNames().validJavaClassName(wsdlService.getName());
        }
        Service service = new Service(serviceQName, new JavaInterface(serviceInterface, serviceInterface + "Impl"));
        NoMetadataModeler.setDocumentationIfPresent(service, wsdlService.getDocumentation());
        boolean gotOne = false;
        Iterator iter = wsdlService.ports();
        while (iter.hasNext()) {
            if (gotOne) {
                throw new ModelerException("nometadatamodeler.error.moreThanOnePortDefinition", wsdlService.getName());
            }
            com.sun.xml.rpc.wsdl.document.Port port = (com.sun.xml.rpc.wsdl.document.Port)iter.next();
            boolean processed = this.processPort(port, service, document);
            if (!processed) {
                throw new ModelerException("nometadatamodeler.error.failedToProcessPort", port.getName());
            }
            gotOne = true;
        }
        if (!gotOne) {
            throw new ModelerException("nometadatamodeler.error.noPortsInService", wsdlService.getName());
        }
        model.addService(service);
        this.verifyServiceInterface(service);
    }

    protected boolean processPort(com.sun.xml.rpc.wsdl.document.Port wsdlPort, Service service, WSDLDocument document) {
        try {
            QName portQName = NoMetadataModeler.getQNameOf(wsdlPort);
            if (this.modelInfo.getPortName() != null && !this.modelInfo.getPortName().equals(portQName)) {
                throw new ModelerException("nometadatamodeler.error.incorrectPortName", portQName.toString());
            }
            Port port = new Port(portQName);
            NoMetadataModeler.setDocumentationIfPresent(port, wsdlPort.getDocumentation());
            SOAPAddress soapAddress = (SOAPAddress)NoMetadataModeler.getExtensionOfType(wsdlPort, SOAPAddress.class);
            if (soapAddress == null) {
                this.warn("wsdlmodeler.warning.ignoringNonSOAPPort.noAddress", wsdlPort.getName());
                return false;
            }
            port.setAddress(soapAddress.getLocation());
            Binding binding = wsdlPort.resolveBinding(document);
            PortType portType = binding.resolvePortType(document);
            SOAPBinding soapBinding = (SOAPBinding)NoMetadataModeler.getExtensionOfType(binding, SOAPBinding.class);
            if (soapBinding == null) {
                this.warn("wsdlmodeler.warning.ignoringNonSOAPPort", wsdlPort.getName());
                return false;
            }
            if (soapBinding.getTransport() == null || !soapBinding.getTransport().equals("http://schemas.xmlsoap.org/soap/http")) {
                this.warn("wsdlmodeler.warning.ignoringSOAPBinding.nonHTTPTransport", wsdlPort.getName());
                return false;
            }
            boolean hasOverloadedOperations = false;
            HashSet<String> operationNames = new HashSet<String>();
            Iterator iter = portType.operations();
            while (iter.hasNext()) {
                com.sun.xml.rpc.wsdl.document.Operation operation = (com.sun.xml.rpc.wsdl.document.Operation)iter.next();
                if (operationNames.contains(operation.getName())) {
                    hasOverloadedOperations = true;
                    break;
                }
                operationNames.add(operation.getName());
            }
            if (hasOverloadedOperations) {
                throw new ModelerException("nometadatamodeler.error.overloadedOperationsFound", wsdlPort.getName());
            }
            port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortName", NoMetadataModeler.getQNameOf(wsdlPort));
            port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName", NoMetadataModeler.getQNameOf(portType));
            port.setProperty("com.sun.xml.rpc.processor.model.WSDLBindingName", NoMetadataModeler.getQNameOf(binding));
            boolean hasOperations = false;
            Iterator iter2 = binding.operations();
            while (iter2.hasNext()) {
                Operation operation;
                BindingOperation bindingOperation = (BindingOperation)iter2.next();
                com.sun.xml.rpc.wsdl.document.Operation portTypeOperation = null;
                Set operations = portType.getOperationsNamed(bindingOperation.getName());
                if (operations.size() == 0) {
                    throw new ModelerException("wsdlmodeler.invalid.bindingOperation.notInPortType", new Object[]{bindingOperation.getName(), binding.getName()});
                }
                if (operations.size() == 1) {
                    portTypeOperation = (com.sun.xml.rpc.wsdl.document.Operation)operations.iterator().next();
                } else {
                    boolean found = false;
                    String expectedInputName = bindingOperation.getInput().getName();
                    String expectedOutputName = bindingOperation.getOutput().getName();
                    for (com.sun.xml.rpc.wsdl.document.Operation candidateOperation : operations) {
                        if (expectedInputName == null) {
                            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.missingInputName", new Object[]{bindingOperation.getName(), binding.getName()});
                        }
                        if (expectedOutputName == null) {
                            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.missingOutputName", new Object[]{bindingOperation.getName(), binding.getName()});
                        }
                        if (!expectedInputName.equals(candidateOperation.getInput().getName()) || !expectedOutputName.equals(candidateOperation.getOutput().getName())) continue;
                        if (found) {
                            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.multipleMatchingOperations", new Object[]{bindingOperation.getName(), binding.getName()});
                        }
                        found = true;
                        portTypeOperation = candidateOperation;
                    }
                    if (!found) {
                        throw new ModelerException("wsdlmodeler.invalid.bindingOperation.notFound", new Object[]{bindingOperation.getName(), binding.getName()});
                    }
                }
                if ((operation = this.processSOAPOperation(new ProcessSOAPOperationInfo(port, wsdlPort, portTypeOperation, bindingOperation, soapBinding, document))) == null) continue;
                port.addOperation(operation);
                hasOperations = true;
            }
            if (!hasOperations) {
                this.warn("wsdlmodeler.warning.noOperationsInPort", wsdlPort.getName());
            }
            port.setClientHandlerChainInfo(this.modelInfo.getClientHandlerChainInfo());
            port.setServerHandlerChainInfo(this.modelInfo.getServerHandlerChainInfo());
            service.addPort(port);
            this.createJavaInterfaceForPort(port);
            this.verifyJavaInterface(port);
            String stubClassName = this.env.getNames().stubFor(port, null);
            String tieClassName = this.env.getNames().tieFor(port, null);
            port.setProperty("com.sun.xml.rpc.processor.model.StubClassName", stubClassName);
            port.setProperty("com.sun.xml.rpc.processor.model.TieClassName", tieClassName);
            return true;
        }
        catch (NoSuchEntityException e) {
            return false;
        }
    }

    protected Operation processSOAPOperation(ProcessSOAPOperationInfo info) {
        Operation operation = new Operation(new QName(null, info.bindingOperation.getName()));
        NoMetadataModeler.setDocumentationIfPresent(operation, info.portTypeOperation.getDocumentation());
        if (info.portTypeOperation.getStyle() != OperationStyle.REQUEST_RESPONSE && info.portTypeOperation.getStyle() != OperationStyle.ONE_WAY) {
            this.warn("wsdlmodeler.warning.ignoringOperation.notRequestResponse", info.portTypeOperation.getName());
            return null;
        }
        SOAPStyle soapStyle = info.soapBinding.getStyle();
        SOAPOperation soapOperation = (SOAPOperation)NoMetadataModeler.getExtensionOfType(info.bindingOperation, SOAPOperation.class);
        if (soapOperation != null) {
            if (soapOperation.getStyle() != null) {
                soapStyle = soapOperation.getStyle();
            }
            if (soapOperation.getSOAPAction() != null) {
                operation.setSOAPAction(soapOperation.getSOAPAction());
            }
        }
        operation.setStyle(soapStyle);
        String uniqueOperationName = info.portTypeOperation.getName();
        info.operation = operation;
        info.uniqueOperationName = uniqueOperationName;
        if (soapStyle == SOAPStyle.RPC) {
            return this.processSOAPOperationRPCStyle(info);
        }
        throw new ModelerException("nometadatamodeler.error.documentStyleOperation", operation.getName().getLocalPart());
    }

    protected Operation processSOAPOperationRPCStyle(ProcessSOAPOperationInfo info) {
        SOAPHeader header;
        Extension extension;
        com.sun.xml.rpc.wsdl.document.Fault aFault;
        Iterator iter2;
        com.sun.xml.rpc.wsdl.document.Fault portTypeFault;
        BindingFault bindingFault;
        MessagePart part;
        boolean isRequestResponse = info.portTypeOperation.getStyle() == OperationStyle.REQUEST_RESPONSE;
        Request request = new Request();
        Response response = new Response();
        SOAPBody soapRequestBody = (SOAPBody)NoMetadataModeler.getExtensionOfType(info.bindingOperation.getInput(), SOAPBody.class);
        if (soapRequestBody == null) {
            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.inputMissingSoapBody", new Object[]{info.bindingOperation.getName()});
        }
        SOAPBody soapResponseBody = null;
        if (isRequestResponse && (soapResponseBody = (SOAPBody)NoMetadataModeler.getExtensionOfType(info.bindingOperation.getOutput(), SOAPBody.class)) == null) {
            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.outputMissingSoapBody", new Object[]{info.bindingOperation.getName()});
        }
        if (soapRequestBody.isLiteral() || !NoMetadataModeler.tokenListContains(soapRequestBody.getEncodingStyle(), "http://schemas.xmlsoap.org/soap/encoding/") || soapResponseBody != null && (soapResponseBody.isLiteral() || !NoMetadataModeler.tokenListContains(soapResponseBody.getEncodingStyle(), "http://schemas.xmlsoap.org/soap/encoding/"))) {
            throw new ModelerException("nometadatamodeler.error.operationNotEncoded", info.portTypeOperation.getName());
        }
        String requestNamespaceURI = soapRequestBody.getNamespace();
        if (requestNamespaceURI == null) {
            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.inputSoapBody.missingNamespace", new Object[]{info.bindingOperation.getName()});
        }
        String responseNamespaceURI = null;
        if (isRequestResponse && (responseNamespaceURI = soapResponseBody.getNamespace()) == null) {
            throw new ModelerException("wsdlmodeler.invalid.bindingOperation.outputSoapBody.missingNamespace", new Object[]{info.bindingOperation.getName()});
        }
        String structureNamePrefix = null;
        QName portTypeName = (QName)info.modelPort.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName");
        structureNamePrefix = portTypeName != null ? this.getNonQualifiedNameFor(portTypeName) : this.getNonQualifiedNameFor(info.modelPort.getName());
        structureNamePrefix = structureNamePrefix + "_";
        QName requestBodyName = new QName(requestNamespaceURI, info.portTypeOperation.getName());
        RPCRequestUnorderedStructureType requestBodyType = new RPCRequestUnorderedStructureType(requestBodyName);
        JavaStructureType requestBodyJavaType = new JavaStructureType(this.makePackageQualified(StringUtils.capitalize(structureNamePrefix + info.uniqueOperationName) + "_RequestStruct", requestBodyName), false, requestBodyType);
        requestBodyType.setJavaType(requestBodyJavaType);
        Block requestBodyBlock = new Block(requestBodyName, requestBodyType);
        request.addBodyBlock(requestBodyBlock);
        RPCResponseStructureType responseBodyType = null;
        JavaStructureType responseBodyJavaType = null;
        Block responseBodyBlock = null;
        if (isRequestResponse) {
            QName responseBodyName = new QName(responseNamespaceURI, info.portTypeOperation.getName() + "Response");
            responseBodyType = new RPCResponseStructureType(responseBodyName);
            responseBodyJavaType = new JavaStructureType(this.makePackageQualified(StringUtils.capitalize(structureNamePrefix + info.uniqueOperationName + "_ResponseStruct"), responseBodyName), false, responseBodyType);
            responseBodyType.setJavaType(responseBodyJavaType);
            responseBodyBlock = new Block(responseBodyName, responseBodyType);
            response.addBodyBlock(responseBodyBlock);
        }
        if (soapRequestBody.getParts() != null) {
            this.warn("wsdlmodeler.warning.ignoringOperation.cannotHandleBodyPartsAttribute", info.portTypeOperation.getName());
            return null;
        }
        Message inputMessage = info.portTypeOperation.getInput().resolveMessage(info.document);
        Message outputMessage = null;
        if (isRequestResponse) {
            outputMessage = info.portTypeOperation.getOutput().resolveMessage(info.document);
        }
        String parameterOrder = info.portTypeOperation.getParameterOrder();
        ArrayList<String> parameterList = null;
        boolean buildParameterList = false;
        if (parameterOrder != null) {
            parameterList = XmlUtil.parseTokenList(parameterOrder);
        } else {
            parameterList = new ArrayList<String>();
            buildParameterList = true;
        }
        HashSet<String> partNames = new HashSet<String>();
        HashSet<String> inputParameterNames = new HashSet<String>();
        HashSet<String> outputParameterNames = new HashSet<String>();
        String resultParameterName = null;
        Iterator iter = inputMessage.parts();
        while (iter.hasNext()) {
            part = (MessagePart)iter.next();
            if (part.getDescriptorKind() != SchemaKinds.XSD_TYPE) {
                throw new ModelerException("wsdlmodeler.invalid.message.partMustHaveTypeDescriptor", new Object[]{inputMessage.getName(), part.getName()});
            }
            partNames.add(part.getName());
            inputParameterNames.add(part.getName());
            if (!buildParameterList) continue;
            parameterList.add(part.getName());
        }
        if (isRequestResponse) {
            iter = outputMessage.parts();
            while (iter.hasNext()) {
                part = (MessagePart)iter.next();
                if (part.getDescriptorKind() != SchemaKinds.XSD_TYPE) {
                    throw new ModelerException("wsdlmodeler.invalid.message.partMustHaveTypeDescriptor", new Object[]{outputMessage.getName(), part.getName()});
                }
                partNames.add(part.getName());
                if (buildParameterList && resultParameterName == null) {
                    resultParameterName = part.getName();
                    continue;
                }
                outputParameterNames.add(part.getName());
                if (!buildParameterList || inputParameterNames.contains(part.getName())) continue;
                parameterList.add(part.getName());
            }
        }
        if (!buildParameterList) {
            String partName;
            for (String name : parameterList) {
                if (!partNames.contains(name)) {
                    throw new ModelerException("wsdlmodeler.invalid.parameterorder.parameter", new Object[]{name, info.operation.getName().getLocalPart()});
                }
                partNames.remove(name);
            }
            if (partNames.size() > 1) {
                throw new ModelerException("wsdlmodeler.invalid.parameterOrder.tooManyUnmentionedParts", new Object[]{info.operation.getName().getLocalPart()});
            }
            if (partNames.size() == 1 && outputParameterNames.contains(partName = (String)partNames.iterator().next())) {
                resultParameterName = partName;
            }
        }
        if (resultParameterName == null) {
            info.operation.setProperty(OPERATION_HAS_VOID_RETURN_TYPE, "true");
        } else {
            MessagePart part2 = outputMessage.getPart(resultParameterName);
            SOAPType soapType = this.analyzer.schemaTypeToSOAPType(part2.getDescriptor());
            SOAPStructureMember member = new SOAPStructureMember(new QName(null, part2.getName()), soapType);
            JavaStructureMember javaMember = new JavaStructureMember(this.env.getNames().validJavaMemberName(part2.getName()), soapType.getJavaType(), member, false);
            javaMember.setReadMethod(this.env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setWriteMethod(this.env.getNames().getJavaMemberWriteMethod(javaMember));
            member.setJavaStructureMember(javaMember);
            responseBodyType.add(member);
            responseBodyJavaType.add(javaMember);
            Parameter parameter = new Parameter(this.env.getNames().validJavaMemberName(part2.getName()));
            parameter.setEmbedded(true);
            parameter.setType(soapType);
            parameter.setBlock(responseBodyBlock);
            response.addParameter(parameter);
            info.operation.setProperty(WSDL_RESULT_PARAMETER, parameter.getName());
        }
        ArrayList<String> definitiveParameterList = new ArrayList<String>();
        for (String name : parameterList) {
            boolean isInput = inputParameterNames.contains(name);
            boolean isOutput = outputParameterNames.contains(name);
            SOAPType soapType = null;
            Parameter inParameter = null;
            if (isInput && isOutput && !inputMessage.getPart(name).getDescriptor().equals(outputMessage.getPart(name).getDescriptor())) {
                throw new ModelerException("wsdlmodeler.invalid.parameter.differentTypes", new Object[]{name, info.operation.getName().getLocalPart()});
            }
            if (isInput) {
                MessagePart part3 = inputMessage.getPart(name);
                soapType = this.analyzer.schemaTypeToSOAPType(part3.getDescriptor());
                SOAPStructureMember member = new SOAPStructureMember(new QName(null, part3.getName()), soapType);
                JavaStructureMember javaMember = new JavaStructureMember(this.env.getNames().validJavaMemberName(part3.getName()), soapType.getJavaType(), member, false);
                javaMember.setReadMethod(this.env.getNames().getJavaMemberReadMethod(javaMember));
                javaMember.setWriteMethod(this.env.getNames().getJavaMemberWriteMethod(javaMember));
                member.setJavaStructureMember(javaMember);
                requestBodyType.add(member);
                requestBodyJavaType.add(javaMember);
                inParameter = new Parameter(this.env.getNames().validJavaMemberName(part3.getName()));
                inParameter.setEmbedded(true);
                inParameter.setType(soapType);
                inParameter.setBlock(requestBodyBlock);
                request.addParameter(inParameter);
                definitiveParameterList.add(inParameter.getName());
            }
            if (!isOutput) continue;
            throw new ModelerException("nometadatamodeler.outputParameterEncountered", new Object[]{info.portTypeOperation.getName(), name});
        }
        HashSet<QName> duplicateNames = new HashSet<QName>();
        HashSet<QName> faultNames = new HashSet<QName>();
        Iterator iter3 = info.bindingOperation.faults();
        while (iter3.hasNext()) {
            MessagePart faultPart;
            bindingFault = (BindingFault)iter3.next();
            portTypeFault = null;
            iter2 = info.portTypeOperation.faults();
            while (iter2.hasNext()) {
                aFault = (com.sun.xml.rpc.wsdl.document.Fault)iter2.next();
                if (!aFault.getName().equals(bindingFault.getName())) continue;
                if (portTypeFault != null) {
                    throw new ModelerException("wsdlmodeler.invalid.bindingFault.notUnique", new Object[]{bindingFault.getName(), info.bindingOperation.getName()});
                }
                portTypeFault = aFault;
            }
            if (portTypeFault == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.notFound", new Object[]{bindingFault.getName(), info.bindingOperation.getName()});
            }
            SOAPFault soapFault = (SOAPFault)NoMetadataModeler.getExtensionOfType(bindingFault, SOAPFault.class);
            if (soapFault == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.outputMissingSoapFault", new Object[]{bindingFault.getName(), info.bindingOperation.getName()});
            }
            Message faultMessage = portTypeFault.resolveMessage(info.document);
            Iterator iter22 = faultMessage.parts();
            if (!iter22.hasNext()) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.emptyMessage", new Object[]{bindingFault.getName(), faultMessage.getName()});
            }
            String faultNamespaceURI = soapFault.getNamespace();
            QName faultQName = new QName(faultNamespaceURI, (faultPart = (MessagePart)iter22.next()).getName());
            if (faultNames.contains(faultQName)) {
                duplicateNames.add(faultQName);
                continue;
            }
            faultNames.add(faultQName);
        }
        iter3 = info.bindingOperation.faults();
        while (iter3.hasNext()) {
            bindingFault = (BindingFault)iter3.next();
            portTypeFault = null;
            iter2 = info.portTypeOperation.faults();
            while (iter2.hasNext()) {
                aFault = (com.sun.xml.rpc.wsdl.document.Fault)iter2.next();
                if (!aFault.getName().equals(bindingFault.getName())) continue;
                if (portTypeFault != null) {
                    throw new ModelerException("wsdlmodeler.invalid.bindingFault.notUnique", new Object[]{bindingFault.getName(), info.bindingOperation.getName()});
                }
                portTypeFault = aFault;
            }
            if (portTypeFault == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.notFound", new Object[]{bindingFault.getName(), info.bindingOperation.getName()});
            }
            Fault fault = new Fault(portTypeFault.getMessage().getLocalPart());
            SOAPFault soapFault = (SOAPFault)NoMetadataModeler.getExtensionOfType(bindingFault, SOAPFault.class);
            if (soapFault == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.outputMissingSoapFault", new Object[]{bindingFault.getName(), info.bindingOperation.getName()});
            }
            if (soapFault.isLiteral() || !NoMetadataModeler.tokenListContains(soapFault.getEncodingStyle(), "http://schemas.xmlsoap.org/soap/encoding/")) {
                this.warn("wsdlmodeler.warning.ignoringFault.notEncoded", new Object[]{bindingFault.getName(), info.bindingOperation.getName()});
                continue;
            }
            String faultNamespaceURI = soapFault.getNamespace();
            if (faultNamespaceURI == null) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.missingNamespace", new Object[]{bindingFault.getName(), info.bindingOperation.getName()});
            }
            Message faultMessage = portTypeFault.resolveMessage(info.document);
            Iterator iter23 = faultMessage.parts();
            if (!iter23.hasNext()) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.emptyMessage", new Object[]{bindingFault.getName(), faultMessage.getName()});
            }
            MessagePart faultPart = (MessagePart)iter23.next();
            if (NoMetadataModeler.isIncorrectFaultPartName(faultPart.getName())) {
                throw new ModelerException("nometadatamodeler.error.incorrectFaultPartName", new Object[]{info.portTypeOperation.getName(), bindingFault.getName(), faultPart.getName()});
            }
            QName faultQName = new QName(faultNamespaceURI, faultPart.getName());
            if (duplicateNames.contains(faultQName)) {
                this.warn("wsdlmodeler.duplicate.fault.part.name", new Object[]{bindingFault.getName(), info.portTypeOperation.getName(), faultPart.getName()});
                continue;
            }
            if (iter23.hasNext()) {
                throw new ModelerException("wsdlmodeler.invalid.bindingFault.messageHasMoreThanOnePart", new Object[]{bindingFault.getName(), faultMessage.getName()});
            }
            if (faultPart.getDescriptorKind() != SchemaKinds.XSD_TYPE) {
                throw new ModelerException("wsdlmodeler.invalid.message.partMustHaveTypeDescriptor", new Object[]{faultMessage.getName(), faultPart.getName()});
            }
            if (NoMetadataModeler.isIncorrectFaultPartType(faultPart.getDescriptor())) {
                throw new ModelerException("nometadatamodeler.error.incorrectFaultPartType", new Object[]{info.portTypeOperation.getName(), bindingFault.getName(), faultPart.getName(), faultPart.getDescriptor()});
            }
            SOAPType faultType = this.analyzer.schemaTypeToSOAPType(faultPart.getDescriptor());
            Block faultBlock = new Block(faultQName, faultType);
            fault.setBlock(faultBlock);
            response.addFaultBlock(faultBlock);
            info.operation.addFault(fault);
        }
        boolean explicitServiceContext = Boolean.valueOf(this.options.getProperty("explicitServiceContext"));
        Iterator iter4 = info.bindingOperation.getInput().extensions();
        while (iter4.hasNext()) {
            extension = (Extension)iter4.next();
            if (!(extension instanceof SOAPHeader)) continue;
            header = (SOAPHeader)extension;
            this.warn("wsdlmodeler.warning.ignoringHeader", new Object[]{header.getPart(), info.bindingOperation.getName()});
        }
        if (isRequestResponse) {
            iter4 = info.bindingOperation.getOutput().extensions();
            while (iter4.hasNext()) {
                extension = (Extension)iter4.next();
                if (!(extension instanceof SOAPHeader)) continue;
                header = (SOAPHeader)extension;
                this.warn("wsdlmodeler.warning.ignoringHeader", new Object[]{header.getPart(), info.bindingOperation.getName()});
            }
        }
        info.operation.setProperty(WSDL_PARAMETER_ORDER, definitiveParameterList);
        info.operation.setRequest(request);
        if (isRequestResponse) {
            info.operation.setResponse(response);
        }
        return info.operation;
    }

    protected void createJavaInterfaceForPort(Port port) {
        QName portTypeName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName");
        QName bindingName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLBindingName");
        String interfaceName = null;
        interfaceName = this.modelInfo.getInterfaceName() != null ? this.modelInfo.getInterfaceName() : (portTypeName != null ? this.makePackageQualified(this.env.getNames().validJavaClassName(this.getNonQualifiedNameFor(portTypeName)), portTypeName) : this.makePackageQualified(this.env.getNames().validJavaClassName(this.getNonQualifiedNameFor(port.getName())), port.getName()));
        JavaInterface intf = new JavaInterface(interfaceName);
        HashSet methodNames = new HashSet();
        HashSet methodSignatures = new HashSet();
        Iterator iter = port.getOperations();
        while (iter.hasNext()) {
            Operation operation = (Operation)iter.next();
            this.createJavaMethodForOperation(port, operation, intf, methodNames, methodSignatures);
        }
        port.setJavaInterface(intf);
    }

    private void createJavaMethodForOperation(Port port, Operation operation, JavaInterface intf, Set methodNames, Set methodSignatures) {
        Fault fault;
        JavaType returnType;
        boolean operationHasVoidReturnType;
        String candidateName = this.env.getNames().validJavaMemberName(operation.getName().getLocalPart());
        JavaMethod method = new JavaMethod(candidateName);
        Request request = operation.getRequest();
        Iterator requestBodyBlocks = request.getBodyBlocks();
        Block requestBlock = requestBodyBlocks.hasNext() ? (Block)request.getBodyBlocks().next() : null;
        Response response = operation.getResponse();
        Iterator responseBodyBlocks = null;
        Block responseBlock = null;
        if (response != null) {
            responseBodyBlocks = response.getBodyBlocks();
            responseBlock = responseBodyBlocks.hasNext() ? (Block)response.getBodyBlocks().next() : null;
        }
        String signature = candidateName;
        List parameterOrder = (List)operation.getProperty(WSDL_PARAMETER_ORDER);
        if (parameterOrder == null) {
            Iterator iter = request.getParameters();
            while (iter.hasNext()) {
                Parameter parameter = (Parameter)iter.next();
                if (parameter.getJavaParameter() != null) {
                    throw new ModelerException("wsdlmodeler.invalidOperation", operation.getName().getLocalPart());
                }
                JavaType parameterType = parameter.getType().getJavaType();
                JavaParameter javaParameter = new JavaParameter(this.env.getNames().validJavaMemberName(parameter.getName()), parameterType, parameter, parameter.getLinkedParameter() != null);
                method.addParameter(javaParameter);
                parameter.setJavaParameter(javaParameter);
                signature = signature + "%" + parameterType.getName();
            }
            operationHasVoidReturnType = operation.getProperty(OPERATION_HAS_VOID_RETURN_TYPE) != null;
            Parameter resultParameter = null;
            if (response != null) {
                Iterator iter2 = response.getParameters();
                while (iter2.hasNext()) {
                    if (!operationHasVoidReturnType && resultParameter == null) {
                        resultParameter = (Parameter)iter2.next();
                        if (resultParameter.getJavaParameter() != null) {
                            throw new ModelerException("wsdlmodeler.invalidOperation", operation.getName().getLocalPart());
                        }
                        if (resultParameter.getLinkedParameter() != null) {
                            throw new ModelerException("wsdlmodeler.resultIsInOutParameter", operation.getName().getLocalPart());
                        }
                        if (resultParameter.getBlock() != responseBlock) {
                            throw new ModelerException("wsdlmodeler.invalidOperation", operation.getName().getLocalPart());
                        }
                        returnType = resultParameter.getType().getJavaType();
                        method.setReturnType(returnType);
                        continue;
                    }
                    Parameter parameter = (Parameter)iter2.next();
                    if (parameter.getJavaParameter() != null) {
                        throw new ModelerException("wsdlmodeler.invalidOperation", operation.getName().getLocalPart());
                    }
                    JavaParameter javaParameter = null;
                    if (parameter.getLinkedParameter() != null) {
                        javaParameter = parameter.getLinkedParameter().getJavaParameter();
                    }
                    JavaType parameterType = parameter.getType().getJavaType();
                    parameterType.setHolder(true);
                    parameterType.setHolderPresent(false);
                    if (javaParameter == null) {
                        javaParameter = new JavaParameter(this.env.getNames().validJavaMemberName(parameter.getName()), parameterType, parameter, true);
                    }
                    parameter.setJavaParameter(javaParameter);
                    if (parameter.getLinkedParameter() != null) continue;
                    method.addParameter(javaParameter);
                }
            }
            if (response == null || operationHasVoidReturnType) {
                method.setReturnType(this.javaTypes.VOID_JAVATYPE);
            }
        } else {
            operationHasVoidReturnType = operation.getProperty(OPERATION_HAS_VOID_RETURN_TYPE) != null;
            for (String parameterName : parameterOrder) {
                JavaParameter javaParameter;
                JavaType parameterType;
                Parameter linkedParameter;
                Parameter responseParameter;
                Parameter requestParameter = request.getParameterByName(parameterName);
                Parameter parameter = responseParameter = response != null ? response.getParameterByName(parameterName) : null;
                if (requestParameter == null && responseParameter == null) {
                    throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operation.getName().getLocalPart());
                }
                if (requestParameter != null) {
                    linkedParameter = requestParameter.getLinkedParameter();
                    if (responseParameter == null || linkedParameter == null) {
                        parameterType = requestParameter.getType().getJavaType();
                        javaParameter = new JavaParameter(this.env.getNames().validJavaMemberName(requestParameter.getName()), parameterType, requestParameter, false);
                        method.addParameter(javaParameter);
                        requestParameter.setJavaParameter(javaParameter);
                        signature = signature + "%" + parameterType.getName();
                        continue;
                    }
                    if (responseParameter != linkedParameter) {
                        throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operation.getName().getLocalPart());
                    }
                    parameterType = responseParameter.getType().getJavaType();
                    javaParameter = new JavaParameter(this.env.getNames().validJavaMemberName(responseParameter.getName()), parameterType, responseParameter, true);
                    parameterType.setHolder(true);
                    parameterType.setHolderPresent(false);
                    requestParameter.setJavaParameter(javaParameter);
                    responseParameter.setJavaParameter(javaParameter);
                    method.addParameter(javaParameter);
                    requestParameter.setJavaParameter(javaParameter);
                    responseParameter.setJavaParameter(javaParameter);
                    signature = signature + "%" + parameterType.getName();
                    continue;
                }
                if (responseParameter == null) continue;
                linkedParameter = responseParameter.getLinkedParameter();
                if (linkedParameter != null) {
                    throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operation.getName().getLocalPart());
                }
                parameterType = responseParameter.getType().getJavaType();
                parameterType.setHolder(true);
                parameterType.setHolderPresent(false);
                javaParameter = new JavaParameter(this.env.getNames().validJavaMemberName(responseParameter.getName()), parameterType, responseParameter, true);
                responseParameter.setJavaParameter(javaParameter);
                method.addParameter(javaParameter);
                signature = signature + "%" + parameterType.getName();
            }
            String resultParameterName = (String)operation.getProperty(WSDL_RESULT_PARAMETER);
            if (resultParameterName == null) {
                if (!operationHasVoidReturnType) {
                    throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operation.getName().getLocalPart());
                }
                method.setReturnType(this.javaTypes.VOID_JAVATYPE);
            } else {
                if (operationHasVoidReturnType) {
                    throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operation.getName().getLocalPart());
                }
                Parameter resultParameter = response.getParameterByName(resultParameterName);
                returnType = resultParameter.getType().getJavaType();
                method.setReturnType(returnType);
            }
        }
        String operationName = candidateName;
        if (methodSignatures.contains(signature)) {
            throw new ModelerException("nometadatamodeler.duplicateMethodSignature", operationName);
        }
        methodSignatures.add(signature);
        methodNames.add(method.getName());
        operation.setJavaMethod(method);
        intf.addMethod(method);
        Iterator iter = operation.getFaults();
        while (iter != null && iter.hasNext()) {
            fault = (Fault)iter.next();
            this.createJavaException(fault, port, operationName);
        }
        Iterator iter3 = operation.getFaults();
        while (iter3.hasNext()) {
            fault = (Fault)iter3.next();
            JavaException javaException = fault.getJavaException();
            method.addException(javaException.getName());
        }
    }

    protected boolean createJavaException(Fault fault, Port port, String operationName) {
        String exceptionName = null;
        String propertyName = this.env.getNames().validJavaMemberName(fault.getName());
        SOAPType faultType = (SOAPType)fault.getBlock().getType();
        if (faultType instanceof SOAPStructureType) {
            throw new ModelerException("wsdlmodeler.invalidState.modelingOperation", operationName);
        }
        exceptionName = this.makePackageQualified(this.env.getNames().validJavaClassName(fault.getName()), port.getName());
        SOAPOrderedStructureType soapStruct = new SOAPOrderedStructureType(new QName(faultType.getName().getNamespaceURI(), fault.getName()));
        QName memberName = new QName(fault.getBlock().getName().getNamespaceURI(), StringUtils.capitalize(faultType.getName().getLocalPart()));
        SOAPStructureMember soapMember = new SOAPStructureMember(memberName, faultType);
        JavaStructureMember javaMember = new JavaStructureMember(memberName.getLocalPart(), faultType.getJavaType(), soapMember);
        soapMember.setJavaStructureMember(javaMember);
        javaMember.setConstructorPos(0);
        javaMember.setReadMethod("get" + memberName.getLocalPart());
        javaMember.setInherited(soapMember.isInherited());
        soapMember.setJavaStructureMember(javaMember);
        soapStruct.add(soapMember);
        JavaException existingJavaException = (JavaException)this.javaExceptions.get(exceptionName);
        if (existingJavaException != null && existingJavaException.getName().equals(exceptionName) && ((SOAPType)existingJavaException.getOwner()).getName().equals(soapStruct.getName())) {
            if (faultType instanceof SOAPStructureType) {
                fault.getBlock().setType((SOAPType)existingJavaException.getOwner());
            }
            fault.setJavaException(existingJavaException);
            this.createRelativeJavaExceptions(fault, port, operationName);
            return false;
        }
        JavaException javaException = new JavaException(exceptionName, false, soapStruct);
        soapStruct.setJavaType(javaException);
        this.javaExceptions.put(javaException.getName(), javaException);
        Iterator members = soapStruct.getMembers();
        SOAPStructureMember member = null;
        int i = 0;
        while (members.hasNext()) {
            member = (SOAPStructureMember)members.next();
            JavaStructureMember javaMember2 = member.getJavaStructureMember();
            javaMember2.setConstructorPos(i);
            javaException.add(javaMember2);
            ++i;
        }
        if (faultType instanceof SOAPStructureType) {
            fault.getBlock().setType(soapStruct);
        }
        fault.setJavaException(javaException);
        this.createRelativeJavaExceptions(fault, port, operationName);
        return true;
    }

    protected void createRelativeJavaExceptions(Fault fault, Port port, String operationName) {
        Iterator subfaults;
        if (fault.getParentFault() != null && fault.getParentFault().getJavaException() == null) {
            this.createJavaException(fault.getParentFault(), port, operationName);
            fault.getParentFault().getJavaException().addSubclass(fault.getJavaException());
            ((SOAPStructureType)fault.getParentFault().getJavaException().getOwner()).addSubtype((SOAPStructureType)fault.getJavaException().getOwner());
        }
        if ((subfaults = fault.getSubfaults()) != null) {
            while (subfaults.hasNext()) {
                Fault subfault = (Fault)subfaults.next();
                if (subfault.getJavaException() != null) continue;
                boolean didCreateNewException = this.createJavaException(subfault, port, operationName);
                fault.getJavaException().addSubclass(subfault.getJavaException());
                ((SOAPStructureType)fault.getJavaException().getOwner()).addSubtype((SOAPStructureType)subfault.getJavaException().getOwner());
            }
        }
    }

    protected void verifyJavaInterface(Port port) {
        JavaInterface javaInterface = port.getJavaInterface();
        Class remoteInterface = this.getClassForNameOrFail(javaInterface.getName());
        if (!Remote.class.isAssignableFrom(remoteInterface)) {
            throw new ModelerException("nometadatamodeler.error.notRemoteInterface", remoteInterface.getName());
        }
        HashMap javaTypeMap = new HashMap();
        Iterator iter = javaInterface.getMethods();
        while (iter.hasNext()) {
            JavaParameter param;
            Iterator iter2;
            int index;
            Class<?>[] argTypes;
            JavaMethod javaMethod = (JavaMethod)iter.next();
            Method[] methods = remoteInterface.getMethods();
            Method method = null;
            boolean found = false;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(javaMethod.getName()) || (argTypes = methods[i].getParameterTypes()).length != javaMethod.getParameterCount()) continue;
                index = 0;
                iter2 = javaMethod.getParameters();
                while (iter2.hasNext() && (param = (JavaParameter)iter2.next()).getType().getName().equals(NoMetadataModeler.getReadableClassName(argTypes[index]))) {
                    ++index;
                }
                if (index < argTypes.length) continue;
                Class<?> returnType = methods[i].getReturnType();
                if (!javaMethod.getReturnType().getName().equals(NoMetadataModeler.getReadableClassName(returnType))) continue;
                found = true;
                method = methods[i];
                break;
            }
            if (found) {
                Class<?>[] exceptionTypes = method.getExceptionTypes();
                Iterator iter22 = javaMethod.getExceptions();
                while (iter22.hasNext()) {
                    JavaException javaException = (JavaException)iter22.next();
                    boolean foundException = false;
                    for (int i = 0; i < exceptionTypes.length; ++i) {
                        if (!javaException.getName().equals(exceptionTypes[i].getName())) continue;
                        foundException = true;
                        this.getConstructorForSignatureOrFail(exceptionTypes[i], new Class[]{String.class});
                        break;
                    }
                    if (foundException) continue;
                    throw new ModelerException("nometadatamodeler.error.exceptionNotFound", new Object[]{javaMethod.getName(), javaException.getName()});
                }
                argTypes = method.getParameterTypes();
                index = 0;
                iter2 = javaMethod.getParameters();
                while (iter2.hasNext()) {
                    param = (JavaParameter)iter2.next();
                    javaTypeMap.put(param.getType(), argTypes[index]);
                    ++index;
                }
                javaTypeMap.put(javaMethod.getReturnType(), method.getReturnType());
                continue;
            }
            throw new ModelerException("nometadatamodeler.error.methodNotFound", new Object[]{javaMethod.getName(), remoteInterface.getName()});
        }
        for (Map.Entry entry : javaTypeMap.entrySet()) {
            this.verifyJavaType((JavaType)entry.getKey(), (Class)entry.getValue());
        }
    }

    protected static String getReadableClassName(Class klass) {
        if (klass.isArray()) {
            return NoMetadataModeler.getReadableClassName(klass.getComponentType()) + "[]";
        }
        if (klass.isPrimitive()) {
            if (klass == Boolean.TYPE) {
                return "boolean";
            }
            if (klass == Character.TYPE) {
                return "char";
            }
            if (klass == Byte.TYPE) {
                return "byte";
            }
            if (klass == Short.TYPE) {
                return "short";
            }
            if (klass == Integer.TYPE) {
                return "int";
            }
            if (klass == Long.TYPE) {
                return "long";
            }
            if (klass == Float.TYPE) {
                return "float";
            }
            if (klass == Double.TYPE) {
                return "double";
            }
            if (klass == Void.TYPE) {
                return "void";
            }
            throw new IllegalArgumentException();
        }
        return klass.getName();
    }

    protected void verifyJavaType(JavaType javaType, Class klass) {
        JavaArrayType javaArrayType;
        if (javaType.isHolder()) {
            throw new ModelerException("nometadatamodeler.error.holderDetected");
        }
        if (javaType instanceof JavaArrayType && (javaArrayType = (JavaArrayType)javaType).getElementType() instanceof JavaArrayType) {
            throw new ModelerException("nometadatamodeler.error.nestedArrayDetected");
        }
        if (javaType instanceof JavaStructureType) {
            // empty if block
        }
    }

    protected void verifyServiceInterface(Service service) {
        JavaInterface theInterface = service.getJavaInterface();
        Class serviceInterface = this.getClassForNameOrNull(theInterface.getName());
        if (serviceInterface != null) {
            if (!javax.xml.rpc.Service.class.isAssignableFrom(serviceInterface)) {
                throw new ModelerException("nometadatamodeler.error.notServiceInterface", serviceInterface.getName());
            }
            Iterator iter = service.getPorts();
            while (iter.hasNext()) {
                Port port = (Port)iter.next();
                String remoteInterfaceName = port.getJavaInterface().getName();
                this.env.getNames();
                String portName = Names.getPortName(port);
                Class remoteInterface = this.getClassForNameOrFail(remoteInterfaceName);
                Method getPort = this.getMethodForNameAndSignatureAndReturnTypeOrFail(serviceInterface, "get" + portName, new Class[0], remoteInterface);
            }
        }
    }

    protected void warn(String key) {
        this.env.warn(this.messageFactory.getMessage(key));
    }

    protected void warn(String key, String arg) {
        this.env.warn(this.messageFactory.getMessage(key, arg));
    }

    protected void warn(String key, Object[] args) {
        this.env.warn(this.messageFactory.getMessage(key, args));
    }

    protected Class getClassForNameOrNull(String name) {
        try {
            return RmiUtils.getClassForName(name, this.env.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected Class getClassForNameOrFail(String name) {
        try {
            return RmiUtils.getClassForName(name, this.env.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("nometadatamodeler.error.classNotFound", name);
        }
    }

    protected Method getMethodForNameAndSignatureAndReturnTypeOrFail(Class klass, String methodName, Class[] argTypes, Class returnType) {
        try {
            Method method = klass.getMethod(methodName, argTypes);
            if (method.getReturnType() != returnType) {
                throw new ModelerException("nometadatamodeler.error.methodNotFound", new Object[]{methodName, klass.getName()});
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new ModelerException("nometadatamodeler.error.methodNotFound", new Object[]{methodName, klass.getName()});
        }
    }

    protected Constructor getConstructorForSignatureOrFail(Class klass, Class[] argTypes) {
        try {
            Constructor constructor = klass.getConstructor(argTypes);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new ModelerException("nometadatamodeler.error.constructorNotFound", new Object[]{klass.getName()});
        }
    }

    protected String getJavaPackageName(QName name) {
        NamespaceMappingInfo i;
        String packageName = null;
        if (this.modelInfo.getNamespaceMappingRegistry() != null && (i = this.modelInfo.getNamespaceMappingRegistry().getNamespaceMappingInfo(name)) != null) {
            return i.getJavaPackageName();
        }
        return packageName;
    }

    protected String makePackageQualified(String s, QName name) {
        String javaPackageName = this.getJavaPackageName(name);
        if (javaPackageName != null) {
            return javaPackageName + "." + s;
        }
        if (this.modelInfo.getJavaPackageName() != null && !this.modelInfo.getJavaPackageName().equals("")) {
            return this.modelInfo.getJavaPackageName() + "." + s;
        }
        return s;
    }

    protected QName makePackageQualified(QName name) {
        return new QName(name.getNamespaceURI(), this.makePackageQualified(name.getLocalPart(), name));
    }

    protected String getNonQualifiedNameFor(QName name) {
        return this.env.getNames().validJavaClassName(name.getLocalPart());
    }

    protected static boolean isIncorrectFaultPartName(String s) {
        return !s.equals("message");
    }

    protected static boolean isIncorrectFaultPartType(QName n) {
        return !n.equals(SchemaConstants.QNAME_TYPE_STRING);
    }

    protected static Extension getExtensionOfType(Extensible extensible, Class type) {
        Iterator iter = extensible.extensions();
        while (iter.hasNext()) {
            Extension extension = (Extension)iter.next();
            if (!extension.getClass().equals(type)) continue;
            return extension;
        }
        return null;
    }

    protected static void setDocumentationIfPresent(ModelObject obj, Documentation documentation) {
        if (documentation != null && documentation.getContent() != null) {
            obj.setProperty(WSDL_DOCUMENTATION, documentation.getContent());
        }
    }

    protected static QName getQNameOf(GloballyKnown entity) {
        return new QName(entity.getDefining().getTargetNamespaceURI(), entity.getName());
    }

    protected static boolean tokenListContains(String tokenList, String target) {
        if (tokenList == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(tokenList, " ");
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (!target.equals(s)) continue;
            return true;
        }
        return false;
    }

    public class ProcessSOAPOperationInfo {
        public Port modelPort;
        public com.sun.xml.rpc.wsdl.document.Port port;
        public com.sun.xml.rpc.wsdl.document.Operation portTypeOperation;
        public BindingOperation bindingOperation;
        public SOAPBinding soapBinding;
        public WSDLDocument document;
        public Operation operation;
        public String uniqueOperationName;

        public ProcessSOAPOperationInfo(Port modelPort, com.sun.xml.rpc.wsdl.document.Port port, com.sun.xml.rpc.wsdl.document.Operation portTypeOperation, BindingOperation bindingOperation, SOAPBinding soapBinding, WSDLDocument document) {
            this.modelPort = modelPort;
            this.port = port;
            this.portTypeOperation = portTypeOperation;
            this.bindingOperation = bindingOperation;
            this.soapBinding = soapBinding;
            this.document = document;
        }
    }
}

