/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.exporter;

import com.sun.xml.rpc.encoding.simpletype.XSDDateTimeCalendarEncoder;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.streaming.XMLReaderFactoryImpl;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.util.VersionUtil;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;

public abstract class ImporterBase {
    protected InputStream in;
    protected XMLReader reader;
    protected Map id2obj;
    protected Set immediateClassNames;
    protected String targetModelVersion = "";
    protected static final QName DEF_OBJ_NAME = new QName("object");
    protected static final QName DEF_IMM_OBJ_NAME = new QName("iobject");
    protected static final QName PROP_NAME = new QName("property");
    protected static final String ATTR_VERSION = "version";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_SUBJECT = "subject";

    public ImporterBase(InputStream s) {
        this.in = s;
        try {
            this.reader = new XMLReaderFactoryImpl().createXMLReader(new GZIPInputStream(s));
        }
        catch (IOException e) {
            throw new XMLReaderException("xmlreader.ioException", new LocalizableExceptionAdapter(e));
        }
    }

    protected void initialize() {
        this.id2obj = new HashMap();
        this.id2obj.put(new Integer(0), null);
        this.immediateClassNames = new HashSet();
        this.immediateClassNames.add("java.lang.Boolean");
        this.immediateClassNames.add("java.lang.Integer");
        this.immediateClassNames.add("java.lang.Short");
        this.immediateClassNames.add("java.lang.Long");
        this.immediateClassNames.add("java.lang.Float");
        this.immediateClassNames.add("java.lang.Double");
        this.immediateClassNames.add("java.lang.Byte");
        this.immediateClassNames.add("[I");
        this.immediateClassNames.add("[B");
        this.immediateClassNames.add("[Ljava.lang.String;");
        this.immediateClassNames.add("java.util.GregorianCalendar");
        this.immediateClassNames.add("java.lang.String");
        this.immediateClassNames.add("java.math.BigDecimal");
        this.immediateClassNames.add("java.math.BigInteger");
        this.immediateClassNames.add("java.util.ArrayList");
        this.immediateClassNames.add("java.util.HashSet");
        this.immediateClassNames.add("java.util.HashMap");
        this.immediateClassNames.add("javax.xml.namespace.QName");
        this.immediateClassNames.add("com.sun.xml.rpc.wsdl.document.soap.SOAPStyle");
        this.immediateClassNames.add("com.sun.xml.rpc.wsdl.document.soap.SOAPUse");
        this.immediateClassNames.add("com.sun.xml.rpc.soap.SOAPVersion");
        this.immediateClassNames.add("java.net.URI");
    }

    protected Object internalDoImport() {
        this.initialize();
        this.reader.nextElementContent();
        if (this.reader.getState() != 1) {
            this.failInvalidSyntax(this.reader);
        }
        if (!this.reader.getName().equals(this.getContainerName())) {
            this.failInvalidSyntax(this.reader);
        }
        this.checkVersion();
        while (this.reader.nextElementContent() != 2) {
            if (this.reader.getName().equals(this.getDefineImmediateObjectName())) {
                this.parseDefineImmediateObject(this.reader);
                continue;
            }
            if (this.reader.getName().equals(this.getDefineObjectName())) {
                this.parseDefineObject(this.reader);
                continue;
            }
            if (this.reader.getName().equals(this.getPropertyName())) {
                this.parseProperty(this.reader);
                continue;
            }
            this.failInvalidSyntax(this.reader);
        }
        XMLReaderUtil.verifyReaderState(this.reader, 2);
        return this.id2obj.get(new Integer(1));
    }

    protected void parseDefineImmediateObject(XMLReader reader) {
        Object obj;
        String idAttr = this.getRequiredAttribute(reader, ATTR_ID);
        String typeAttr = this.getRequiredAttribute(reader, ATTR_TYPE);
        if (!this.immediateClassNames.contains(typeAttr)) {
            this.failInvalidClass(reader, typeAttr);
        }
        String valueAttr = this.getRequiredAttribute(reader, ATTR_VALUE);
        Integer id = this.parseId(reader, idAttr);
        if (this.getObjectForId(id) != null) {
            this.failInvalidId(reader, id);
        }
        if ((obj = this.createImmediateObject(reader, typeAttr, valueAttr)) == null) {
            this.checkMinorMinorAndPatchVersion(reader);
        }
        this.id2obj.put(id, obj);
        this.verifyNoContent(reader);
    }

    protected void parseDefineObject(XMLReader reader) {
        Object obj;
        String idAttr = this.getRequiredAttribute(reader, ATTR_ID);
        String typeAttr = this.getRequiredAttribute(reader, ATTR_TYPE);
        Integer id = this.parseId(reader, idAttr);
        if (this.getObjectForId(id) != null) {
            this.failInvalidId(reader, id);
        }
        if ((obj = this.createInstanceOfType(reader, typeAttr)) == null) {
            this.checkMinorMinorAndPatchVersion(reader);
        }
        this.id2obj.put(id, obj);
        this.verifyNoContent(reader);
    }

    protected void parseProperty(XMLReader reader) {
        Integer valueId;
        String nameAttr = this.getRequiredAttribute(reader, ATTR_NAME);
        String subjectAttr = this.getRequiredAttribute(reader, ATTR_SUBJECT);
        String valueAttr = this.getRequiredAttribute(reader, ATTR_VALUE);
        Object subject = this.mustGetObjectForId(reader, this.parseId(reader, subjectAttr));
        if (subject == null) {
            this.failInvalidSyntax(reader);
        }
        Object value = this.isNullId(valueId = this.parseId(reader, valueAttr)) ? null : this.mustGetObjectForId(reader, valueId);
        try {
            this.property(reader, subject, nameAttr, value);
        }
        catch (ClassCastException e) {
            this.failInvalidProperty(reader, subject, nameAttr, value);
        }
        this.verifyNoContent(reader);
    }

    protected Object createImmediateObject(XMLReader reader, String type, String value) {
        block68: {
            if (type.equals("java.lang.Integer")) {
                try {
                    return Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    this.failInvalidLiteral(reader, type, value);
                    break block68;
                }
            }
            if (type.equals("java.lang.Short")) {
                try {
                    return Short.valueOf(value);
                }
                catch (NumberFormatException e) {
                    this.failInvalidLiteral(reader, type, value);
                    break block68;
                }
            }
            if (type.equals("java.lang.Long")) {
                try {
                    return Long.valueOf(value);
                }
                catch (NumberFormatException e) {
                    this.failInvalidLiteral(reader, type, value);
                    break block68;
                }
            }
            if (type.equals("java.lang.Byte")) {
                try {
                    return Byte.valueOf(value);
                }
                catch (NumberFormatException e) {
                    this.failInvalidLiteral(reader, type, value);
                    break block68;
                }
            }
            if (type.equals("java.lang.Float")) {
                try {
                    return Float.valueOf(value);
                }
                catch (NumberFormatException e) {
                    this.failInvalidLiteral(reader, type, value);
                    break block68;
                }
            }
            if (type.equals("java.lang.Double")) {
                try {
                    return Double.valueOf(value);
                }
                catch (NumberFormatException e) {
                    this.failInvalidLiteral(reader, type, value);
                    break block68;
                }
            }
            if (type.equals("java.math.BigDecimal")) {
                try {
                    return new BigDecimal(value);
                }
                catch (NumberFormatException e) {
                    this.failInvalidLiteral(reader, type, value);
                    break block68;
                }
            }
            if (type.equals("java.math.BigInteger")) {
                try {
                    return new BigInteger(value);
                }
                catch (NumberFormatException e) {
                    this.failInvalidLiteral(reader, type, value);
                    break block68;
                }
            }
            if (type.equals("java.lang.String")) {
                return value;
            }
            if (type.equals("javax.xml.namespace.QName")) {
                try {
                    return QName.valueOf(value);
                }
                catch (IllegalArgumentException e) {
                    this.failInvalidLiteral(reader, type, value);
                    break block68;
                }
            }
            if (type.equals("java.lang.Boolean")) {
                return Boolean.valueOf(value);
            }
            if (type.equals("com.sun.xml.rpc.wsdl.document.soap.SOAPStyle")) {
                if (value.equals("rpc")) {
                    return SOAPStyle.RPC;
                }
                if (value.equals("document")) {
                    return SOAPStyle.DOCUMENT;
                }
                this.failInvalidLiteral(reader, type, value);
            } else if (type.equals("com.sun.xml.rpc.wsdl.document.soap.SOAPUse")) {
                if (value.equals("literal")) {
                    return SOAPUse.LITERAL;
                }
                if (value.equals("encoded")) {
                    return SOAPUse.ENCODED;
                }
                this.failInvalidLiteral(reader, type, value);
            } else if (type.equals("com.sun.xml.rpc.soap.SOAPVersion")) {
                if (value.equals(SOAPVersion.SOAP_11.toString())) {
                    return SOAPVersion.SOAP_11;
                }
                if (value.equals(SOAPVersion.SOAP_12.toString())) {
                    return SOAPVersion.SOAP_12;
                }
                this.failInvalidLiteral(reader, type, value);
            } else {
                if (type.equals("[I")) {
                    List l = XmlUtil.parseTokenList(value);
                    int[] result = new int[l.size()];
                    int i = 0;
                    for (String element : l) {
                        try {
                            result[i] = Integer.parseInt(element);
                        }
                        catch (NumberFormatException e) {
                            this.failInvalidLiteral(reader, type, value);
                        }
                        ++i;
                    }
                    return result;
                }
                if (type.equals("[B")) {
                    List l = XmlUtil.parseTokenList(value);
                    byte[] result = new byte[l.size()];
                    int i = 0;
                    for (String element : l) {
                        try {
                            result[i] = Byte.parseByte(element);
                        }
                        catch (NumberFormatException e) {
                            this.failInvalidLiteral(reader, type, value);
                        }
                        ++i;
                    }
                    return result;
                }
                if (type.equals("[Ljava.lang.String;")) {
                    List l = XmlUtil.parseTokenList(value);
                    String[] result = new String[l.size()];
                    int i = 0;
                    for (String element : l) {
                        try {
                            result[i] = element;
                        }
                        catch (NumberFormatException e) {
                            this.failInvalidLiteral(reader, type, value);
                        }
                        ++i;
                    }
                    return result;
                }
                if (type.equals("java.util.ArrayList")) {
                    List l = XmlUtil.parseTokenList(value);
                    ArrayList<Object> result = new ArrayList<Object>();
                    for (String element : l) {
                        result.add(this.mustGetObjectForId(reader, this.parseId(reader, element)));
                    }
                    return result;
                }
                if (type.equals("java.util.HashSet")) {
                    List l = XmlUtil.parseTokenList(value);
                    HashSet<Object> result = new HashSet<Object>();
                    for (String element : l) {
                        result.add(this.mustGetObjectForId(reader, this.parseId(reader, element)));
                    }
                    return result;
                }
                if (type.equals("java.util.HashMap")) {
                    List l = XmlUtil.parseTokenList(value);
                    HashMap<Object, Object> result = new HashMap<Object, Object>();
                    Iterator iter = l.iterator();
                    while (iter.hasNext()) {
                        String entryKey = (String)iter.next();
                        if (!iter.hasNext()) {
                            this.failInvalidLiteral(reader, type, value);
                        }
                        String entryValue = (String)iter.next();
                        result.put(this.mustGetObjectForId(reader, this.parseId(reader, entryKey)), this.mustGetObjectForId(reader, this.parseId(reader, entryValue)));
                    }
                    return result;
                }
                if (type.equals("java.net.URI")) {
                    try {
                        return new URI(value);
                    }
                    catch (URISyntaxException e) {
                        this.failInvalidLiteral(reader, type, value);
                    }
                } else if (type.equals("java.util.GregorianCalendar")) {
                    try {
                        return XSDDateTimeCalendarEncoder.getInstance().stringToObject(value, null);
                    }
                    catch (Exception e) {
                        this.failInvalidLiteral(reader, type, value);
                    }
                } else {
                    this.failInvalidLiteral(reader, type, value);
                }
            }
        }
        return null;
    }

    protected void verifyNoContent(XMLReader reader) {
        if (reader.nextElementContent() != 2) {
            this.failInvalidSyntax(reader);
        }
    }

    protected String getRequiredAttribute(XMLReader reader, String name) {
        Attributes attributes = reader.getAttributes();
        String value = attributes.getValue(name);
        if (value == null) {
            this.failInvalidSyntax(reader);
        }
        return value;
    }

    protected Integer parseId(XMLReader reader, String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            this.failInvalidSyntax(reader);
            return null;
        }
    }

    protected boolean isNullId(Integer id) {
        return id == 0;
    }

    protected Object getObjectForId(Integer id) {
        return this.id2obj.get(id);
    }

    protected Object mustGetObjectForId(XMLReader reader, Integer id) {
        Object result = this.getObjectForId(id);
        if (result == null) {
            this.failInvalidId(reader, id);
        }
        return result;
    }

    protected Object createInstanceOfType(XMLReader reader, String typename) {
        try {
            Class<?> klass = Class.forName(typename);
            return klass.newInstance();
        }
        catch (InstantiationException e) {
            this.checkMinorMinorAndPatchVersion(reader);
            this.failInvalidClass(reader, typename);
        }
        catch (IllegalAccessException e) {
            this.checkMinorMinorAndPatchVersion(reader);
            this.failInvalidClass(reader, typename);
        }
        catch (ClassNotFoundException e) {
            this.checkMinorMinorAndPatchVersion(reader);
            this.failInvalidClass(reader, typename);
        }
        return null;
    }

    protected void property(XMLReader reader, Object subject, String name, Object value) {
        this.failInvalidClass(reader, subject.getClass().getName());
    }

    protected abstract QName getContainerName();

    private void checkVersion() {
        if (this.getVersion() != null) {
            int[] currentVersion;
            this.targetModelVersion = this.getRequiredAttribute(this.reader, ATTR_VERSION);
            int[] targetVersion = VersionUtil.getCanonicalVersion(this.targetModelVersion);
            if (targetVersion[0] > (currentVersion = VersionUtil.getCanonicalVersion(this.getVersion()))[0] || targetVersion[0] == currentVersion[0] && currentVersion[1] > currentVersion[1]) {
                this.failInvalidVersion(this.reader, String.valueOf(targetVersion[0]) + "." + String.valueOf(targetVersion[1]) + "." + String.valueOf(targetVersion[2]) + "." + String.valueOf(targetVersion[3]));
            }
        }
    }

    private void checkMinorMinorAndPatchVersion(XMLReader reader) {
        int[] currentVersion;
        int[] targetVersion;
        if (this.getVersion() != null && ((targetVersion = VersionUtil.getCanonicalVersion(this.getTargetVersion()))[2] > (currentVersion = VersionUtil.getCanonicalVersion(this.getVersion()))[2] || targetVersion[2] == currentVersion[2] && targetVersion[3] > currentVersion[3])) {
            this.failInvalidMinorMinorOrPatchVersion(reader, String.valueOf(targetVersion[0]) + "." + String.valueOf(targetVersion[1]) + "." + String.valueOf(targetVersion[2]) + "." + String.valueOf(targetVersion[3]), this.getVersion());
        }
    }

    protected String getVersion() {
        return null;
    }

    protected String getTargetVersion() {
        return null;
    }

    protected QName getDefineObjectName() {
        return DEF_OBJ_NAME;
    }

    protected QName getDefineImmediateObjectName() {
        return DEF_IMM_OBJ_NAME;
    }

    protected QName getPropertyName() {
        return PROP_NAME;
    }

    protected abstract void failInvalidSyntax(XMLReader var1);

    protected abstract void failInvalidVersion(XMLReader var1, String var2);

    protected abstract void failInvalidMinorMinorOrPatchVersion(XMLReader var1, String var2, String var3);

    protected abstract void failInvalidClass(XMLReader var1, String var2);

    protected abstract void failInvalidId(XMLReader var1, Integer var2);

    protected abstract void failInvalidLiteral(XMLReader var1, String var2, String var3);

    protected abstract void failInvalidProperty(XMLReader var1, Object var2, String var3, Object var4);
}

