/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.verifier;

import com.sun.xml.ws.security.spi.AlternativeSelector;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsernameOrX509AlternativeSelector
implements AlternativeSelector {
    @Override
    public MessagePolicy selectAlternative(ProcessingContext ctx, List<MessagePolicy> alternatives, SecurityPolicy recvdPolicy) {
        SupportingTokenType reqMsgTokenType = this.determineTokenType(recvdPolicy);
        for (MessagePolicy mp : alternatives) {
            SupportingTokenType alternativeTokenType = this.determineTokenType(mp);
            if (reqMsgTokenType == SupportingTokenType.UNKNOWN || !reqMsgTokenType.equals((Object)alternativeTokenType)) continue;
            return mp;
        }
        return null;
    }

    @Override
    public boolean supportsAlternatives(List<MessagePolicy> alternatives) {
        if (alternatives.size() != 2) {
            return false;
        }
        SupportingTokenType firstAlternativeType = this.determineTokenType(alternatives.get(0));
        if (firstAlternativeType == SupportingTokenType.UNKNOWN) {
            return false;
        }
        SupportingTokenType secondAlternativeType = this.determineTokenType(alternatives.get(1));
        if (secondAlternativeType == SupportingTokenType.UNKNOWN) {
            return false;
        }
        return firstAlternativeType != secondAlternativeType;
    }

    private SupportingTokenType determineTokenType(SecurityPolicy recvdPolicy) {
        SupportingTokenType ret = SupportingTokenType.UNKNOWN;
        if (recvdPolicy instanceof MessagePolicy) {
            MessagePolicy pol = (MessagePolicy)recvdPolicy;
            for (int i = 0; i < pol.size(); ++i) {
                try {
                    WSSPolicy p = (WSSPolicy)pol.get(i);
                    if (PolicyTypeUtil.usernameTokenBinding(p) || PolicyTypeUtil.usernameTokenBinding(p.getFeatureBinding())) {
                        ret = SupportingTokenType.USERNAME;
                        break;
                    }
                    if (!PolicyTypeUtil.x509CertificateBinding(p) && !PolicyTypeUtil.x509CertificateBinding(p.getFeatureBinding())) continue;
                    ret = SupportingTokenType.X509;
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SupportingTokenType {
        USERNAME,
        X509,
        UNKNOWN;

    }
}

