/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.ic;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.impl.WSTrustContractImpl;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ICContractImpl
extends WSTrustContractImpl {
    @Override
    protected void handleExtension(BaseSTSRequest request, BaseSTSResponse response, IssuedTokenContext context) throws WSTrustException {
        Map claimedAttributes = (Map)context.getOtherProperties().get("cliamedAttributes");
        this.handleDisplayToken((RequestSecurityToken)request, (RequestSecurityTokenResponse)response, claimedAttributes);
    }

    private void handleDisplayToken(RequestSecurityToken rst, RequestSecurityTokenResponse rstr, Map<QName, List<String>> claimedAttrs) throws WSTrustException {
        List<Object> list = rst.getExtensionElements();
        boolean displayToken = false;
        for (int i = 0; i < list.size(); ++i) {
            String localName;
            Object ele = list.get(i);
            if (!(ele instanceof Element) || !"RequestDisplayToken".equals(localName = ((Element)ele).getLocalName())) continue;
            displayToken = true;
            break;
        }
        if (displayToken) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                Document doc = builder.newDocument();
                Element rdt = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RequestedDisplayToken");
                rdt.setAttribute("xmlns", "http://schemas.xmlsoap.org/ws/2005/05/identity");
                Element dt = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayToken");
                dt.setAttribute("xml:lang", "en-us");
                rdt.appendChild(dt);
                Set<Map.Entry<QName, List<String>>> entries = claimedAttrs.entrySet();
                for (Map.Entry<QName, List<String>> entry : entries) {
                    QName attrKey = entry.getKey();
                    List<String> values = entry.getValue();
                    if (values == null || values.size() <= 0 || "NameID".equals(attrKey.getLocalPart())) continue;
                    Element dc = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayClaim");
                    dc.setAttribute("xmlns", "http://schemas.xmlsoap.org/ws/2005/05/identity");
                    String uri = attrKey.getNamespaceURI() + "/" + attrKey.getLocalPart();
                    dc.setAttribute("Uri", uri);
                    dt.appendChild(dc);
                    Element dtg = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag");
                    dtg.appendChild(doc.createTextNode(attrKey.getLocalPart()));
                    dc.appendChild(dtg);
                    String displayValue = values.get(0);
                    Element dtv = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayValue");
                    dtv.appendChild(doc.createTextNode(displayValue));
                    dc.appendChild(dtv);
                }
                rstr.getAny().add(rdt);
            }
            catch (Exception ex) {
                throw new WSTrustException(ex.getMessage(), ex);
            }
        }
    }
}

