/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import java.io.ByteArrayOutputStream;

public class UnsyncByteArrayOutputStream
extends ByteArrayOutputStream {
    int size = 4096;
    byte[] buf = null;
    int pos = 0;

    public UnsyncByteArrayOutputStream() {
        this.buf = new byte[this.size];
    }

    public UnsyncByteArrayOutputStream(int size) {
        this.size = size;
        this.buf = new byte[size];
    }

    @Override
    public void write(byte[] arg0) {
        int newPos = this.pos + arg0.length;
        if (newPos > this.size) {
            this.expandSize();
        }
        System.arraycopy(arg0, 0, this.buf, this.pos, arg0.length);
        this.pos = newPos;
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        int newPos = this.pos + arg2;
        if (newPos > this.size) {
            this.expandSize();
        }
        System.arraycopy(arg0, arg1, this.buf, this.pos, arg2);
        this.pos = newPos;
    }

    @Override
    public void write(int arg0) {
        if (this.pos >= this.size) {
            this.expandSize();
        }
        this.buf[this.pos++] = (byte)arg0;
    }

    @Override
    public byte[] toByteArray() {
        byte[] result = new byte[this.pos];
        System.arraycopy(this.buf, 0, result, 0, this.pos);
        return result;
    }

    @Override
    public void reset() {
        this.pos = 0;
    }

    void expandSize() {
        int newSize = this.size << 2;
        byte[] newBuf = new byte[newSize];
        System.arraycopy(this.buf, 0, newBuf, 0, this.pos);
        this.buf = newBuf;
        this.size = newSize;
    }

    public int getLength() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.buf;
    }
}

