/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.impl.SecurityTokenException;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SecurityContextTokenImpl
extends SecurityHeaderBlockImpl
implements SecurityContextToken,
SecurityToken {
    private String securityContextId = null;
    private String instance = null;
    private List extElements = null;
    private String wsuId = null;
    private Document contextDocument = null;

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, SecurityContextTokenImpl.class);
    }

    public SecurityContextTokenImpl(Document contextDocument, String contextId, String instance, String wsuId, List extElements) throws XWSSecurityException {
        this.securityContextId = contextId;
        this.instance = instance;
        this.wsuId = wsuId;
        this.extElements = extElements;
        this.contextDocument = contextDocument;
    }

    public SecurityContextTokenImpl(SOAPElement sct) throws XWSSecurityException {
        this.setSOAPElement(sct);
        this.contextDocument = this.getOwnerDocument();
        if (!"SecurityContextToken".equals(this.getLocalName()) || !XMLUtil.inWsscNS(this)) {
            throw new SecurityTokenException("Expected wsc:SecurityContextToken Element, but Found " + this.getPrefix() + ":" + this.getLocalName());
        }
        String wsuId = this.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (!"".equals(wsuId)) {
            this.setId(wsuId);
        }
        Iterator children = this.getChildElements();
        Node object = null;
        while (children.hasNext()) {
            object = (Node)children.next();
            if (object.getNodeType() != 1) continue;
            SOAPElement element = (SOAPElement)object;
            if ("Identifier".equals(element.getLocalName()) && XMLUtil.inWsscNS(element)) {
                this.securityContextId = element.getFirstChild().getNodeValue();
                continue;
            }
            if ("Instance".equals(element.getLocalName()) && XMLUtil.inWsscNS(element)) {
                this.instance = element.getFirstChild().getNodeValue();
                continue;
            }
            this.extElements.add(object);
        }
        if (this.securityContextId == null) {
            throw new XWSSecurityException("Missing Identifier subelement in SecurityContextToken");
        }
    }

    @Override
    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        if (this.delegateElement != null) {
            return this.delegateElement;
        }
        try {
            this.setSOAPElement((SOAPElement)this.contextDocument.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:SecurityContextToken"));
            this.addNamespaceDeclaration("wsc", "http://schemas.xmlsoap.org/ws/2005/02/sc");
            if (this.securityContextId == null) {
                throw new XWSSecurityException("Missing SecurityContextToken Identifier");
            }
            this.addChildElement("Identifier", "wsc").addTextNode(this.securityContextId);
            if (this.instance != null) {
                this.addChildElement("Instance", "wsc").addTextNode(this.instance);
            }
            if (this.wsuId != null) {
                this.setWsuIdAttr((Element)((Object)this), this.wsuId);
            }
            if (this.extElements != null) {
                for (int i = 0; i < this.extElements.size(); ++i) {
                    Element element = (Element)this.extElements.get(i);
                    Node newElement = this.delegateElement.getOwnerDocument().importNode(element, true);
                    this.appendChild(newElement);
                }
            }
        }
        catch (SOAPException se) {
            throw new SecurityTokenException("There was an error creating SecurityContextToken " + se.getMessage());
        }
        return super.getAsSoapElement();
    }

    public Document getContextDocument() {
        return this.contextDocument;
    }

    @Override
    public String getType() {
        return "http://schemas.xmlsoap.org/ws/2005/02/sc/sct";
    }

    @Override
    public Object getTokenValue() {
        return this;
    }

    public void setId(String wsuId) {
        this.wsuId = wsuId;
    }

    @Override
    public String getWsuId() {
        return this.wsuId;
    }

    @Override
    public URI getIdentifier() {
        try {
            return new URI(this.securityContextId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getSCId() {
        return this.securityContextId;
    }

    @Override
    public String getInstance() {
        return this.instance;
    }

    @Override
    public List getExtElements() {
        return this.extElements;
    }
}

