/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.message;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Codecs;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceFeature;
import org.jvnet.ws.EnvelopeStyle;
import org.jvnet.ws.EnvelopeStyleFeature;
import org.jvnet.ws.message.MessageContext;

public class MessageContextFactory
extends org.jvnet.ws.message.MessageContextFactory {
    private WSFeatureList features;
    private Codec soapCodec;
    private Codec xmlCodec;
    private EnvelopeStyleFeature envelopeStyle;
    private EnvelopeStyle.Style singleSoapStyle;

    public MessageContextFactory(WebServiceFeature[] wsf) {
        this(new WebServiceFeatureList(wsf));
    }

    public MessageContextFactory(WSFeatureList wsf) {
        this.features = wsf;
        this.envelopeStyle = this.features.get(EnvelopeStyleFeature.class);
        if (this.envelopeStyle == null) {
            this.envelopeStyle = new EnvelopeStyleFeature(EnvelopeStyle.Style.SOAP11);
            this.features.mergeFeatures(new WebServiceFeature[]{this.envelopeStyle}, false);
        }
        for (EnvelopeStyle.Style s : this.envelopeStyle.getStyles()) {
            if (s.isXML()) {
                if (this.xmlCodec != null) continue;
                this.xmlCodec = Codecs.createXMLCodec(this.features);
                continue;
            }
            if (this.soapCodec == null) {
                this.soapCodec = Codecs.createSOAPBindingCodec(this.features);
            }
            this.singleSoapStyle = s;
        }
    }

    @Override
    protected org.jvnet.ws.message.MessageContextFactory newFactory(WebServiceFeature ... f) {
        return new MessageContextFactory(f);
    }

    @Override
    public MessageContext createContext() {
        return this.packet(null);
    }

    @Override
    public MessageContext createContext(SOAPMessage soap) {
        return this.packet(Messages.create(soap));
    }

    @Override
    public MessageContext createContext(Source m, EnvelopeStyle.Style envelopeStyle) {
        return this.packet(Messages.create(m, SOAPVersion.from(envelopeStyle)));
    }

    @Override
    public MessageContext createContext(Source m) {
        return this.packet(Messages.create(m, SOAPVersion.from(this.singleSoapStyle)));
    }

    @Override
    public MessageContext createContext(InputStream in, String contentType) throws IOException {
        Packet p = this.packet(null);
        this.soapCodec.decode(in, contentType, p);
        return p;
    }

    private Packet packet(Message m) {
        Packet p = new Packet();
        p.codec = this.soapCodec;
        if (m != null) {
            p.setMessage(m);
        }
        return p;
    }

    @Override
    @Deprecated
    public MessageContext doCreate() {
        return this.packet(null);
    }

    @Override
    @Deprecated
    public MessageContext doCreate(SOAPMessage m) {
        return this.createContext(m);
    }

    @Override
    @Deprecated
    public MessageContext doCreate(Source x, SOAPVersion soapVersion) {
        return this.packet(Messages.create(x, soapVersion));
    }
}

