/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.EncodingException;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.literal.LiteralObjectSerializerBase;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class LiteralArraySerializer
extends LiteralObjectSerializerBase {
    protected Class javaType;
    protected Class componentType;
    protected InternalTypeMappingRegistry typeRegistry = null;
    protected JAXRPCSerializer componentSerializer;
    protected JAXRPCDeserializer componentDeserializer;

    public LiteralArraySerializer(QName type, boolean isNullable, String encodingStyle, Class javaType, JAXRPCSerializer componentSerializer, Class componentType) {
        super(type, isNullable, encodingStyle, false);
        this.componentSerializer = componentSerializer;
        this.componentDeserializer = (JAXRPCDeserializer)((Object)componentSerializer);
        this.javaType = javaType;
        this.componentType = componentType;
    }

    public LiteralArraySerializer(QName type, boolean isNullable, String encodingStyle, boolean encodeType, Class javaType, JAXRPCSerializer componentSerializer, Class componentType) {
        super(type, isNullable, encodingStyle, encodeType);
        this.javaType = javaType;
        this.componentSerializer = componentSerializer;
        this.componentType = componentType;
    }

    private void init(QName type, boolean isNullable, String encodingStyle, boolean encodeType) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.isNullable = isNullable;
        this.encodingStyle = encodingStyle;
        this.encodeType = encodeType;
    }

    public QName getXmlType() {
        return this.type;
    }

    public boolean getEncodeType() {
        return false;
    }

    public CombinedSerializer getInnermostSerializer() {
        return (CombinedSerializer)this.componentSerializer;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void serialize(Object value, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) {
        try {
            this.internalSerialize(value, name, writer, context);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new SerializationException(e);
        }
        catch (Exception e) {
            throw new SerializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public Object deserialize(QName name, XMLReader reader, SOAPDeserializationContext context) {
        try {
            return this.internalDeserialize(name, reader, context);
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    protected void internalSerialize(Object obj, QName name, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        context.beginSerializing(obj);
        boolean pushedEncodingStyle = false;
        if (this.encodingStyle != null) {
            pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
        }
        if (this.encodeType) {
            String attrVal = XMLWriterUtil.encodeQName(writer, this.type);
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, attrVal);
        }
        if (obj == null) {
            if (!this.isNullable) {
                throw new SerializationException("literal.unexpectedNull");
            }
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        } else {
            this.writeAdditionalNamespaceDeclarations(obj, writer);
            this.doSerializeAttributes(obj, writer, context);
            this.doSerialize(obj, writer, context);
        }
        if (pushedEncodingStyle) {
            context.popEncodingStyle();
        }
        context.doneSerializing(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalDeserialize(QName name, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        boolean pushedEncodingStyle = context.processEncodingStyle(reader);
        try {
            QName actualName;
            context.verifyEncodingStyle(this.encodingStyle);
            if (name != null && !(actualName = reader.getName()).equals(name)) {
                throw new DeserializationException("xsd.unexpectedElementName", new Object[]{name.toString(), actualName.toString()});
            }
            this.verifyType(reader);
            Attributes attrs = reader.getAttributes();
            String nullVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            boolean isNull = nullVal != null && SerializerBase.decodeBoolean(nullVal);
            Object obj = null;
            if (isNull) {
                if (!this.isNullable) {
                    throw new DeserializationException("xsd.unexpectedNull");
                }
                reader.next();
            } else {
                obj = this.doDeserialize(reader, context);
            }
            Object object = obj;
            return object;
        }
        finally {
            if (pushedEncodingStyle) {
                context.popEncodingStyle();
            }
        }
    }

    protected Object doDeserialize(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        if (this.typeRegistry == null) {
            throw new EncodingException("initializable.not.initialized");
        }
        if (this.componentDeserializer == null) {
            this.componentDeserializer = (JAXRPCDeserializer)((Object)this.componentSerializer);
        }
        ArrayList<Object> values = null;
        Object currentValue = null;
        Object array = null;
        QName elementName = null;
        elementName = reader.getName();
        if (reader.getState() == 1 && elementName.equals(this.type)) {
            values = new ArrayList<Object>();
            while (true) {
                elementName = reader.getName();
                if (reader.getState() != 1 || !elementName.equals(this.type)) break;
                currentValue = this.componentDeserializer.deserialize(this.type, reader, context);
                if (currentValue == null) {
                    throw new DeserializationException("literal unexpected null");
                }
                values.add(currentValue);
                XMLReaderUtil.verifyReaderState(reader, 2);
                reader.nextElementContent();
            }
            array = Array.newInstance(this.componentType, values.size());
            Object[] valuesArray = values.toArray();
            for (int i = 0; i < valuesArray.length; ++i) {
                Array.set(array, i, valuesArray[i]);
            }
        }
        return array;
    }

    protected void verifyType(XMLReader reader) throws Exception {
        QName actualType = LiteralArraySerializer.getType(reader);
        if (actualType != null && !actualType.equals(this.type) && !this.isAcceptableType(actualType)) {
            throw new DeserializationException("xsd.unexpectedElementType", new Object[]{this.type.toString(), actualType.toString()});
        }
    }

    protected boolean isAcceptableType(QName actualType) {
        return false;
    }

    protected void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }

    protected void doSerialize(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        this.doSerializeInstance(obj, writer, context);
    }

    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        if (this.typeRegistry == null) {
            throw new EncodingException("initializable.not.initialized");
        }
        if (instance.getClass().isArray()) {
            int length = Array.getLength(instance);
            for (int i = 0; i < length; ++i) {
                Object parameter = Array.get(instance, i);
                if (this.componentSerializer != null) {
                    // empty if block
                }
                ((CombinedSerializer)this.componentSerializer).serialize(parameter, null, null, writer, context);
            }
        }
    }

    protected void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }

    public String getMechanismType() {
        return "http://java.sun.com/jax-rpc-ri/1.0/streaming/";
    }

    public static QName getType(XMLReader reader) throws Exception {
        QName type = null;
        Attributes attrs = reader.getAttributes();
        String typeVal = attrs.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (typeVal != null) {
            type = XMLReaderUtil.decodeQName(reader, typeVal);
        }
        return type;
    }

    protected JAXRPCSerializer getParameterSerializer(int index, Object parameter) throws Exception {
        return null;
    }

    protected JAXRPCDeserializer getParameterDeserializer(int index, XMLReader reader) throws Exception {
        return null;
    }

    public static SOAPDeserializationState registerWithMemberState(Object instance, SOAPDeserializationState state, Object member, int memberIndex, SOAPInstanceBuilder builder) {
        try {
            SOAPDeserializationState deserializationState = state == null ? new SOAPDeserializationState() : state;
            deserializationState.setInstance(instance);
            if (deserializationState.getBuilder() == null) {
                if (builder == null) {
                    throw new IllegalArgumentException();
                }
                deserializationState.setBuilder(builder);
            }
            SOAPDeserializationState memberState = (SOAPDeserializationState)member;
            memberState.registerListener(deserializationState, memberIndex);
            return deserializationState;
        }
        catch (JAXRPCExceptionBase e) {
            throw new DeserializationException(e);
        }
        catch (Exception e) {
            throw new DeserializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        if (this.typeRegistry != null) {
            return;
        }
        this.typeRegistry = registry;
    }
}

