/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.server;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.metro.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.server.EndpointFactory;
import java.util.logging.Level;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReDelegate {
    private static final Logger LOGGER = Logger.getLogger(ReDelegate.class);

    public static <T> void recreate(ManagedEndpoint<T> managedEndpoint, WebServiceFeature ... features) {
        try {
            WSEndpoint<T> delegate = ReDelegate.recreateEndpoint(managedEndpoint, features);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(ManagementMessages.WSM_5092_NEW_ENDPOINT_DELEGATE(delegate));
            }
            managedEndpoint.swapEndpointDelegate(delegate);
        }
        catch (Throwable e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5091_ENDPOINT_CREATION_FAILED(), e));
        }
    }

    private static <T> WSEndpoint<T> recreateEndpoint(ManagedEndpoint<T> endpoint, WebServiceFeature ... features) {
        endpoint.closeManagedObjectManager();
        EndpointCreationAttributes creationAttributes = endpoint.getCreationAttributes();
        BindingImpl recreatedBinding = BindingImpl.create(endpoint.getBinding().getBindingId(), features);
        WSEndpoint<T> result = EndpointFactory.createEndpoint(endpoint.getImplementationClass(), creationAttributes.isProcessHandlerAnnotation(), creationAttributes.getInvoker(), endpoint.getServiceName(), endpoint.getPortName(), endpoint.getContainer(), recreatedBinding, null, null, creationAttributes.getEntityResolver(), creationAttributes.isTransportSynchronous());
        result.getComponentRegistry().addAll(endpoint.getComponentRegistry());
        return result;
    }
}

