/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coord.common;

import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import java.lang.reflect.Field;
import java.util.List;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EndpointReferenceHelper {
    public static EndpointReferenceHelper newInstance(EndpointReference epr) {
        if (epr == null) {
            throw new IllegalArgumentException("EndpointReference can't be null");
        }
        if (epr instanceof MemberSubmissionEndpointReference) {
            return new MemberSubmissionEndpointReferenceHelper((MemberSubmissionEndpointReference)epr);
        }
        if (epr instanceof W3CEndpointReference) {
            return new W3CEndpointReferenceHelper((W3CEndpointReference)epr);
        }
        throw new IllegalArgumentException(epr.getClass() + "is not a supported EndpointReference");
    }

    public abstract String getAddress();

    public abstract Node[] getReferenceParameters();

    static class W3CEndpointReferenceHelper
    extends EndpointReferenceHelper {
        private static Field address = null;
        private static Field referenceParameters = null;
        private static Class address_class = null;
        private static Class referenceParameters_class = null;
        private static Field uri = null;
        private static Field elements = null;
        W3CEndpointReference epr;

        W3CEndpointReferenceHelper(W3CEndpointReference epr) {
            this.epr = epr;
        }

        public String getAddress() {
            try {
                return (String)uri.get(address.get(this.epr));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        public Node[] getReferenceParameters() {
            try {
                return ((List)elements.get(referenceParameters.get(this.epr))).toArray(new Element[0]);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        static {
            try {
                address = W3CEndpointReference.class.getDeclaredField("address");
                address.setAccessible(true);
                referenceParameters = W3CEndpointReference.class.getDeclaredField("referenceParameters");
                referenceParameters.setAccessible(true);
                address_class = Class.forName("javax.xml.ws.wsaddressing.W3CEndpointReference$Address");
                referenceParameters_class = Class.forName("javax.xml.ws.wsaddressing.W3CEndpointReference$Elements");
                uri = address_class.getDeclaredField("uri");
                uri.setAccessible(true);
                elements = referenceParameters_class.getDeclaredField("elements");
                elements.setAccessible(true);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class MemberSubmissionEndpointReferenceHelper
    extends EndpointReferenceHelper {
        MemberSubmissionEndpointReference epr;

        MemberSubmissionEndpointReferenceHelper(MemberSubmissionEndpointReference epr) {
            this.epr = epr;
        }

        public String getAddress() {
            return this.epr.addr.uri;
        }

        public Node[] getReferenceParameters() {
            return this.epr.referenceParameters.elements.toArray(new Element[0]);
        }
    }
}

