/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.impl.DerivedKeyTokenImpl;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.keyinfo.DerivedKey;
import com.sun.xml.ws.security.opt.impl.keyinfo.IssuedTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.SCTBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.keyinfo.SymmetricTokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.keyinfo.UsernameTokenBuilder;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.AlgorithmSuite;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DerivedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.SecureConversationTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.security.Key;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import javax.xml.bind.JAXBElement;

public class DerivedKeyTokenBuilder
extends TokenBuilder {
    private DerivedTokenKeyBinding dtk = null;

    public DerivedKeyTokenBuilder(JAXBFilterProcessingContext context, DerivedTokenKeyBinding dtk) {
        super(context);
        this.dtk = dtk;
    }

    @Override
    public BuilderResult process() throws XWSSecurityException {
        KeyBindingBase skb;
        String algorithm = null;
        WSSPolicy originalKeyBinding = this.dtk.getOriginalKeyBinding();
        AlgorithmSuite algSuite = this.context.getAlgorithmSuite();
        BuilderResult dktResult = new BuilderResult();
        if (algSuite != null) {
            algorithm = algSuite.getEncryptionAlgorithm();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Algorithm used for Derived Keys: " + algorithm);
            }
        } else {
            throw new XWSSecurityException("Internal Error: Algorithm Suite is not set in context");
        }
        long offset = 0L;
        long length = SecurityUtil.getLengthFromAlgorithm(algorithm);
        WSSPolicy policy = (WSSPolicy)this.context.getSecurityPolicy();
        if (length == 32L && PolicyTypeUtil.signaturePolicy(policy)) {
            length = 24L;
        }
        String dpTokenID = "";
        byte[] secret = null;
        BuilderResult result = null;
        if (PolicyTypeUtil.usernameTokenBinding(originalKeyBinding)) {
            if (this.context.getusernameTokenBinding() == null) {
                throw new XWSSecurityException("Internal Error: UsernameToken Binding not set on context");
            }
            AuthenticationTokenPolicy.UsernameTokenBinding utb = this.context.getusernameTokenBinding();
            this.context.setUsernameTokenBinding(null);
            UsernameTokenBuilder br = new UsernameTokenBuilder(this.context, utb);
            result = br.process();
            SecretKey key = utb.getSecretKey();
            if (key == null) {
                throw new XWSSecurityException("Key obtained from the username token binding is null");
            }
            byte[] tempSecret = key.getEncoded();
            secret = new byte[16];
            for (int i = 0; i <= 15; ++i) {
                secret[i] = tempSecret[i];
            }
        } else if (PolicyTypeUtil.symmetricKeyBinding(originalKeyBinding)) {
            skb = null;
            if (this.context.getSymmetricKeyBinding() == null) {
                throw new XWSSecurityException("Internal Error: SymmetricBinding not set on context");
            }
            skb = this.context.getSymmetricKeyBinding();
            this.context.setSymmetricKeyBinding(null);
            String dataEncAlgo = SecurityUtil.getDataEncryptionAlgo(this.context);
            String keyAlgo = ((SymmetricKeyBinding)skb).getKeyAlgorithm();
            if ((keyAlgo == null || "".equals(keyAlgo)) && this.context.getAlgorithmSuite() != null) {
                keyAlgo = this.context.getAlgorithmSuite().getAsymmetricKeyAlgorithm();
            }
            SymmetricTokenBuilder stb = new SymmetricTokenBuilder((SymmetricKeyBinding)skb, this.context, dataEncAlgo, keyAlgo);
            result = stb.process();
            Key originalKey = result.getDataProtectionKey();
            secret = originalKey.getEncoded();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "SymmetricBinding under Derived Keys");
                logger.log(Level.FINEST, "DataEncryption Algorithm:" + dataEncAlgo);
                logger.log(Level.FINEST, "Key Algorithm:" + keyAlgo);
            }
        } else if (PolicyTypeUtil.secureConversationTokenKeyBinding(originalKeyBinding)) {
            SecurityContextTokenInfo sctInstanceInfo;
            skb = (SecureConversationTokenKeyBinding)originalKeyBinding;
            SCTBuilder builder = new SCTBuilder(this.context, (SecureConversationTokenKeyBinding)originalKeyBinding);
            result = builder.process();
            IssuedTokenContext ictx = this.context.getSecureConversationContext();
            SecurityContextToken sct = (SecurityContextToken)ictx.getSecurityToken();
            secret = sct.getInstance() != null ? (this.context.isExpired() ? ictx.getProofKey() : ((sctInstanceInfo = ictx.getSecurityContextTokenInfo()) != null ? sctInstanceInfo.getInstanceSecret(sct.getInstance()) : ictx.getProofKey())) : ictx.getProofKey();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "SecureConversation token binding under Derived Keys");
            }
        } else if (PolicyTypeUtil.issuedTokenKeyBinding(originalKeyBinding)) {
            IssuedTokenBuilder itb = new IssuedTokenBuilder(this.context, (IssuedTokenKeyBinding)originalKeyBinding);
            result = itb.process();
            Key originalKey = result.getDataProtectionKey();
            if (this.context.getTrustContext().getProofKey() == null) {
                dktResult.setDataProtectionKey(originalKey);
                dktResult.setKeyInfo(result.getKeyInfo());
                return dktResult;
            }
            secret = originalKey.getEncoded();
            dpTokenID = result.getDPTokenId();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Issued Token Binding token binding under Derived Keys");
            }
        } else {
            if (originalKeyBinding != null) {
                throw new XWSSecurityException("Unsupported Key Binding:" + originalKeyBinding);
            }
            throw new XWSSecurityException("Internal Error: Null original key binding");
        }
        DerivedKeyTokenImpl dkt = new DerivedKeyTokenImpl(offset, length, secret);
        SecretKey dataKey = null;
        try {
            String jceAlgo = SecurityUtil.getSecretKeyAlgorithm(algorithm);
            dataKey = dkt.generateSymmetricKey(jceAlgo);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1806_ERROR_GENERATING_SYMMETRIC_KEY(), e);
            throw new XWSSecurityException(e);
        }
        SecurityTokenReferenceType str = null;
        Object strObj = result.getKeyInfo().getContent().get(0);
        str = strObj instanceof JAXBElement ? (SecurityTokenReferenceType)((JAXBElement)strObj).getValue() : (SecurityTokenReferenceType)strObj;
        if (str instanceof SecurityTokenReference) {
            str = this.elementFactory.createSecurityTokenReference(((SecurityTokenReference)str).getReference());
        }
        DerivedKey dk = null;
        dk = dpTokenID.length() == 0 ? this.elementFactory.createDerivedKey(this.dtk.getUUID(), algorithm, dkt.getNonce(), dkt.getOffset(), dkt.getLength(), dkt.getLabel(), str, this.context.getSecurityPolicyVersion()) : this.elementFactory.createDerivedKey(this.dtk.getUUID(), algorithm, dkt.getNonce(), dkt.getOffset(), dkt.getLength(), dkt.getLabel(), str, dpTokenID, this.context.getSecurityPolicyVersion());
        DirectReference dr = this.elementFactory.createDirectReference();
        dr.setURI("#" + dk.getId());
        SecurityTokenReference str2 = this.buildSTR(this.context.generateID(), dr);
        this.context.getSecurityHeader().add(dk);
        this.buildKeyInfo(str2);
        dktResult.setKeyInfo(this.keyInfo);
        dktResult.setDataProtectionKey(dataKey);
        return dktResult;
    }
}

