/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.commons.AbstractMOMRegistrationAware;
import com.sun.xml.ws.commons.MaintenanceTaskExecutor;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.ha.HighlyAvailableMap;
import com.sun.xml.ws.rx.ha.ReplicationManager;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.LocalIDManager;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.InboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.OutboundSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceMaintenanceTask;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.InVmSequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.SequenceDataPojo;
import com.sun.xml.ws.rx.rm.runtime.sequence.invm.UnackedMessageReplicationManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;

public final class InVmSequenceManager
extends AbstractMOMRegistrationAware
implements SequenceManager,
ReplicationManager<String, AbstractSequence> {
    private static final Logger LOGGER = Logger.getLogger(InVmSequenceManager.class);
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final HighlyAvailableMap<String, AbstractSequence> sequences;
    private final BackingStore<StickyKey, SequenceDataPojo> sequenceDataBs;
    private final HighlyAvailableMap<String, String> boundSequences;
    private final HighlyAvailableMap<String, ApplicationMessage> unackedMessageStore;
    private final DeliveryQueueBuilder inboundQueueBuilder;
    private final DeliveryQueueBuilder outboundQueueBuilder;
    private final String uniqueEndpointId;
    private final long sequenceInactivityTimeout;
    private final long maxConcurrentInboundSequences;
    private final AtomicLong actualConcurrentInboundSequences;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final String loggerProlog;
    private final LocalIDManager localIDManager;

    public InVmSequenceManager(String uniqueEndpointId, DeliveryQueueBuilder inboundQueueBuilder, DeliveryQueueBuilder outboundQueueBuilder, RmConfiguration configuration, Container container, LocalIDManager localIDManager) {
        BackingStore boundSequencesBs;
        this.loggerProlog = "[" + uniqueEndpointId + "_SEQUENCE_MANAGER]: ";
        this.uniqueEndpointId = uniqueEndpointId;
        this.inboundQueueBuilder = inboundQueueBuilder;
        this.outboundQueueBuilder = outboundQueueBuilder;
        this.localIDManager = localIDManager;
        this.sequenceInactivityTimeout = configuration.getRmFeature().getSequenceInactivityTimeout();
        this.actualConcurrentInboundSequences = new AtomicLong(0L);
        this.maxConcurrentInboundSequences = configuration.getRmFeature().getMaxConcurrentSessions();
        BackingStoreFactory bsFactory = HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY);
        String boundSequencesBsName = uniqueEndpointId + "_BOUND_SEQUENCE_BS";
        BackingStoreConfiguration<StickyKey, String> boundSequencesBsConfig = HighAvailabilityProvider.INSTANCE.initBackingStoreConfiguration(boundSequencesBsName, StickyKey.class, String.class);
        boundSequencesBsConfig.setClassLoader(this.getClass().getClassLoader());
        try {
            boundSequencesBs = bsFactory.createBackingStore(boundSequencesBsConfig);
        }
        catch (BackingStoreException ex) {
            throw new RxRuntimeException(LocalizationMessages.WSRM_1142_ERROR_CREATING_HA_BACKING_STORE(boundSequencesBsName), ex);
        }
        this.boundSequences = HighlyAvailableMap.createSticky(uniqueEndpointId + "_BOUND_SEQUENCE_MAP", boundSequencesBs);
        this.sequenceDataBs = HighAvailabilityProvider.INSTANCE.createBackingStore(bsFactory, uniqueEndpointId + "_SEQUENCE_DATA_BS", StickyKey.class, SequenceDataPojo.class);
        this.sequences = HighlyAvailableMap.create(uniqueEndpointId + "_SEQUENCE_DATA_MAP", this);
        UnackedMessageReplicationManager unackedMsgRM = null;
        if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            unackedMsgRM = new UnackedMessageReplicationManager(uniqueEndpointId);
        }
        this.unackedMessageStore = HighlyAvailableMap.create(uniqueEndpointId + "_UNACKED_MESSAGES_MAP", unackedMsgRM);
        MaintenanceTaskExecutor.register(new SequenceMaintenanceTask(this, configuration.getRmFeature().getSequenceManagerMaintenancePeriod(), TimeUnit.MILLISECONDS), configuration.getRmFeature().getSequenceManagerMaintenancePeriod(), TimeUnit.MILLISECONDS, container);
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public String uniqueEndpointId() {
        return this.uniqueEndpointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Sequence> sequences() {
        try {
            this.dataLock.readLock().lock();
            HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>(this.sequences);
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> boundSequences() {
        try {
            this.dataLock.readLock().lock();
            Map<String, String> map = this.boundSequences.getLocalMapCopy();
            return map;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    @Override
    public long concurrentlyOpenedInboundSequencesCount() {
        return this.actualConcurrentInboundSequences.longValue();
    }

    @Override
    public Sequence createOutboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        SequenceDataPojo sequenceDataPojo = new SequenceDataPojo(sequenceId, strId, expirationTime, false, this.sequenceDataBs);
        sequenceDataPojo.setState(Sequence.State.CREATED);
        sequenceDataPojo.setAckRequestedFlag(false);
        sequenceDataPojo.setLastMessageNumber(0L);
        sequenceDataPojo.setLastActivityTime(this.currentTimeInMillis());
        sequenceDataPojo.setLastAcknowledgementRequestTime(0L);
        InVmSequenceData data = InVmSequenceData.newInstace(sequenceDataPojo, this, this.unackedMessageStore);
        return this.registerSequence(new OutboundSequence(data, this.outboundQueueBuilder, this));
    }

    @Override
    public Sequence createInboundSequence(String sequenceId, String strId, long expirationTime) throws DuplicateSequenceException {
        long actualSessions = this.actualConcurrentInboundSequences.incrementAndGet();
        if (this.maxConcurrentInboundSequences >= 0L && this.maxConcurrentInboundSequences < actualSessions) {
            this.actualConcurrentInboundSequences.decrementAndGet();
            throw new RxRuntimeException(LocalizationMessages.WSRM_1156_MAX_CONCURRENT_SESSIONS_REACHED(this.maxConcurrentInboundSequences));
        }
        SequenceDataPojo sequenceDataPojo = new SequenceDataPojo(sequenceId, strId, expirationTime, true, this.sequenceDataBs);
        sequenceDataPojo.setState(Sequence.State.CREATED);
        sequenceDataPojo.setAckRequestedFlag(false);
        sequenceDataPojo.setLastMessageNumber(0L);
        sequenceDataPojo.setLastActivityTime(this.currentTimeInMillis());
        sequenceDataPojo.setLastAcknowledgementRequestTime(0L);
        InVmSequenceData data = InVmSequenceData.newInstace(sequenceDataPojo, this, this.unackedMessageStore);
        return this.registerSequence(new InboundSequence(data, this.inboundQueueBuilder, this));
    }

    @Override
    public String generateSequenceUID() {
        return "uuid:" + UUID.randomUUID();
    }

    @Override
    public Sequence closeSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        sequence.close();
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        if (sequenceId == null) {
            throw new UnknownSequenceException("[null-sequence-identifier]");
        }
        try {
            this.dataLock.readLock().lock();
            Sequence sequence = this.sequences.get(sequenceId);
            if (sequence == null) {
                throw new UnknownSequenceException(sequenceId);
            }
            if (this.shouldTeminate(sequence)) {
                this.dataLock.readLock().unlock();
                this.tryTerminateSequence(sequenceId);
                this.dataLock.readLock().lock();
            }
            Sequence sequence2 = sequence;
            return sequence2;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    @Override
    public Sequence getInboundSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        if (!(sequence instanceof InboundSequence)) {
            throw new UnknownSequenceException(sequenceId);
        }
        return sequence;
    }

    @Override
    public Sequence getOutboundSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.getSequence(sequenceId);
        if (!(sequence instanceof OutboundSequence)) {
            throw new UnknownSequenceException(sequenceId);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(String sequenceId) {
        if (sequenceId == null) {
            return false;
        }
        try {
            this.dataLock.readLock().lock();
            Sequence s = this.sequences.get(sequenceId);
            boolean bl = s != null && s.getState() != Sequence.State.TERMINATING;
            return bl;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence tryTerminateSequence(String sequenceId) {
        if (sequenceId == null) {
            return null;
        }
        try {
            this.dataLock.writeLock().lock();
            Sequence sequence = this.sequences.get(sequenceId);
            if (sequence == null) {
                Sequence sequence2 = null;
                return sequence2;
            }
            if (sequence.getState() != Sequence.State.TERMINATING) {
                if (sequence instanceof InboundSequence) {
                    this.actualConcurrentInboundSequences.decrementAndGet();
                }
                sequence.preDestroy();
            }
            Sequence sequence3 = sequence;
            return sequence3;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public Sequence terminateSequence(String sequenceId) throws UnknownSequenceException {
        Sequence sequence = this.tryTerminateSequence(sequenceId);
        if (sequence == null) {
            throw new UnknownSequenceException(sequenceId);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindSequences(String referenceSequenceId, String boundSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.writeLock().lock();
            if (!this.sequences.containsKey(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            if (!this.sequences.containsKey(boundSequenceId)) {
                throw new UnknownSequenceException(boundSequenceId);
            }
            this.boundSequences.put(referenceSequenceId, boundSequenceId);
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence getBoundSequence(String referenceSequenceId) throws UnknownSequenceException {
        try {
            this.dataLock.readLock().lock();
            if (!this.isValid(referenceSequenceId)) {
                throw new UnknownSequenceException(referenceSequenceId);
            }
            AbstractSequence abstractSequence = this.boundSequences.containsKey(referenceSequenceId) ? this.sequences.get(this.boundSequences.get(referenceSequenceId)) : null;
            return abstractSequence;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence registerSequence(AbstractSequence sequence) throws DuplicateSequenceException {
        try {
            this.dataLock.writeLock().lock();
            if (this.sequences.containsKey(sequence.getId())) {
                throw new DuplicateSequenceException(sequence.getId());
            }
            this.sequences.put(sequence.getId(), sequence);
            AbstractSequence abstractSequence = sequence;
            return abstractSequence;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public long currentTimeInMillis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMaintenance() {
        LOGGER.entering();
        boolean continueMaintenance = !this.disposed.get();
        try {
            this.dataLock.writeLock().lock();
            if (continueMaintenance) {
                Iterator<String> sequenceKeyIterator = this.sequences.keySet().iterator();
                while (sequenceKeyIterator.hasNext()) {
                    String key = sequenceKeyIterator.next();
                    Sequence sequence = this.sequences.get(key);
                    if (this.shouldRemove(sequence)) {
                        LOGGER.config(LocalizationMessages.WSRM_1152_REMOVING_SEQUENCE(sequence.getId()));
                        sequenceKeyIterator.remove();
                        this.sequences.getReplicationManager().remove(key);
                        if (this.boundSequences.containsKey(sequence.getId())) {
                            this.boundSequences.remove(sequence.getId());
                        }
                        if (this.localIDManager == null) continue;
                        this.localIDManager.markSequenceTermination(sequence.getId());
                        continue;
                    }
                    if (!this.shouldTeminate(sequence)) continue;
                    LOGGER.config(LocalizationMessages.WSRM_1153_TERMINATING_SEQUENCE(sequence.getId()));
                    this.tryTerminateSequence(sequence.getId());
                }
            }
            boolean bl = continueMaintenance;
            return bl;
        }
        finally {
            this.dataLock.writeLock().unlock();
            LOGGER.exiting((Object)continueMaintenance);
        }
    }

    private boolean shouldTeminate(Sequence sequence) {
        return sequence.getState() != Sequence.State.TERMINATING && (sequence.isExpired() || sequence.getLastActivityTime() + this.sequenceInactivityTimeout < this.currentTimeInMillis());
    }

    private boolean shouldRemove(Sequence sequence) {
        return sequence.getState() == Sequence.State.TERMINATING;
    }

    @Override
    public void invalidateCache() {
        this.sequences.invalidateCache();
        this.boundSequences.invalidateCache();
        this.unackedMessageStore.invalidateCache();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Local cache invalidated");
        }
    }

    @Override
    public void dispose() {
        if (this.disposed.compareAndSet(false, true)) {
            this.sequences.close();
            this.sequences.destroy();
            this.boundSequences.close();
            this.boundSequences.destroy();
            this.unackedMessageStore.close();
            this.unackedMessageStore.destroy();
        }
    }

    @Override
    public AbstractSequence load(String key) {
        AbstractSequence sequence;
        SequenceDataPojo state = HighAvailabilityProvider.loadFrom(this.sequenceDataBs, new StickyKey((Serializable)((Object)key)), null);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Sequence state data loaded from backing store for key [" + key + "]: " + (state == null ? null : state.toString()));
        }
        if (state == null) {
            return null;
        }
        state.setBackingStore(this.sequenceDataBs);
        InVmSequenceData data = InVmSequenceData.loadReplica(state, this, this.unackedMessageStore);
        if (state.isInbound()) {
            if (HaContext.failoverDetected() && !data.getUnackedMessageNumbers().isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(this.loggerProlog + "Unacked messages detected during failover of an inbound sequence data [" + data.getSequenceId() + "]: Registering as failed-over");
                }
                data.markUnackedAsFailedOver();
            }
            sequence = new InboundSequence(data, this.inboundQueueBuilder, this);
        } else {
            sequence = new OutboundSequence(data, this.outboundQueueBuilder, this);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Sequence state data for key [" + key + "] converted into sequence of class: " + sequence.getClass());
        }
        return sequence;
    }

    @Override
    public void save(String key, AbstractSequence sequence, boolean isNew) {
        HaInfo haInfo;
        SequenceData _data = sequence.getData();
        if (!(_data instanceof InVmSequenceData)) {
            throw new IllegalArgumentException("Unsupported sequence data class: " + _data.getClass().getName());
        }
        SequenceDataPojo value = ((InVmSequenceData)_data).getSequenceStatePojo();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Sending for replication sequence data with a key [" + key + "]: " + value.toString() + ", isNew=" + isNew);
        }
        if ((haInfo = HaContext.currentHaInfo()) != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Existing HaInfo found, using it for sequence data replication: " + HaContext.asString(haInfo));
            }
            HaContext.udpateReplicaInstance(HighAvailabilityProvider.saveTo(this.sequenceDataBs, new StickyKey((Serializable)((Object)key), haInfo.getKey()), value, isNew));
        } else {
            StickyKey stickyKey = new StickyKey((Serializable)((Object)key));
            String replicaId = HighAvailabilityProvider.saveTo(this.sequenceDataBs, stickyKey, value, isNew);
            haInfo = new HaInfo(stickyKey.getHashKey(), replicaId, false);
            HaContext.updateHaInfo(haInfo);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "No HaInfo found, created new after sequence data replication: " + HaContext.asString(haInfo));
            }
        }
    }

    @Override
    public void remove(String key) {
        HighAvailabilityProvider.removeFrom(this.sequenceDataBs, new StickyKey((Serializable)((Object)key)));
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Removed sequence data from the backing store for key [" + key + "]");
        }
    }

    @Override
    public void close() {
        HighAvailabilityProvider.close(this.sequenceDataBs);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Closed sequence data backing store");
        }
    }

    @Override
    public void destroy() {
        HighAvailabilityProvider.destroy(this.sequenceDataBs);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Destroyed sequence data backing store");
        }
    }
}

