/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.policy.mls.Parameter;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.namespace.QName;
import com.sun.xml.ws.security.impl.policy.Constants;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class SignatureTargetCreator {
    private boolean enforce = false;
    private AlgorithmSuite algorithmSuite = null;
    private boolean contentOnly = false;
    /**
     * Creates a new instance of SignatureTargetCreator
     */
    public SignatureTargetCreator(boolean enforce,AlgorithmSuite algorithmSuite,boolean contentOnly) {
        this.enforce = enforce;
        this.algorithmSuite = algorithmSuite;
    }

    public SignatureTarget newURISignatureTarget(String uid){
        if ( uid != null ) {
            SignatureTarget target = new SignatureTarget();
            target.setType(SignatureTarget.TARGET_TYPE_VALUE_URI);
            target.setDigestAlgorithm(algorithmSuite.getDigestAlgorithm());
            target.setValue("#"+uid);
            addTransform(target);
            target.setEnforce(enforce);
            return target;
        }
        return null;
    }

    public SignatureTarget newXpathSignatureTarget(String xpathTarget){
        SignatureTarget target = new SignatureTarget();
        target.setType(SignatureTarget.TARGET_TYPE_VALUE_XPATH);
        target.setDigestAlgorithm(algorithmSuite.getDigestAlgorithm());
        target.setValue(xpathTarget);
        target.setContentOnly(contentOnly);
        target.setEnforce(enforce);
        return target;
    }

    public SignatureTarget newQNameSignatureTarget(QName name){
        SignatureTarget target = new SignatureTarget();
        target.setType(SignatureTarget.TARGET_TYPE_VALUE_QNAME);
        target.setDigestAlgorithm(algorithmSuite.getDigestAlgorithm());
        target.setContentOnly(contentOnly);
        target.setEnforce(enforce);
        target.setQName(name);
        return target;
    }

    public void addTransform(SignatureTarget target){
        SignatureTarget.Transform tr = target.newSignatureTransform();
        if(algorithmSuite != null && algorithmSuite.getAdditionalProps().contains(Constants.InclusiveC14N)){
            tr.setTransform(CanonicalizationMethod.INCLUSIVE);
        } else{
            tr.setTransform(CanonicalizationMethod.EXCLUSIVE);
        }

        if(algorithmSuite != null && algorithmSuite.getAdditionalProps().contains(Constants.InclusiveC14NWithCommentsForTransforms)){
            tr.setTransform(CanonicalizationMethod.INCLUSIVE_WITH_COMMENTS);
        } else if(algorithmSuite != null && algorithmSuite.getAdditionalProps().contains(Constants.ExclusiveC14NWithCommentsForTransforms)){
            tr.setTransform(CanonicalizationMethod.EXCLUSIVE_WITH_COMMENTS);
        }
        target.addTransform(tr);
    }

    public void addSTRTransform(SignatureTarget target){
        SignatureTarget.Transform tr = target.newSignatureTransform();
        tr.setTransform(MessageConstants.STR_TRANSFORM_URI);
        target.addTransform(tr);
        tr.setAlgorithmParameters(new Parameter("CanonicalizationMethod",CanonicalizationMethod.EXCLUSIVE));
    }

    void addAttachmentTransform(SignatureTarget target, String transformURI) {
        SignatureTarget.Transform tr = target.newSignatureTransform();
        tr.setTransform(transformURI);
        target.addTransform(tr);
    }

    //a new one for SingedSupportingTokens where we don't add transform by default
    //a decision on using STR-TX is pending and hence we delay adding the transform
    public SignatureTarget newURISignatureTargetForSSToken(String uid) {
          if ( uid != null ) {
            SignatureTarget target = new SignatureTarget();
            target.setType(SignatureTarget.TARGET_TYPE_VALUE_URI);
            target.setDigestAlgorithm(algorithmSuite.getDigestAlgorithm());
            target.setValue("#"+uid);
            target.setEnforce(enforce);
            return target;
        }
        return null;
    }
}
