/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.model;

import com.sun.tools.ws.processor.model.ModelException;
import com.sun.tools.ws.processor.model.ModelObject;
import com.sun.tools.ws.processor.model.ModelVisitor;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.wsdl.framework.Entity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class Service
extends ModelObject {
    private QName name;
    private List<Port> ports = new ArrayList<Port>();
    private Map<QName, Port> portsByName = new HashMap<QName, Port>();
    private JavaInterface javaInterface;

    public Service(Entity entity) {
        super(entity);
    }

    public Service(QName name, JavaInterface javaInterface, Entity entity) {
        super(entity);
        this.name = name;
        this.javaInterface = javaInterface;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public void addPort(Port port) {
        if (this.portsByName.containsKey(port.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this.ports.add(port);
        this.portsByName.put(port.getName(), port);
    }

    public Port getPortByName(QName n) {
        if (this.portsByName.size() != this.ports.size()) {
            this.initializePortsByName();
        }
        return this.portsByName.get(n);
    }

    public List<Port> getPorts() {
        return this.ports;
    }

    public void setPorts(List<Port> m) {
        this.ports = m;
    }

    private void initializePortsByName() {
        this.portsByName = new HashMap<QName, Port>();
        if (this.ports != null) {
            for (Port port : this.ports) {
                if (port.getName() != null && this.portsByName.containsKey(port.getName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this.portsByName.put(port.getName(), port);
            }
        }
    }

    public JavaInterface getJavaIntf() {
        return this.getJavaInterface();
    }

    public JavaInterface getJavaInterface() {
        return this.javaInterface;
    }

    public void setJavaInterface(JavaInterface i) {
        this.javaInterface = i;
    }

    @Override
    public void accept(ModelVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

