/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;

public class XSDDoubleEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDDoubleEncoder();

    private XSDDoubleEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    @Override
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        Double d = (Double)obj;
        double dVal = d;
        if (d.isInfinite()) {
            if (dVal == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
            return "INF";
        }
        if (d.isNaN()) {
            return "NaN";
        }
        return d.toString();
    }

    @Override
    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        if ((str = EncoderUtils.collapseWhitespace(str)).equals("-INF")) {
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (str.equals("INF")) {
            return new Double(Double.POSITIVE_INFINITY);
        }
        if (str.equals("NaN")) {
            return new Double(Double.NaN);
        }
        return new Double(str);
    }

    @Override
    public void writeValue(Object obj, XMLWriter writer) throws Exception {
        writer.writeCharsUnquoted(this.objectToString(obj, writer));
    }
}

