/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.LiteralEncoding;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.SOAPObjectSerializerGenerator;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.HeaderFault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class SOAPFaultSerializerGenerator
extends GeneratorBase {
    private Port port;
    private Set generatedFaultSerializers;
    private boolean writeFaultSerializerElse;

    public SOAPFaultSerializerGenerator() {
    }

    @Override
    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new SOAPFaultSerializerGenerator(model, config, properties);
    }

    @Override
    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new SOAPFaultSerializerGenerator(model, config, properties);
    }

    private SOAPFaultSerializerGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    private SOAPFaultSerializerGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        super(model, config, properties);
    }

    @Override
    protected void preVisitModel(Model model) throws Exception {
        this.generatedFaultSerializers = new HashSet();
    }

    @Override
    protected void postVisitModel(Model model) throws Exception {
        this.generatedFaultSerializers = null;
    }

    @Override
    protected void preVisitPort(Port port) throws Exception {
        super.preVisitPort(port);
        this.port = port;
    }

    @Override
    protected void postVisitPort(Port port) throws Exception {
        this.port = null;
        super.postVisitPort(port);
    }

    @Override
    protected void postVisitOperation(Operation operation) throws Exception {
        if (this.needsFaultSerializer(operation)) {
            this.generateFaultSerializer(operation);
        }
    }

    @Override
    protected void visitFault(Fault fault) throws Exception {
        AbstractType type = fault.getBlock().getType();
        if (type.isSOAPType()) {
            ((SOAPType)type).accept(this);
        }
        if (type.isLiteralType()) {
            ((LiteralType)type).accept(this);
        }
    }

    private boolean needsFaultSerializer(Operation operation) {
        Iterator faults = operation.getFaults();
        boolean needsFaultSerializer = false;
        String className = this.env.getNames().faultSerializerClassName(this.servicePackage, this.port, operation);
        if (faults != null && !this.generatedFaultSerializers.contains(className)) {
            while (!needsFaultSerializer && faults.hasNext()) {
                Fault fault = (Fault)faults.next();
                needsFaultSerializer = true;
            }
            this.generatedFaultSerializers.add(className);
        }
        return needsFaultSerializer;
    }

    private void generateFaultSerializer(Operation operation) {
        this.log("generating FaultHandler for: " + operation.getUniqueName());
        try {
            String className = this.env.getNames().faultSerializerClassName(this.servicePackage, this.port, operation);
            if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
                this.log("Class " + className + " exists. Not overriding.");
                return;
            }
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("SoapFaultSerializer");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writePackage(out, className);
            out.pln();
            this.writeImports(out);
            out.pln();
            this.writeClassDecl(out, className);
            this.writeMembers(out, operation);
            out.pln();
            this.writeClassConstructor(out, className);
            out.pln();
            this.writeInitialize(out, operation);
            out.pln();
            this.writeDeserializeDetail(out, operation);
            out.pln();
            this.writeSerializeDetail(out, operation);
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            SOAPFaultSerializerGenerator.fail(e);
        }
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAP12Constants;");
        p.pln("import com.sun.xml.rpc.soap.message.SOAPFaultInfo;");
        p.pln("import com.sun.xml.rpc.streaming.*;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        p.plnI("public class " + Names.stripQualifier(className) + " extends SOAPFaultInfoSerializer {");
    }

    private void writeMembers(IndentingWriter p, Operation operation) throws IOException, GeneratorException {
        Fault fault;
        HashSet<String> processedTypes = new HashSet<String>();
        Iterator faults = operation.getFaults();
        HashSet<QName> faultNames = new HashSet<QName>();
        while (faults.hasNext()) {
            fault = (Fault)faults.next();
            if (!faultNames.contains(fault.getBlock().getName())) {
                GeneratorUtil.writeQNameDeclaration(p, fault.getElementName(), this.env.getNames());
                faultNames.add(fault.getBlock().getName());
            }
            String suffix = "_Serializer";
            if (fault.getBlock().getType().isSOAPType()) {
                SOAPEncoding.writeStaticSerializer(p, this.servicePackage, (SOAPType)fault.getBlock().getType(), processedTypes, this.writerFactory, this.env.getNames());
            } else {
                LiteralEncoding.writeStaticSerializer(p, this.servicePackage, (LiteralType)fault.getBlock().getType(), processedTypes, this.writerFactory, this.env.getNames());
            }
            SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, fault.getBlock().getType());
            if (processedTypes.contains(fault.getBlock().getType().getName() + writer.serializerMemberName() + suffix)) continue;
            p.pln("private CombinedSerializer " + writer.serializerMemberName() + suffix + ";");
            processedTypes.add(fault.getBlock().getType().getName() + writer.serializerMemberName() + suffix);
        }
        faults = operation.getFaults();
        int i = 0;
        while (faults.hasNext()) {
            fault = (Fault)faults.next();
            p.pln("private static final int " + fault.getJavaException().getRealName().toUpperCase().replace('.', '_') + "_INDEX = " + i + ";");
            ++i;
        }
    }

    private void writeClassConstructor(IndentingWriter p, String className) throws IOException {
        p.plnI("public " + Names.stripQualifier(className) + "(boolean encodeType, " + "boolean isNullable) {");
        p.pln("super(encodeType, isNullable);");
        p.pOln("}");
    }

    private void writeInitialize(IndentingWriter p, Operation operation) throws IOException {
        Iterator faults = operation.getFaults();
        HashSet<AbstractType> processedTypes = new HashSet<AbstractType>();
        p.plnI("public void initialize(InternalTypeMappingRegistry registry) throws java.lang.Exception {");
        p.pln("super.initialize(registry);");
        while (faults.hasNext()) {
            Fault fault = (Fault)faults.next();
            AbstractType type = fault.getBlock().getType();
            if (processedTypes.contains(type)) continue;
            String suffix = "_Serializer";
            SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, type);
            writer.initializeSerializer(p, this.env.getNames().getTypeQName(type.getName()), "registry");
            p.pln(writer.serializerMemberName() + suffix + " = " + writer.serializerMemberName() + ".getInnermostSerializer();");
            processedTypes.add(type);
        }
        p.pOln("}");
    }

    private void writeDeserializeDetail(IndentingWriter p, Operation operation) throws IOException {
        TreeSet faultsSet = new TreeSet(new GeneratorUtil.FaultComparator(true));
        faultsSet.addAll(operation.getFaultsSet());
        Iterator faults = faultsSet.iterator();
        String detailNames = "";
        p.plnI("protected java.lang.Object deserializeDetail(SOAPDeserializationState state, XMLReader reader,");
        p.pln("SOAPDeserializationContext context, SOAPFaultInfo instance) throws java.lang.Exception {");
        p.pln("boolean isComplete = true;");
        p.pln("javax.xml.namespace.QName elementName;");
        p.pln("javax.xml.namespace.QName elementType = null;");
        p.pln("SOAPInstanceBuilder builder = null;");
        p.pln("java.lang.Object detail = null;");
        p.pln("java.lang.Object obj = null;");
        p.pln();
        p.pln("reader.nextElementContent();");
        p.plnI("if (reader.getState() == XMLReader.END)");
        p.pln("return deserializeDetail(reader, context);");
        p.pO();
        p.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.START);");
        p.pln("elementName = reader.getName();");
        p.pln("elementType = getType(reader);");
        String faultName = "";
        String nextName = "";
        Fault nextFault = faults.hasNext() ? (Fault)faults.next() : null;
        boolean wroteTypeCheck = false;
        boolean startName = false;
        int i = 0;
        while (nextFault != null) {
            Fault fault = nextFault;
            boolean hasNext = false;
            nextFault = faults.hasNext() ? (Fault)faults.next() : null;
            String string2 = nextName = nextFault != null ? this.env.getNames().getQNameName(nextFault.getElementName()) : null;
            if (!faultName.equals(this.env.getNames().getQNameName(fault.getElementName()))) {
                faultName = this.env.getNames().getQNameName(fault.getElementName());
                boolean writeTypeCheck = false;
                startName = true;
                if (i > 0) {
                    p.pln();
                    p.pO("} else ");
                }
                p.plnI("if (elementName.equals(" + faultName + ")) {");
                if (writeTypeCheck) {
                    p.plnI("if (elementType != null) {");
                    wroteTypeCheck = true;
                }
            }
            boolean bl = hasNext = nextName != null ? faultName.equals(nextName) : false;
            if (!hasNext && wroteTypeCheck) {
                p.pln();
                p.pO("} else ");
                wroteTypeCheck = false;
            } else if (!startName) {
                p.p("else ");
            }
            startName = false;
            this.writeFaultDeserializer(p, fault, operation, "reader", hasNext);
            ++i;
        }
        p.pln();
        p.pOln("}");
        this.writeCatchAllDetailDeserializer(p);
        p.pOln("}");
    }

    private void writeCatchAllDetailDeserializer(IndentingWriter p) throws IOException {
        p.pln("return deserializeDetail(reader, context);");
    }

    private void writeSerializeDetail(IndentingWriter p, Operation operation) throws IOException {
        TreeSet faultsSet = new TreeSet(new GeneratorUtil.FaultComparator(false));
        faultsSet.addAll(operation.getFaultsSet());
        Iterator faults = faultsSet.iterator();
        String detailNames = "";
        p.plnI("protected void serializeDetail(java.lang.Object detail, XMLWriter writer, SOAPSerializationContext context)");
        p.pln("throws java.lang.Exception {");
        p.plnI("if (detail == null) {");
        p.pln("throw new SerializationException(\"soap.unexpectedNull\");");
        p.pOln("}");
        for (Object obj : faultsSet) {
            if (!(obj instanceof HeaderFault)) continue;
            HeaderFault headerFault = (HeaderFault)obj;
            String faultExceptionName = this.env.getNames().customExceptionClassName(headerFault);
            p.plnI("if (detail instanceof " + faultExceptionName + ") {");
            p.pln("return;");
            p.pOln("}");
        }
        p.pln("writer.startElement(DETAIL_QNAME);");
        p.pln();
        p.pln("boolean pushedEncodingStyle = false;");
        p.plnI("if (encodingStyle != null) {");
        p.pln("context.pushEncodingStyle(encodingStyle, writer);");
        p.pOln("}");
        this.writeFaultSerializerElse = false;
        while (faults.hasNext()) {
            Fault fault = (Fault)faults.next();
            if (fault instanceof HeaderFault) continue;
            this.writeFaultSerializer(p, fault, "writer");
            this.writeFaultSerializerElse = true;
        }
        p.pln("writer.endElement();");
        p.plnI("if (pushedEncodingStyle) {");
        p.pln("context.popEncodingStyle();");
        p.pOln("}");
        p.pOln("}");
    }

    private void writeFaultDeserializer(IndentingWriter p, Fault fault, Operation operation, String reader, boolean hasNext) throws IOException {
        String suffix;
        Block block = fault.getBlock();
        String memberConstName = "0";
        String memberQName = this.env.getNames().getQNameName(fault.getElementName());
        AbstractType type = block.getType();
        SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, type);
        String serializer = writer.deserializerMemberName();
        boolean referenceable = type.isSOAPType() && ((SOAPType)type).isReferenceable();
        String string2 = suffix = type.isSOAPType() ? "_Serializer" : "";
        if (!hasNext) {
            if (fault.getSubfaults() == null) {
                p.plnI("if (elementType == null || ");
                p.pln("(elementType.equals(" + serializer + ".getXmlType()) ||");
                p.pln("(" + writer.serializerMemberName() + suffix + " instanceof ArraySerializerBase &&");
                p.pln("elementType.equals(SOAPConstants.QNAME_ENCODING_ARRAY)) ) ) {");
            }
        } else {
            p.plnI("if (elementType.equals(" + serializer + ".getXmlType()) ||");
            p.pln("(" + writer.serializerMemberName() + suffix + " instanceof ArraySerializerBase &&");
            p.pln("elementType.equals(SOAPConstants.QNAME_ENCODING_ARRAY)) ) {");
        }
        p.pln("obj = " + serializer + ".deserialize(" + memberQName + ", " + reader + ", context);");
        if (referenceable || type.isLiteralType()) {
            JavaException javaException = fault.getJavaException();
            if (referenceable) {
                p.plnI("if (obj instanceof SOAPDeserializationState) {");
                String index = javaException.getRealName().toUpperCase() + "_INDEX";
                p.pln("builder = new " + this.env.getNames().faultBuilderClassName(this.servicePackage, this.port, operation) + "();");
                p.plnI("state = registerWithMemberState(instance, state, obj,");
                p.pln(index.replace('.', '_') + ", builder);");
                p.pO();
                p.pln("isComplete = false;");
                p.pOlnI("} else {");
            }
            if ((type instanceof SOAPStructureType || type instanceof LiteralStructuredType) && SOAPObjectSerializerGenerator.deserializeToDetail(type)) {
                p.pln("detail = (javax.xml.soap.Detail)obj;");
            } else if (!(type instanceof SOAPStructureType) && !(type instanceof LiteralStructuredType) && javaException.getMembersCount() == 1 && fault.getSubfaults() == null) {
                Iterator members = fault.getJavaException().getMembers();
                JavaStructureMember member = (JavaStructureMember)members.next();
                String valueStr = null;
                String javaName = type.getJavaType().getName();
                if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                    String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                    valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")obj", javaName);
                } else {
                    valueStr = "(" + javaName + ")obj";
                }
                p.pln("detail = new " + this.env.getNames().customExceptionClassName(fault) + "(" + valueStr + ");");
            } else {
                p.pln("detail = obj;");
            }
            if (referenceable) {
                p.pOln("}");
            }
            p.pln("reader.nextElementContent();");
            p.pln("skipRemainingDetailEntries(reader);");
            p.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
            p.pln("return (isComplete ? (Object)detail : (Object)state);");
        } else {
            String valueStr = null;
            String javaName = type.getJavaType().getName();
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                String boxName = SimpleToBoxedUtil.getBoxedClassName(javaName);
                valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")obj", javaName);
            } else {
                valueStr = "(" + javaName + ")obj";
            }
            p.pln("detail = new " + this.env.getNames().customExceptionClassName(fault) + "(" + valueStr + ");");
            p.pln("reader.nextElementContent();");
            p.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
            p.pln("return detail;");
        }
        if (hasNext || fault.getSubfaults() == null) {
            p.pO("} ");
        }
    }

    private static boolean deserializeToDetail(SOAPStructureType type) {
        boolean detail = SOAPObjectSerializerGenerator.deserializeToDetail(type);
        return detail;
    }

    private void writeFaultSerializer(IndentingWriter p, Fault fault, String writer) throws IOException {
        Block block = fault.getBlock();
        String memberQName = this.env.getNames().getQNameName(fault.getElementName());
        AbstractType type = block.getType();
        String faultExceptionName = this.env.getNames().customExceptionClassName(fault);
        if (this.writeFaultSerializerElse) {
            p.p("else ");
        }
        p.plnI("if (detail instanceof " + faultExceptionName + ") {");
        SerializerWriter sWriter = this.writerFactory.createWriter(this.servicePackage, type);
        String serializer = sWriter.deserializerMemberName() + "_Serializer";
        String detailStr = "detail";
        JavaException exception = fault.getJavaException();
        if (!(type instanceof SOAPStructureType) && !(type instanceof LiteralStructuredType) && exception.getMembersCount() == 1 && fault.getSubfaults() == null) {
            Iterator members = exception.getMembers();
            JavaStructureMember javaMember = (JavaStructureMember)members.next();
            detailStr = "((" + faultExceptionName + ")" + detailStr + ")." + javaMember.getReadMethod() + "()";
            String javaName = javaMember.getType().getName();
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                detailStr = SimpleToBoxedUtil.getBoxedExpressionOfType(detailStr, javaName);
            }
        }
        p.pln(serializer + ".serialize(" + detailStr + ", " + memberQName + ", null, " + writer + ", context);");
        p.pOln("}");
    }
}

