/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.kerb;

import com.sun.xml.ws.security.kerb.CipherHelper;
import com.sun.xml.ws.security.kerb.Krb5Context;
import com.sun.xml.ws.security.kerb.Krb5Token;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.security.auth.kerberos.DelegationPermission;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import sun.security.jgss.GSSToken;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCred;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

abstract class InitialToken
extends Krb5Token {
    private static final int CHECKSUM_TYPE = 32771;
    private static final int CHECKSUM_LENGTH_SIZE = 4;
    private static final int CHECKSUM_BINDINGS_SIZE = 16;
    private static final int CHECKSUM_FLAGS_SIZE = 4;
    private static final int CHECKSUM_DELEG_OPT_SIZE = 2;
    private static final int CHECKSUM_DELEG_LGTH_SIZE = 2;
    private static final int CHECKSUM_DELEG_FLAG = 1;
    private static final int CHECKSUM_MUTUAL_FLAG = 2;
    private static final int CHECKSUM_REPLAY_FLAG = 4;
    private static final int CHECKSUM_SEQUENCE_FLAG = 8;
    private static final int CHECKSUM_CONF_FLAG = 16;
    private static final int CHECKSUM_INTEG_FLAG = 32;
    private final byte[] CHECKSUM_FIRST_BYTES = new byte[]{16, 0, 0, 0};
    private static final int CHANNEL_BINDING_AF_INET = 2;
    private static final int CHANNEL_BINDING_AF_INET6 = 24;
    private static final int CHANNEL_BINDING_AF_NULL_ADDR = 255;
    private static final int Inet4_ADDRSZ = 4;
    private static final int Inet6_ADDRSZ = 16;

    InitialToken() {
    }

    private int getAddrType(InetAddress addr) {
        int addressType = 255;
        if (addr instanceof Inet4Address) {
            addressType = 2;
        } else if (addr instanceof Inet6Address) {
            addressType = 24;
        }
        return addressType;
    }

    private byte[] getAddrBytes(InetAddress addr) throws GSSException {
        int addressType = this.getAddrType(addr);
        byte[] addressBytes = addr.getAddress();
        if (addressBytes != null) {
            switch (addressType) {
                case 2: {
                    if (addressBytes.length != 4) {
                        throw new GSSException(11, -1, "Incorrect AF-INET address length in ChannelBinding.");
                    }
                    return addressBytes;
                }
                case 24: {
                    if (addressBytes.length != 16) {
                        throw new GSSException(11, -1, "Incorrect AF-INET6 address length in ChannelBinding.");
                    }
                    return addressBytes;
                }
            }
            throw new GSSException(11, -1, "Cannot handle non AF-INET addresses in ChannelBinding.");
        }
        return null;
    }

    private byte[] computeChannelBinding(ChannelBinding channelBinding) throws GSSException {
        byte[] appDataBytes;
        InetAddress initiatorAddress = channelBinding.getInitiatorAddress();
        InetAddress acceptorAddress = channelBinding.getAcceptorAddress();
        int size = 20;
        int initiatorAddressType = this.getAddrType(initiatorAddress);
        int acceptorAddressType = this.getAddrType(acceptorAddress);
        byte[] initiatorAddressBytes = null;
        if (initiatorAddress != null) {
            initiatorAddressBytes = this.getAddrBytes(initiatorAddress);
            size += initiatorAddressBytes.length;
        }
        byte[] acceptorAddressBytes = null;
        if (acceptorAddress != null) {
            acceptorAddressBytes = this.getAddrBytes(acceptorAddress);
            size += acceptorAddressBytes.length;
        }
        if ((appDataBytes = channelBinding.getApplicationData()) != null) {
            size += appDataBytes.length;
        }
        byte[] data = new byte[size];
        int pos = 0;
        InitialToken.writeLittleEndian(initiatorAddressType, data, pos);
        pos += 4;
        if (initiatorAddressBytes != null) {
            InitialToken.writeLittleEndian(initiatorAddressBytes.length, data, pos);
            System.arraycopy(initiatorAddressBytes, 0, data, pos += 4, initiatorAddressBytes.length);
            pos += initiatorAddressBytes.length;
        } else {
            pos += 4;
        }
        InitialToken.writeLittleEndian(acceptorAddressType, data, pos);
        pos += 4;
        if (acceptorAddressBytes != null) {
            InitialToken.writeLittleEndian(acceptorAddressBytes.length, data, pos);
            System.arraycopy(acceptorAddressBytes, 0, data, pos += 4, acceptorAddressBytes.length);
            pos += acceptorAddressBytes.length;
        } else {
            pos += 4;
        }
        if (appDataBytes != null) {
            InitialToken.writeLittleEndian(appDataBytes.length, data, pos);
            System.arraycopy(appDataBytes, 0, data, pos += 4, appDataBytes.length);
            pos += appDataBytes.length;
        } else {
            pos += 4;
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            return md5.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GSSException(11, -1, "Could not get MD5 Message Digest - " + e.getMessage());
        }
    }

    public abstract byte[] encode() throws IOException;

    protected class OverloadedChecksum {
        private byte[] checksumBytes = null;
        private Credentials delegCreds = null;
        private int flags = 0;

        public OverloadedChecksum(Krb5Context context, Credentials tgt, Credentials serviceTicket) throws KrbException, IOException, GSSException {
            byte[] krbCredMessage = null;
            int pos = 0;
            int size = 24;
            if (context.getCredDelegState()) {
                if (!tgt.isForwardable()) {
                    context.setCredDelegState(false);
                } else {
                    KrbCred krbCred = null;
                    CipherHelper cipherHelper = context.getCipherHelper(serviceTicket.getSessionKey());
                    krbCred = this.useNullKey(cipherHelper) ? new KrbCred(tgt, serviceTicket, EncryptionKey.NULL_KEY) : new KrbCred(tgt, serviceTicket, serviceTicket.getSessionKey());
                    krbCredMessage = krbCred.getMessage();
                    size += 4 + krbCredMessage.length;
                }
            }
            this.checksumBytes = new byte[size];
            this.checksumBytes[pos++] = InitialToken.this.CHECKSUM_FIRST_BYTES[0];
            this.checksumBytes[pos++] = InitialToken.this.CHECKSUM_FIRST_BYTES[1];
            this.checksumBytes[pos++] = InitialToken.this.CHECKSUM_FIRST_BYTES[2];
            this.checksumBytes[pos++] = InitialToken.this.CHECKSUM_FIRST_BYTES[3];
            ChannelBinding localBindings = context.getChannelBinding();
            if (localBindings != null) {
                byte[] localBindingsBytes = InitialToken.this.computeChannelBinding(context.getChannelBinding());
                System.arraycopy(localBindingsBytes, 0, this.checksumBytes, pos, localBindingsBytes.length);
            }
            pos += 16;
            if (context.getCredDelegState()) {
                this.flags |= 1;
            }
            if (context.getMutualAuthState()) {
                this.flags |= 2;
            }
            if (context.getReplayDetState()) {
                this.flags |= 4;
            }
            if (context.getSequenceDetState()) {
                this.flags |= 8;
            }
            if (context.getIntegState()) {
                this.flags |= 0x20;
            }
            if (context.getConfState()) {
                this.flags |= 0x10;
            }
            byte[] temp = new byte[4];
            GSSToken.writeLittleEndian(this.flags, temp);
            this.checksumBytes[pos++] = temp[0];
            this.checksumBytes[pos++] = temp[1];
            this.checksumBytes[pos++] = temp[2];
            this.checksumBytes[pos++] = temp[3];
            if (context.getCredDelegState()) {
                PrincipalName delegateTo = serviceTicket.getServer();
                StringBuffer buf = new StringBuffer("\"");
                buf.append(delegateTo.getName()).append('\"');
                String realm = delegateTo.getRealmAsString();
                buf.append(" \"krbtgt/").append(realm).append('@');
                buf.append(realm).append('\"');
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    DelegationPermission perm = new DelegationPermission(buf.toString());
                    sm.checkPermission(perm);
                }
                this.checksumBytes[pos++] = 1;
                this.checksumBytes[pos++] = 0;
                if (krbCredMessage.length > 65535) {
                    throw new GSSException(11, -1, "Incorrect messsage length");
                }
                GSSToken.writeLittleEndian(krbCredMessage.length, temp);
                this.checksumBytes[pos++] = temp[0];
                this.checksumBytes[pos++] = temp[1];
                System.arraycopy(krbCredMessage, 0, this.checksumBytes, pos, krbCredMessage.length);
            }
        }

        public OverloadedChecksum(Krb5Context context, Checksum checksum, EncryptionKey key) throws GSSException, KrbException, IOException {
            boolean pos = false;
            this.checksumBytes = checksum.getBytes();
            if (this.checksumBytes[0] != InitialToken.this.CHECKSUM_FIRST_BYTES[0] || this.checksumBytes[1] != InitialToken.this.CHECKSUM_FIRST_BYTES[1] || this.checksumBytes[2] != InitialToken.this.CHECKSUM_FIRST_BYTES[2] || this.checksumBytes[3] != InitialToken.this.CHECKSUM_FIRST_BYTES[3]) {
                throw new GSSException(11, -1, "Incorrect checksum");
            }
            byte[] remoteBindingBytes = new byte[16];
            System.arraycopy(this.checksumBytes, 4, remoteBindingBytes, 0, 16);
            byte[] noBindings = new byte[16];
            boolean tokenContainsBindings = !Arrays.equals(noBindings, remoteBindingBytes);
            ChannelBinding localBindings = context.getChannelBinding();
            if (tokenContainsBindings || localBindings != null) {
                boolean badBindings = false;
                String errorMessage = null;
                if (tokenContainsBindings && localBindings != null) {
                    byte[] localBindingsBytes = InitialToken.this.computeChannelBinding(localBindings);
                    badBindings = !Arrays.equals(localBindingsBytes, remoteBindingBytes);
                    errorMessage = "Bytes mismatch!";
                } else if (localBindings == null) {
                    errorMessage = "ChannelBinding not provided!";
                    badBindings = true;
                } else {
                    errorMessage = "Token missing ChannelBinding!";
                    badBindings = true;
                }
                if (badBindings) {
                    throw new GSSException(1, -1, errorMessage);
                }
            }
            this.flags = GSSToken.readLittleEndian(this.checksumBytes, 20, 4);
            if ((this.flags & 1) > 0) {
                int credLen = GSSToken.readLittleEndian(this.checksumBytes, 26, 2);
                byte[] credBytes = new byte[credLen];
                System.arraycopy(this.checksumBytes, 28, credBytes, 0, credLen);
                CipherHelper cipherHelper = context.getCipherHelper(key);
                this.delegCreds = this.useNullKey(cipherHelper) ? new KrbCred(credBytes, EncryptionKey.NULL_KEY).getDelegatedCreds()[0] : new KrbCred(credBytes, key).getDelegatedCreds()[0];
            }
        }

        private boolean useNullKey(CipherHelper ch) {
            boolean flag = true;
            if (ch.getProto() == 1 || ch.isArcFour()) {
                flag = false;
            }
            return flag;
        }

        public Checksum getChecksum() throws KrbException {
            return new Checksum(this.checksumBytes, 32771);
        }

        public Credentials getDelegatedCreds() {
            return this.delegCreds;
        }

        public void setContextFlags(Krb5Context context) {
            if ((this.flags & 1) > 0) {
                context.setCredDelegState(true);
            }
            if ((this.flags & 2) == 0) {
                context.setMutualAuthState(false);
            }
            if ((this.flags & 4) == 0) {
                context.setReplayDetState(false);
            }
            if ((this.flags & 8) == 0) {
                context.setSequenceDetState(false);
            }
            if ((this.flags & 0x10) == 0) {
                context.setConfState(false);
            }
            if ((this.flags & 0x20) == 0) {
                context.setIntegState(false);
            }
        }
    }
}

