/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.xml.ws.rx.rm.faults;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rx.rm.runtime.RmRuntimeVersion;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;

/**
 * Properties:
 * [Code] Sender or Receiver
 * [Subcode] wsrm:CreateSequenceRefused
 * [Reason] The Create Sequence request has been refused by the RM Destination.
 * [Detail] xs:any
 *
 * Generated by: RM Source or RM Destination.
 * Condition : In response to a CreateSequence message when the RM Destination does not wish to create a new Sequence.
 * Action Upon Generation : Unspecified.
 * Action Upon Receipt : Sequence terminated.
 *
 * @author Marek Potociar (marek.potociar at sun.com)
 */
public class CreateSequenceRefusedFault extends AbstractSoapFaultException {
    private static final long serialVersionUID = 1533003947712389030L;
    private static final String REASON = "The Create Sequence request has been refused by the RM Destination.";
    //
    private final Code code;

    public CreateSequenceRefusedFault(String exceptionMessage, Code code) {
        super(exceptionMessage, REASON, true);
        this.code = code;
    }

    public CreateSequenceRefusedFault(String exceptionMessage, Code code, Throwable cause) {
        super(exceptionMessage, REASON, true, cause);
        
        this.code = code;
    }

    @Override
    public Code getCode() {
        return code;
    }

    @Override
    public QName getSubcode(RmRuntimeVersion rv) {
        return rv.protocolVersion.createSequenceRefusedFaultCode;
    }

    @Override
    public Detail getDetail(RuntimeContext rc) {
        return null;
    }

    @Override
    public Packet toRequest(RuntimeContext rc) {
        return rc.communicator.createRequestPacket(
                createSoapFaultMessage(rc, false),
                getProperFaultActionForAddressingVersion(rc.rmVersion, rc.addressingVersion),
                false);
    }

    @Override
    public Packet toResponse(RuntimeContext rc, Packet request) {
        return rc.communicator.createResponsePacket(
                request,
                createSoapFaultMessage(rc, false),
                getProperFaultActionForAddressingVersion(rc.rmVersion, rc.addressingVersion));
    }
}
