/*
 * Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

/**
 * <P>
 * This package and its sub-packages describe the API classes and interfaces
 * for the JAXR API. In this package are the high-level interfaces and classes
 * that a client uses to interact with a registry via a JAXR provider.
 * </p>
 * <p>Figure 1 shows the primary interfaces in the JAXR API.</p>
 * <p>
 * <center><img SRC="{@docRoot}/resources/images/apiClasses.gif" ALT="Primary Interfaces in the JAXR API">
 * <br><b>Figure 1. Primary Interfaces in the JAXR API</b>
 * </center>
 * </p>
 * 
 * <p>Figure 2 shows the response and exception classes in the JAXR API.</p>
 * <p>
 * <center><img SRC="{@docRoot}/resources/images/responsesAndException.gif" ALT="Response and Exception Classes in the JAXR API">
 * <br><b>Figure 2.  Response and Exception Classes in the JAXR API</b>
 * </center>
 * </p>
 *
 * @since 1.0
 */
package javax.xml.registry;
