/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;

public class SOAPObjectSerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    protected String serializerName;
    protected String serializerMemberName;
    private SOAPType dataType;

    public SOAPObjectSerializerWriter(String basePackage, SOAPType type, Names names) {
        super(type, names);
        this.dataType = type;
        this.serializerName = names.typeObjectSerializerClassName(basePackage, type);
        this.serializerMemberName = names.getClassMemberName(this.serializerName);
    }

    @Override
    public void createSerializer(IndentingWriter p, StringBuffer typeName, String serName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        String encodeType;
        SOAPType type = (SOAPType)this.type;
        String nillable = type.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        String multiRef = multiRefEncoding && type.isReferenceable() ? "SERIALIZE_AS_REF" : "DONT_SERIALIZE_AS_REF";
        String string2 = encodeType = encodeTypes ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        if (type instanceof RPCRequestOrderedStructureType || type instanceof RPCRequestUnorderedStructureType || type instanceof RPCResponseStructureType || type.getJavaType() instanceof JavaException) {
            if (!(type.getJavaType() instanceof JavaException)) {
                encodeType = "DONT_ENCODE_TYPE";
            }
            multiRef = "DONT_SERIALIZE_AS_REF";
        }
        this.declareType(p, typeName, type.getName(), false, false);
        p.plnI("CombinedSerializer " + serName + " = new " + this.serializerName + "(" + typeName + ",");
        p.pln(encodeType + ", " + nillable + ", " + this.getEncodingStyleString() + ");");
        p.pO();
        if (type.isReferenceable()) {
            p.pln(serName + " = new " + "ReferenceableSerializerImpl" + "(" + multiRef + ", " + serName + ", " + this.getSOAPVersionString() + ");");
        }
    }

    @Override
    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln(modifier + "CombinedSerializer" + " " + this.serializerMemberName() + ";");
    }

    @Override
    public String serializerName() {
        return this.serializerName;
    }

    @Override
    public String serializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    @Override
    public String deserializerName() {
        return this.serializerName;
    }

    @Override
    public String deserializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }
}

