/*
 * Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

/**
 * <p>
 * This package describes the information model for the Jakarta XML Registries
 * API. It is based largely on the ebXML Registry Information Model with enhancements
 * to support other registry specifications such as UDDI.
 *
 * <p>The class diagram in Figure 1 shows the public view of the information
 * model.</p>
 *
 * <center>
 * <img SRC="{@docRoot}/resources/images/public.gif" ALT="Information Model Public View">
 * <br><b>Figure 1. Information Model Public View</b>
 * </center>
 *
 * <p>The class diagram in Figure 2 shows the inheritance view of the information
 * model.</p>
 * 
 * <center>
 * <img SRC="{@docRoot}/resources/images/object.gif" ALT="Information Model Detailed View">
 * <br><b>Figure 2. Information Model Detailed View</b>
 * </center>
 *
 * @since 1.0
 */
package javax.xml.registry.infomodel;
