/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.infomodel.URIValidator;

public class URIValidatorImpl
implements URIValidator,
Serializable {
    private boolean validateURI = false;

    public boolean getValidateURI() {
        return this.validateURI;
    }

    public void setValidateURI(boolean validate) {
        this.validateURI = validate;
    }

    void validate(String uri) throws InvalidRequestException {
        if (!this.validateURI) {
            return;
        }
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:Malformed_URL_Exception:_") + uri, (Throwable)e);
        }
        if (url.getProtocol().equalsIgnoreCase("http")) {
            try {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                int responseCode = connection.getResponseCode();
                if (responseCode == 404) {
                    throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:Received_response_code_") + responseCode + ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:_for_uri_") + uri);
                }
                if (responseCode < 200 || responseCode > 302 && responseCode != 400) {
                    throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:Received_response_code_") + responseCode + ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:_for_uri_") + uri);
                }
            }
            catch (UnknownHostException uhe) {
                throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:Make_sure_your_proxies_are_set._Received_error:_") + uhe, (Throwable)uhe);
            }
            catch (Exception e) {
                throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("URIValidatorImpl:Could_not_validate_") + uri + ":" + e, (Throwable)e);
            }
        }
    }
}

