/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.nodes;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.nodes.MappingException;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.ExtendedModelVisitor;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttachmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralIDType;
import com.sun.xml.rpc.processor.model.literal.LiteralListType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPListType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.util.ClassNameCollector;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class TypeVisitor
extends ExtendedModelVisitor
implements SOAPTypeVisitor,
LiteralTypeVisitor {
    private Configuration config;
    private Set _visitedComplexTypes;
    private Set _visitedSimpleTypes;
    private Set _visitedFaults;
    private Map _visitedNSPackages;
    private boolean _trace = false;

    public TypeVisitor(Configuration config) {
        this.config = config;
        this._visitedComplexTypes = new HashSet();
        this._visitedSimpleTypes = new HashSet();
        this._visitedFaults = new HashSet();
        this._visitedNSPackages = new HashMap();
    }

    public Set getComplexTypes() {
        return this._visitedComplexTypes;
    }

    public Set getSimpleTypes() {
        return this._visitedSimpleTypes;
    }

    public Set getFaults() {
        return this._visitedFaults;
    }

    public Map getNamespacePackages() {
        return this._visitedNSPackages;
    }

    @Override
    protected void preVisit(Model model) throws Exception {
        if (this._trace) {
            System.out.println("preVisit: model");
        }
        ClassNameCollector collector = new ClassNameCollector();
        collector.process(model);
        Set names = collector.getConflictingClassNames();
        if (!names.isEmpty()) {
            throw new MappingException("j2ee.nameCollision", new Object[]{names.toString()});
        }
    }

    @Override
    protected void postVisit(Model model) throws Exception {
        this.processTypes(model);
    }

    protected void processTypes(Model model) throws Exception {
        Iterator iter = model.getExtraTypes();
        while (iter.hasNext()) {
            AbstractType extraType = (AbstractType)iter.next();
            if (extraType.isLiteralType()) {
                this.describe((LiteralType)extraType);
                continue;
            }
            if (!extraType.isSOAPType()) continue;
            this.describe((SOAPType)extraType);
        }
    }

    @Override
    protected void preVisit(Service service) throws Exception {
        if (this._trace) {
            System.out.println("preVisit server " + service.getName());
        }
    }

    @Override
    protected void postVisit(Service service) throws Exception {
    }

    @Override
    protected void preVisit(Port port) throws Exception {
        if (this._trace) {
            System.out.println("preVisit port:" + port.getName());
        }
        this.processNamespacePackages(port);
    }

    @Override
    protected void postVisit(Port port) throws Exception {
    }

    @Override
    protected void preVisit(Operation operation) throws Exception {
        if (this._trace) {
            System.out.println("preVisit operation:" + operation.getName());
        }
    }

    @Override
    protected void postVisit(Operation operation) throws Exception {
    }

    @Override
    protected void preVisit(Request request) throws Exception {
        if (this._trace) {
            System.out.println("preVisit Request");
        }
    }

    @Override
    protected void postVisit(Request request) throws Exception {
    }

    @Override
    protected void preVisit(Response response) throws Exception {
        if (this._trace) {
            System.out.println("preVisit Response");
        }
    }

    @Override
    protected void postVisit(Response response) throws Exception {
    }

    @Override
    protected void preVisit(Fault fault) throws Exception {
        boolean alreadySeen;
        if (this._trace) {
            System.out.println("preVisit Fault:" + fault.getName() + "; type = " + fault.getClass().getName());
        }
        if (alreadySeen = this._visitedFaults.contains(fault)) {
            return;
        }
        this._visitedFaults.add(fault);
    }

    @Override
    protected void postVisit(Fault fault) throws Exception {
    }

    @Override
    protected void visitBodyBlock(Block block) throws Exception {
        if (block.getType().isLiteralType()) {
            this.describe((LiteralType)block.getType());
        } else if (block.getType().isSOAPType()) {
            this.describe((SOAPType)block.getType());
        }
    }

    @Override
    protected void visitHeaderBlock(Block block) throws Exception {
        if (block.getType().isLiteralType()) {
            this.describe((LiteralType)block.getType());
        } else if (block.getType().isSOAPType()) {
            this.describe((SOAPType)block.getType());
        }
    }

    @Override
    protected void visitFaultBlock(Block block) throws Exception {
        if (block.getType().isLiteralType()) {
            this.describe((LiteralType)block.getType());
        } else if (block.getType().isSOAPType()) {
            this.describe((SOAPType)block.getType());
        }
    }

    @Override
    protected void visit(Parameter parameter) throws Exception {
        if (this._trace) {
            System.out.println("visit Parameter:" + parameter.getName());
        }
        if (parameter.getType().isLiteralType()) {
            this.describe((LiteralType)parameter.getType());
        } else if (parameter.getType().isSOAPType()) {
            this.describe((SOAPType)parameter.getType());
        }
    }

    protected void describe(LiteralType type) throws Exception {
        this.processNamespacePackages(type);
        type.accept(this);
    }

    @Override
    public void visit(LiteralSimpleType type) throws Exception {
        if (this._trace) {
            System.out.println("visit LiteralSimpleType:" + type.getName());
        }
    }

    @Override
    public void visit(LiteralSequenceType type) throws Exception {
        if (this._trace) {
            System.out.println("visit LiteralSequenceType:" + type.getName());
        }
        this.visitLiteralStructuredType(type, "LITERAL-SEQUENCE-TYPE ", true);
    }

    @Override
    public void visit(LiteralAllType type) throws Exception {
        if (this._trace) {
            System.out.println("visit LiteralAllType:" + type.getName());
        }
        this.visitLiteralStructuredType(type, "LITERAL-ALL-TYPE ", true);
    }

    @Override
    public void visit(LiteralEnumerationType type) throws Exception {
        if (this._trace) {
            System.out.println("visit LiteralEnumerationType " + type.getName());
        }
        if (!this._visitedSimpleTypes.contains(type)) {
            this._visitedSimpleTypes.add(type);
            this.describe(type.getBaseType());
        }
    }

    @Override
    public void visit(LiteralListType type) throws Exception {
        if (this._trace) {
            System.out.println("visit LiteralListType " + type.getName());
        }
    }

    @Override
    public void visit(LiteralIDType type) throws Exception {
        if (this._trace) {
            System.out.println("visit LiteralIDType " + type.getName());
        }
    }

    @Override
    public void visit(LiteralArrayWrapperType type) throws Exception {
        if (this._trace) {
            System.out.println("visit LiteralArrayWrapperType" + type.getName() + " javatype = " + type.getJavaType().getName());
        }
    }

    private void visitLiteralStructuredType(LiteralStructuredType type, String header, boolean detailed) throws Exception {
        boolean alreadySeen;
        if (this._trace) {
            System.out.println("visit LiteralStructuredType:" + type.getName());
        }
        if (alreadySeen = this._visitedComplexTypes.contains(type)) {
            return;
        }
        this._visitedComplexTypes.add(type);
        if (detailed) {
            this.processAttributeMembers(type);
            this.processElementMembers(type);
        }
    }

    protected void processAttributeMembers(LiteralStructuredType type) throws Exception {
        Iterator iter = type.getAttributeMembers();
        while (iter.hasNext()) {
            LiteralAttributeMember attribute = (LiteralAttributeMember)iter.next();
            this.writeAttributeMember(attribute);
        }
    }

    protected void writeAttributeMember(LiteralAttributeMember attribute) throws Exception {
        this.describe(attribute.getType());
    }

    protected void processElementMembers(LiteralStructuredType type) throws Exception {
        Iterator iter = type.getElementMembers();
        while (iter.hasNext()) {
            LiteralElementMember element = (LiteralElementMember)iter.next();
            this.writeElementMember(element);
        }
    }

    protected void writeElementMember(LiteralElementMember element) throws Exception {
        this.describe(element.getType());
    }

    @Override
    public void visit(LiteralArrayType type) throws Exception {
        if (this._trace) {
            System.out.println("visit LiteralArrayType:" + type.getName());
        }
        this.describe(type.getElementType());
    }

    @Override
    public void visit(LiteralFragmentType type) throws Exception {
        if (this._trace) {
            System.out.println("visit LiteralFragmentType:" + type.getName());
        }
    }

    protected void describe(SOAPType type) throws Exception {
        this.processNamespacePackages(type);
        type.accept(this);
    }

    @Override
    public void visit(SOAPArrayType type) throws Exception {
        if (this._trace) {
            System.out.println("visit SOAPArrayType:" + type.getName());
        }
        this.describe(type.getElementType());
    }

    @Override
    public void visit(SOAPCustomType type) throws Exception {
        if (this._trace) {
            System.out.println("visit SOAPCustomType:" + type.getName());
        }
    }

    @Override
    public void visit(SOAPEnumerationType type) throws Exception {
        if (this._trace) {
            System.out.println("visit SOAPEnumerationType:" + type.getName());
        }
        if (!this._visitedSimpleTypes.contains(type)) {
            this._visitedSimpleTypes.add(type);
            this.describe(type.getBaseType());
        }
    }

    @Override
    public void visit(SOAPSimpleType type) throws Exception {
        if (this._trace) {
            System.out.println("visit SOAPSimpleType:" + type.getName());
        }
    }

    @Override
    public void visit(SOAPAnyType type) throws Exception {
        if (this._trace) {
            System.out.println("visit SOAPAnyType:" + type.getName());
        }
    }

    @Override
    public void visit(SOAPOrderedStructureType type) throws Exception {
        if (this._trace) {
            System.out.println("visit SOAPStructuredType:" + type.getName());
        }
        this.visitSOAPStructureType(type, "SOAP-ORDERED-STRUCTURE-TYPE", true);
    }

    @Override
    public void visit(SOAPUnorderedStructureType type) throws Exception {
        if (this._trace) {
            System.out.println("visit SOAPUnorderedStructuredType:" + type.getName());
        }
        this.visitSOAPStructureType(type, "SOAP-UNORDERED-STRUCTURE-TYPE", true);
    }

    @Override
    public void visit(SOAPListType type) throws Exception {
        if (this._trace) {
            System.out.println("visit SOAPUnorderedStructuredType:" + type.getName());
        }
    }

    @Override
    public void visit(RPCRequestOrderedStructureType type) throws Exception {
        if (this._trace) {
            System.out.println("visit RPCRequestOrderedStructureType:" + type.getName());
        }
        this.visitSOAPStructureType(type, "RPC-REQUEST-ORDERED-STRUCTURE-TYPE", false);
    }

    @Override
    public void visit(RPCRequestUnorderedStructureType type) throws Exception {
        if (this._trace) {
            System.out.println("visit RPCRequestUnorderedStructureType:" + type.getName());
        }
        this.visitSOAPStructureType(type, "RPC-REQUEST-UNORDERED-STRUCTURE-TYPE", false);
    }

    @Override
    public void visit(RPCResponseStructureType type) throws Exception {
        if (this._trace) {
            System.out.println("visit RPCResponseStructureType:" + type.getName());
        }
        this.visitSOAPStructureType(type, "RPC-RESPONSE-STRUCTURE-TYPE", false);
    }

    private void visitSOAPStructureType(SOAPStructureType type, String header, boolean detailed) throws Exception {
        boolean alreadySeen;
        if (this._trace) {
            System.out.println("visit SOAPStructureType:" + type.getName());
        }
        if (alreadySeen = this._visitedComplexTypes.contains(type)) {
            return;
        }
        this._visitedComplexTypes.add(type);
        if (detailed) {
            if (type.getParentType() != null) {
                this.describe(type.getParentType());
            }
            this.processMembers(type);
        }
    }

    protected void processMembers(SOAPStructureType type) throws Exception {
        Iterator iter = type.getMembers();
        while (iter.hasNext()) {
            SOAPStructureMember member = (SOAPStructureMember)iter.next();
            this.writeMember(member);
        }
    }

    protected void writeMember(SOAPStructureMember member) throws Exception {
        this.describe(member.getType());
    }

    private void processNamespacePackages(AbstractType type) {
        if (!(type instanceof RPCRequestOrderedStructureType || type instanceof RPCRequestOrderedStructureType || type instanceof RPCResponseStructureType || type.getName() != null && !this._visitedNSPackages.keySet().contains(type.getName().getNamespaceURI()))) {
            return;
        }
        String uri = type.getName().getNamespaceURI();
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) || "http://schemas.xmlsoap.org/soap/encoding/".equals(uri) || "http://www.w3.org/2002/06/soap-encoding".equals(uri) || "".equals(uri)) {
            return;
        }
        String javaType = type.getJavaType().getName();
        String packageName = javaType.substring(0, javaType.lastIndexOf("."));
        if (this._trace) {
            System.out.println("Namespace=" + uri + "; package=" + packageName);
        }
        this._visitedNSPackages.put(uri, packageName);
    }

    private void processNamespacePackages(Port port) {
        QName bindingQName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName");
        String uri = bindingQName.getNamespaceURI();
        String packageName = (String)this._visitedNSPackages.get(uri);
        if (packageName == null) {
            ProcessorEnvironment env = (ProcessorEnvironment)this.config.getEnvironment();
            JavaInterface intf = port.getJavaInterface();
            String className = env.getNames().customJavaTypeClassName(intf);
            packageName = className.substring(0, className.lastIndexOf("."));
            this._visitedNSPackages.put(uri, packageName);
        }
    }

    @Override
    public void visit(LiteralAttachmentType type) throws Exception {
    }
}

