/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.at.WSATConstants;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.EndpointReference;

public class WSATXAResource
implements WSATConstants,
XAResource,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(WSATXAResource.class);
    static final long serialVersionUID = -5827137400010343968L;
    private Xid m_xid;
    static final String ACTIVE = "ACTIVE";
    private volatile String m_status = "ACTIVE";
    private Transactional.Version m_version;
    private boolean m_isRemovedFromMap = false;
    private transient EndpointReference m_epr;

    public WSATXAResource(EndpointReference epr, Xid xid) {
        this(Transactional.Version.WSAT10, epr, xid, false);
    }

    public WSATXAResource(Transactional.Version version, EndpointReference epr, Xid xid) {
        this(version, epr, xid, false);
    }

    public WSATXAResource(Transactional.Version version, EndpointReference epr, Xid xid, boolean isRecovery) {
        this.m_version = version;
        if (epr == null) {
            throw new IllegalArgumentException("endpoint reference can't be null");
        }
        this.m_epr = epr;
        this.m_xid = xid;
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4538_WSAT_XARESOURCE(this.m_epr.toString(), this.m_xid, ""));
        }
        if (isRecovery) {
            this.m_status = "Prepared";
        }
    }

    WSATHelper getWSATHelper() {
        return WSATHelper.getInstance(this.m_version);
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        this.debug("prepare xid:" + xid);
        if (WSATHelper.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4539_PREPARE(this.m_epr.toString(), this.m_xid));
        }
        this.getWSATHelper().prepare(this.m_epr, this.m_xid, this);
        try {
            WSATXAResource wSATXAResource = this;
            synchronized (wSATXAResource) {
                if (this.m_status.equals("ReadOnly")) {
                    return 3;
                }
                if (this.m_status.equals("Prepared")) {
                    if (WSATHelper.isDebugEnabled()) {
                        LOGGER.info(LocalizationMessages.WSAT_4540_PREPARED_BEFORE_WAIT(this.m_epr.toString(), this.m_xid));
                    }
                    return 0;
                }
                if (this.m_status.equals("Aborted")) {
                    throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("prepare", 100);
                }
                if (WSATHelper.isDebugEnabled()) {
                    LOGGER.info(LocalizationMessages.WSAT_4541_PREPARE_WAITING_FOR_REPLY(this.m_epr.toString(), this.m_xid));
                }
                this.wait(this.getWaitForReplyTimeout());
                if (WSATHelper.isDebugEnabled()) {
                    LOGGER.info(LocalizationMessages.WSAT_4542_PREPARE_FINISHED_WAITING_FOR_REPLY(this.m_epr.toString(), this.m_xid));
                }
            }
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4543_PREPARE_RECEIVED_REPLY_STATUS(this.m_status, this.m_epr.toString(), this.m_xid));
            }
            if (this.m_status.equals("ReadOnly")) {
                this.logSuccess("preparereadonly");
                return 3;
            }
            if (this.m_status.equals("Prepared")) {
                this.logSuccess("prepareprepared");
                return 0;
            }
            if (this.m_status.equals("Aborted")) {
                throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("prepare", 100);
            }
            LOGGER.severe(LocalizationMessages.WSAT_4544_FAILED_STATE_FOR_PREPARE(this.m_status, this.m_epr.toString(), this.m_xid));
            throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("prepare", -7);
        }
        catch (InterruptedException e) {
            LOGGER.info(LocalizationMessages.WSAT_4545_INTERRUPTED_EXCEPTION_DURING_PREPARE(e, this.m_epr.toString(), this.m_xid));
            XAException xaException = new XAException("InterruptedException during WS-AT XAResource prepare");
            xaException.errorCode = -7;
            xaException.initCause(e);
            throw xaException;
        }
    }

    private XAException newFailedStateXAExceptionForMethodNameAndErrorcode(String method, int errorcode) {
        XAException xaException = new XAException("Failed state during " + method + " of WS-AT XAResource:" + this);
        xaException.errorCode = errorcode;
        return xaException;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.m_isRemovedFromMap) {
            this.getWSATHelper().removeDurableParticipant(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block18: {
            this.debug("commit xid:" + xid + " onePhase:" + onePhase);
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4546_COMMIT(this.m_epr.toString(), this.m_xid));
            }
            this.getWSATHelper().commit(this.m_epr, this.m_xid, this);
            try {
                XAException xaException;
                WSATXAResource wSATXAResource = this;
                synchronized (wSATXAResource) {
                    block17: {
                        if (!this.m_status.equals("Committed")) break block17;
                        if (WSATHelper.isDebugEnabled()) {
                            LOGGER.info(LocalizationMessages.WSAT_4547_COMMIT_BEFORE_WAIT(this.m_epr.toString(), this.m_xid));
                        }
                        this.getWSATHelper().removeDurableParticipant(this);
                        this.m_isRemovedFromMap = true;
                        return;
                    }
                    if (WSATHelper.isDebugEnabled()) {
                        LOGGER.info(LocalizationMessages.WSAT_4548_COMMIT_WAITING_FOR_REPLY(this.m_epr.toString(), this.m_xid));
                    }
                    this.wait(this.getWaitForReplyTimeout());
                    if (WSATHelper.isDebugEnabled()) {
                        LOGGER.info(LocalizationMessages.WSAT_4549_COMMIT_FINISHED_WAITING_FOR_REPLY(this.m_epr.toString(), this.m_xid));
                    }
                }
                if (WSATHelper.isDebugEnabled()) {
                    LOGGER.info(LocalizationMessages.WSAT_4550_COMMIT_RECEIVED_REPLY_STATUS(this.m_status, this.m_epr.toString(), this.m_xid));
                }
                if (this.m_status.equals("Committed")) {
                    this.logSuccess("preparecommitted");
                    this.getWSATHelper().removeDurableParticipant(this);
                    this.m_isRemovedFromMap = true;
                    break block18;
                }
                if (this.m_status.equals("Prepared")) {
                    LOGGER.severe(LocalizationMessages.WSAT_4551_FAILED_STATE_FOR_COMMIT(this.m_status, this.m_epr.toString(), this.m_xid));
                    xaException = this.newFailedStateXAExceptionForMethodNameAndErrorcode("commit", -7);
                    this.log("Failed state during WS-AT XAResource commit:" + this.m_status, xaException);
                    throw xaException;
                }
                LOGGER.severe(LocalizationMessages.WSAT_4551_FAILED_STATE_FOR_COMMIT(this.m_status, this.m_epr.toString(), this.m_xid));
                xaException = this.newFailedStateXAExceptionForMethodNameAndErrorcode("commit", -6);
                this.log("Failed state during WS-AT XAResource commit:" + this.m_status, xaException);
                throw xaException;
            }
            catch (InterruptedException e) {
                LOGGER.severe(LocalizationMessages.WSAT_4552_INTERRUPTED_EXCEPTION_DURING_COMMIT(this.m_epr.toString(), this.m_xid), (Throwable)e);
                XAException xaException = new XAException("InterruptedException during WS-AT XAResource commit:" + e);
                xaException.errorCode = -7;
                xaException.initCause(e);
                throw xaException;
            }
            finally {
                this.getWSATHelper().removeDurableParticipant(this);
            }
        }
    }

    int getWaitForReplyTimeout() {
        return this.getWSATHelper().getWaitForReplyTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        block18: {
            this.debug("rollback xid:" + xid);
            if (WSATHelper.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4553_ROLLBACK(this.m_epr.toString(), this.m_xid));
            }
            this.getWSATHelper().rollback(this.m_epr, this.m_xid, this);
            try {
                WSATXAResource wSATXAResource = this;
                synchronized (wSATXAResource) {
                    block17: {
                        if (!this.m_status.equals("Aborted")) break block17;
                        if (WSATHelper.isDebugEnabled()) {
                            LOGGER.info(LocalizationMessages.WSAT_4554_ROLLBACK_BEFORE_WAIT(this.m_epr.toString(), this.m_xid));
                        }
                        this.getWSATHelper().removeDurableParticipant(this);
                        this.m_isRemovedFromMap = true;
                        return;
                    }
                    if (WSATHelper.isDebugEnabled()) {
                        LOGGER.info(LocalizationMessages.WSAT_4555_ROLLBACK_WAITING_FOR_REPLY(this.m_epr.toString(), this.m_xid));
                    }
                    this.wait(this.getWaitForReplyTimeout());
                    if (WSATHelper.isDebugEnabled()) {
                        LOGGER.info(LocalizationMessages.WSAT_4556_ROLLBACK_FINISHED_WAITING_FOR_REPLY(this.m_epr.toString(), this.m_xid));
                    }
                }
                if (WSATHelper.isDebugEnabled()) {
                    LOGGER.info(LocalizationMessages.WSAT_4557_ROLLBACK_RECEIVED_REPLY_STATUS(this.m_status, this.m_epr.toString(), this.m_xid));
                }
                if (this.m_status.equals("Aborted")) {
                    this.logSuccess("rollbackaborted");
                    this.getWSATHelper().removeDurableParticipant(this);
                    this.m_isRemovedFromMap = true;
                    break block18;
                }
                if (this.m_status.equals("Prepared")) {
                    LOGGER.severe(LocalizationMessages.WSAT_4558_FAILED_STATE_FOR_ROLLBACK(this.m_status, this.m_epr.toString(), this.m_xid));
                    throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("rollback", -7);
                }
                LOGGER.severe(LocalizationMessages.WSAT_4558_FAILED_STATE_FOR_ROLLBACK(this.m_status, this.m_epr.toString(), this.m_xid));
                throw this.newFailedStateXAExceptionForMethodNameAndErrorcode("rollback", -7);
            }
            catch (InterruptedException e) {
                LOGGER.severe(LocalizationMessages.WSAT_4559_INTERRUPTED_EXCEPTION_DURING_ROLLBACK(this.m_epr.toString(), this.m_xid), (Throwable)e);
                XAException xaException = new XAException("InterruptedException during WS-AT XAResource rollback");
                xaException.errorCode = -7;
                xaException.initCause(e);
                throw xaException;
            }
            finally {
                this.getWSATHelper().removeDurableParticipant(this);
            }
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        return true;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return false;
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        return new Xid[0];
    }

    public Xid getXid() {
        return this.m_xid;
    }

    public void setBranchQualifier(byte[] bqual) {
    }

    public void setXid(Xid xid) {
        this.m_xid = xid;
    }

    public boolean equals(Object obj) {
        return obj instanceof WSATXAResource && ((WSATXAResource)obj).getXid().equals(this.m_xid) && ((WSATXAResource)obj).m_epr.toString().equals(this.m_epr.toString());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.m_epr.writeTo((Result)new StreamResult(bos));
        byte[] eprBytes = bos.toByteArray();
        oos.writeInt(eprBytes.length);
        oos.write(eprBytes);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        int len = ois.readInt();
        byte[] eprBytes = new byte[len];
        ois.readFully(eprBytes);
        this.m_epr = EndpointReference.readFrom((Source)new StreamSource(new ByteArrayInputStream(eprBytes)));
        this.m_status = "Prepared";
    }

    private void log(String message, XAException xaex) {
        LOGGER.warning(message + " XAException.errorcode:" + xaex.errorCode, (Throwable)xaex);
    }

    private void logSuccess(String method) {
        LOGGER.info("success state during " + method + " of WS-AT XAResource:" + this);
    }

    private void debug(String msg) {
        LOGGER.info(msg);
    }

    public String toString() {
        return "WSATXAResource: xid" + this.m_xid + " status:" + this.m_status + " epr:" + this.m_epr + " isRemovedFromMap:" + this.m_isRemovedFromMap;
    }
}

