/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

// Helper class generated by wscompile, do not edit.
// Contents subject to change without notice.

package com.sun.xml.rpc.encoding.soap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;

import javax.xml.namespace.QName;

import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InterfaceSerializerBase;
import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;

public class CollectionInterfaceSerializer
    extends InterfaceSerializerBase
    implements Initializable, InternalEncodingConstants {
        
    private CombinedSerializer vectorSerializer;
    private CombinedSerializer stackSerializer;
    private CombinedSerializer linkedListSerializer;
    private CombinedSerializer arrayListSerializer;
    private CombinedSerializer hashSetSerializer;
    private CombinedSerializer treeSetSerializer;

    private com.sun.xml.rpc.soap.SOAPEncodingConstants soapEncodingConstants =
        null;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants =
            SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public CollectionInterfaceSerializer(
        QName type,
        boolean encodeType,
        boolean isNullable,
        String encodingStyle) {
            
        this(type, encodeType, isNullable, encodingStyle, SOAPVersion.SOAP_11);
    }

    public CollectionInterfaceSerializer(
        QName type,
        boolean encodeType,
        boolean isNullable,
        String encodingStyle,
        SOAPVersion ver) {
            
        super(type, encodeType, isNullable, encodingStyle);
        init(ver); // Initialize SOAP constants
    }

    public void initialize(InternalTypeMappingRegistry registry)
        throws Exception {
            
        vectorSerializer =
            (CombinedSerializer) registry.getSerializer(
                encodingStyle,
                Vector.class,
                QNAME_TYPE_VECTOR);
        vectorSerializer = vectorSerializer.getInnermostSerializer();
        stackSerializer =
            (CombinedSerializer) registry.getSerializer(
                encodingStyle,
                Stack.class,
                QNAME_TYPE_STACK);
        stackSerializer = stackSerializer.getInnermostSerializer();
        linkedListSerializer =
            (CombinedSerializer) registry.getSerializer(
                encodingStyle,
                LinkedList.class,
                QNAME_TYPE_LINKED_LIST);
        linkedListSerializer = linkedListSerializer.getInnermostSerializer();
        arrayListSerializer =
            (CombinedSerializer) registry.getSerializer(
                encodingStyle,
                ArrayList.class,
                QNAME_TYPE_ARRAY_LIST);
        arrayListSerializer = arrayListSerializer.getInnermostSerializer();
        hashSetSerializer =
            (CombinedSerializer) registry.getSerializer(
                encodingStyle,
                HashSet.class,
                QNAME_TYPE_HASH_SET);
        hashSetSerializer = hashSetSerializer.getInnermostSerializer();
        treeSetSerializer =
            (CombinedSerializer) registry.getSerializer(
                encodingStyle,
                TreeSet.class,
                QNAME_TYPE_TREE_SET);
        treeSetSerializer = treeSetSerializer.getInnermostSerializer();
    }

    public Object doDeserialize(
        QName name,
        XMLReader reader,
        SOAPDeserializationContext context)
        throws Exception {
            
        QName elementType = getType(reader);
        if (elementType.equals(QNAME_TYPE_COLLECTION)
            || elementType.equals(QNAME_TYPE_LIST)
            || elementType.equals(QNAME_TYPE_ARRAY_LIST)) {
            return arrayListSerializer.deserialize(name, reader, context);
        } else if (elementType.equals(QNAME_TYPE_LINKED_LIST)) {
            return linkedListSerializer.deserialize(name, reader, context);
        } else if (elementType.equals(QNAME_TYPE_VECTOR)) {
            return vectorSerializer.deserialize(name, reader, context);
        } else if (elementType.equals(QNAME_TYPE_STACK)) {
            return stackSerializer.deserialize(name, reader, context);
        } else if (
            elementType.equals(QNAME_TYPE_SET)
                || elementType.equals(QNAME_TYPE_HASH_SET)) {
            return hashSetSerializer.deserialize(name, reader, context);
        } else if (elementType.equals(QNAME_TYPE_TREE_SET)) {
            return treeSetSerializer.deserialize(name, reader, context);
        }
        throw new DeserializationException(
            "soap.unexpectedElementType",
            new Object[] { "", elementType.toString()});
    }

    public void doSerializeInstance(
        Object obj,
        QName name,
        SerializerCallback callback,
        XMLWriter writer,
        SOAPSerializationContext context)
        throws Exception {

        if (obj instanceof Stack) {
            stackSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof Vector) {
            vectorSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof ArrayList) {
            arrayListSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof LinkedList) {
            linkedListSerializer.serialize(
                obj,
                name,
                callback,
                writer,
                context);
        } else if (obj instanceof HashSet) {
            hashSetSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof TreeSet) {
            treeSetSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof Set) {
            hashSetSerializer.serialize(obj, name, callback, writer, context);
        } else if (obj instanceof List || obj instanceof Collection) {
            arrayListSerializer.serialize(obj, name, callback, writer, context);
        } else {
            throw new SerializationException(
                "soap.cannot.serialize.type",
                obj.getClass().getName());
        }
    }
}
