
package com.sun.xml.rpc.plugins;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class SecMessages {

    private final static String BUNDLE_NAME = "com.sun.xml.rpc.plugins.sec";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new SecMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableSEC_DUPLICATE_OPTION(Object arg0) {
        return MESSAGE_FACTORY.getMessage("sec.duplicateOption", arg0);
    }

    /**
     * duplicate option: {0}
     * 
     */
    public static String SEC_DUPLICATE_OPTION(Object arg0) {
        return LOCALIZER.localize(localizableSEC_DUPLICATE_OPTION(arg0));
    }

    public static Localizable localizableSEC_USAGE_OPTIONS() {
        return MESSAGE_FACTORY.getMessage("sec.usage.options");
    }

    /**
     *   -security &lt;file&gt;          Security configuration file 
     * 
     */
    public static String SEC_USAGE_OPTIONS() {
        return LOCALIZER.localize(localizableSEC_USAGE_OPTIONS());
    }

    public static Localizable localizableSEC_MISSING_OPTION_ARGUMENT(Object arg0) {
        return MESSAGE_FACTORY.getMessage("sec.missingOptionArgument", arg0);
    }

    /**
     * option "{0}" requires an argument
     * 
     */
    public static String SEC_MISSING_OPTION_ARGUMENT(Object arg0) {
        return LOCALIZER.localize(localizableSEC_MISSING_OPTION_ARGUMENT(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
