/*
 * Copyright (c) 2012, 2019 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.xml.ws.api.message;

import javax.xml.ws.WebServiceFeature;

/**
 * Suppresses automatic generation of WS-Addressing headers in request messages.  Use this in cases
 * where required headers will be generated by other means.
 * 
 * @since 2.2.6
 */
public class SuppressAutomaticWSARequestHeadersFeature extends
		WebServiceFeature {

	public SuppressAutomaticWSARequestHeadersFeature() {
		enabled = true;
	}
	
	@Override
	public String getID() {
		return SuppressAutomaticWSARequestHeadersFeature.class.toString();
	}

}
