/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public class FaultExceptionBuilderGenerator
extends GeneratorBase {
    private Set operations;
    private Port port;

    public FaultExceptionBuilderGenerator() {
    }

    @Override
    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new FaultExceptionBuilderGenerator(model, config, properties);
    }

    @Override
    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new FaultExceptionBuilderGenerator(model, config, properties);
    }

    private FaultExceptionBuilderGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    @Override
    public void preVisitModel(Model model) {
        this.operations = new HashSet();
    }

    @Override
    public void postVisitModel(Model model) {
        this.operations = null;
    }

    @Override
    protected void preVisitPort(Port port) throws Exception {
        super.preVisitPort(port);
        this.port = port;
    }

    @Override
    protected void postVisitPort(Port port) throws Exception {
        this.port = null;
        super.postVisitPort(port);
    }

    @Override
    public void preVisitOperation(Operation operation) throws Exception {
        if (!this.isRegistered(operation)) {
            this.registerFault(operation);
        }
    }

    private boolean isRegistered(Operation operation) {
        return this.operations.contains(this.getInputMessageName(operation));
    }

    private String getInputMessageName(Operation operation) {
        QName value = (QName)operation.getRequest().getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (value != null) {
            return value.getLocalPart();
        }
        return operation.getName().getLocalPart();
    }

    private void registerFault(Operation operation) throws Exception {
        this.operations.add(this.getInputMessageName(operation));
        this.generateBuilderForOperation(operation);
    }

    private void generateBuilderForOperation(Operation operation) throws IOException, GeneratorException {
        if (FaultExceptionBuilderGenerator.needsBuilder(operation)) {
            this.writeBuilderForOperation(operation);
        }
    }

    public static boolean needsBuilder(Operation operation) {
        Iterator faults = operation.getFaults();
        return faults != null ? faults.hasNext() : false;
    }

    private void writeBuilderForOperation(Operation operation) throws IOException, GeneratorException {
        String className = this.env.getNames().faultBuilderClassName(this.servicePackage, this.port, operation);
        if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
            this.log("Class " + className + " exists. Not overriding.");
            return;
        }
        File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
        try {
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("FaultExceptionBuilder");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writeObjectBuilderCode(out, operation, className);
            out.close();
        }
        catch (IOException e) {
            FaultExceptionBuilderGenerator.fail("generator.cant.write", classFile.toString());
        }
    }

    private void writeObjectBuilderCode(IndentingWriter p, Operation operation, String className) throws IOException, GeneratorException {
        this.log("writing object builder for: " + operation.getName());
        this.writePackage(p, className);
        this.writeImports(p);
        p.pln();
        this.writeObjectClassDecl(p, className);
        this.writeMembers(p, operation);
        p.pln();
        this.writeMemberGateTypeMethod(p);
        p.pln();
        this.writeConstructMethod(p);
        p.pln();
        this.writeSetMemberMethod(p, operation);
        p.pln();
        this.writeInitializeMethod(p, operation);
        p.pln();
        this.writeGetSetInstanceMethods(p);
        p.pOln("}");
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.soap.message.SOAPFaultInfo;");
        p.pln("import java.lang.IllegalArgumentException;");
    }

    private void writeObjectClassDecl(IndentingWriter p, String className) throws IOException {
        p.plnI("public final class " + Names.stripQualifier(className) + " implements com.sun.xml.rpc.encoding.SOAPInstanceBuilder {");
    }

    private void writeMembers(IndentingWriter p, Operation operation) throws IOException {
        p.pln("private SOAPFaultInfo instance = null;");
        p.pln("private java.lang.Object detail;");
        p.pln("// this is the index of the fault deserialized");
        p.pln("private int index = -1;");
        Iterator faults = operation.getFaults();
        int i = 0;
        while (faults.hasNext()) {
            Fault fault = (Fault)faults.next();
            p.pln("private static final int " + fault.getJavaException().getName().toUpperCase().replace('.', '_') + "_INDEX = " + i + ";");
            ++i;
        }
    }

    private void writeMemberGateTypeMethod(IndentingWriter p) throws IOException {
        p.plnI("public int memberGateType(int memberIndex) {");
        p.pln("return GATES_INITIALIZATION + REQUIRES_COMPLETION;");
        p.pOln("}");
    }

    private void writeConstructMethod(IndentingWriter p) throws IOException {
        p.plnI("public void construct() {");
        p.pOln("}");
    }

    private void writeSetMemberMethod(IndentingWriter p, Operation operation) throws IOException {
        p.plnI("public void setMember(int index, java.lang.Object memberValue) {");
        p.pln("this.index = index;");
        p.pln("detail = memberValue;");
        p.pOln("}");
    }

    private void writeInitializeMethod(IndentingWriter p, Operation operation) throws IOException {
        p.plnI("public void initialize() {");
        p.plnI("switch (index) {");
        Iterator faults = operation.getFaults();
        boolean i = false;
        while (faults.hasNext()) {
            Fault fault = (Fault)faults.next();
            JavaException javaException = fault.getJavaException();
            p.plnI("case " + fault.getJavaException().getName().toUpperCase().replace('.', '_') + "_INDEX:");
            p.pln("instance.setDetail(detail);");
            p.pln("break;");
            p.pO();
        }
        p.pOln("}");
        p.pOln("}");
    }

    private void writeGetSetInstanceMethods(IndentingWriter p) throws IOException {
        p.plnI("public void setInstance(java.lang.Object instance) {");
        p.pln("this.instance = (SOAPFaultInfo)instance;");
        p.pOln("}");
        p.pln();
        p.plnI("public java.lang.Object getInstance() {");
        p.pln("return instance;");
        p.pOln("}");
    }
}

