
package com.sun.xml.wss.logging.impl.policy;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LogStringsMessages {

    private final static String BUNDLE_NAME = "com.sun.xml.wss.logging.impl.policy.LogStrings";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LogStringsMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
