/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.xml.ws.resources;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class ManagementMessages {

    private final static String BUNDLE_NAME = "com.sun.xml.ws.resources.management";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new ManagementMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableWSM_1008_EXPECTED_INTEGER_DISPOSE_DELAY_VALUE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("WSM_1008_EXPECTED_INTEGER_DISPOSE_DELAY_VALUE", arg0);
    }

    /**
     * WSM1008: Expected an integer as value of the endpointDisposeDelay attribute, got this instead: "{0}".
     * 
     */
    public static String WSM_1008_EXPECTED_INTEGER_DISPOSE_DELAY_VALUE(Object arg0) {
        return LOCALIZER.localize(localizableWSM_1008_EXPECTED_INTEGER_DISPOSE_DELAY_VALUE(arg0));
    }

    public static Localizable localizableWSM_1003_MANAGEMENT_ASSERTION_MISSING_ID(Object arg0) {
        return MESSAGE_FACTORY.getMessage("WSM_1003_MANAGEMENT_ASSERTION_MISSING_ID", arg0);
    }

    /**
     * WSM1003: Policy assertion {0} must have id attribute when management is enabled.
     * 
     */
    public static String WSM_1003_MANAGEMENT_ASSERTION_MISSING_ID(Object arg0) {
        return LOCALIZER.localize(localizableWSM_1003_MANAGEMENT_ASSERTION_MISSING_ID(arg0));
    }

    public static Localizable localizableWSM_1005_EXPECTED_COMMUNICATION_CHILD() {
        return MESSAGE_FACTORY.getMessage("WSM_1005_EXPECTED_COMMUNICATION_CHILD");
    }

    /**
     * WSM1005: Expected to find a CommunicationServerImplementation tag as child node of CommunicationServerImplementations.
     * 
     */
    public static String WSM_1005_EXPECTED_COMMUNICATION_CHILD() {
        return LOCALIZER.localize(localizableWSM_1005_EXPECTED_COMMUNICATION_CHILD());
    }

    public static Localizable localizableWSM_1006_CLIENT_MANAGEMENT_ENABLED() {
        return MESSAGE_FACTORY.getMessage("WSM_1006_CLIENT_MANAGEMENT_ENABLED");
    }

    /**
     * WSM1006: The management property of the ManagedClient policy assertion is set to on. Clients cannot be managed and this setting will be ignored.
     * 
     */
    public static String WSM_1006_CLIENT_MANAGEMENT_ENABLED() {
        return LOCALIZER.localize(localizableWSM_1006_CLIENT_MANAGEMENT_ENABLED());
    }

    public static Localizable localizableWSM_1002_EXPECTED_MANAGEMENT_ASSERTION(Object arg0) {
        return MESSAGE_FACTORY.getMessage("WSM_1002_EXPECTED_MANAGEMENT_ASSERTION", arg0);
    }

    /**
     * WSM1002: Expected policy assertion {0} in this namespace.
     * 
     */
    public static String WSM_1002_EXPECTED_MANAGEMENT_ASSERTION(Object arg0) {
        return LOCALIZER.localize(localizableWSM_1002_EXPECTED_MANAGEMENT_ASSERTION(arg0));
    }

    public static Localizable localizableWSM_1001_FAILED_ASSERTION(Object arg0) {
        return MESSAGE_FACTORY.getMessage("WSM_1001_FAILED_ASSERTION", arg0);
    }

    /**
     * WSM1001: Failed to get policy assertion {0}.
     * 
     */
    public static String WSM_1001_FAILED_ASSERTION(Object arg0) {
        return LOCALIZER.localize(localizableWSM_1001_FAILED_ASSERTION(arg0));
    }

    public static Localizable localizableWSM_1007_FAILED_MODEL_TRANSLATOR_INSTANTIATION() {
        return MESSAGE_FACTORY.getMessage("WSM_1007_FAILED_MODEL_TRANSLATOR_INSTANTIATION");
    }

    /**
     * WSM1007: Failed to create a ModelTranslator instance.
     * 
     */
    public static String WSM_1007_FAILED_MODEL_TRANSLATOR_INSTANTIATION() {
        return LOCALIZER.localize(localizableWSM_1007_FAILED_MODEL_TRANSLATOR_INSTANTIATION());
    }

    public static Localizable localizableWSM_1004_EXPECTED_XML_TAG(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("WSM_1004_EXPECTED_XML_TAG", arg0, arg1);
    }

    /**
     * WSM1004: Expected tag &lt;{0}&gt; but instead read &lt;{1}&gt;.
     * 
     */
    public static String WSM_1004_EXPECTED_XML_TAG(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableWSM_1004_EXPECTED_XML_TAG(arg0, arg1));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
