/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.framework;

import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wsdl.framework.Entity;
import com.sun.tools.ws.wsdl.framework.EntityAction;
import com.sun.tools.ws.wsdl.framework.EntityReferenceValidator;
import com.sun.tools.ws.wsdl.framework.GloballyKnown;
import com.sun.tools.ws.wsdl.framework.Kind;
import com.sun.tools.ws.wsdl.framework.ValidationException;
import com.sun.tools.ws.wsdl.parser.DOMForest;
import com.sun.tools.ws.wsdl.parser.MetadataFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class AbstractDocument {
    protected final DOMForest forest;
    protected final ErrorReceiver errReceiver;
    private final Map kinds;
    private String _systemId;
    private final Set importedDocuments;
    private final List importedEntities;
    private final Set includedDocuments;
    private final List includedEntities;

    protected AbstractDocument(MetadataFinder forest, ErrorReceiver errReceiver) {
        this.forest = forest;
        this.errReceiver = errReceiver;
        this.kinds = new HashMap();
        this.importedEntities = new ArrayList();
        this.importedDocuments = new HashSet();
        this.includedEntities = new ArrayList();
        this.includedDocuments = new HashSet();
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setSystemId(String s) {
        if (this._systemId != null && !this._systemId.equals(s)) {
            throw new IllegalArgumentException();
        }
        this._systemId = s;
        if (s != null) {
            this.importedDocuments.add(s);
        }
    }

    public void addIncludedDocument(String systemId) {
        this.includedDocuments.add(systemId);
    }

    public boolean isIncludedDocument(String systemId) {
        return this.includedDocuments.contains(systemId);
    }

    public void addIncludedEntity(Entity entity) {
        this.includedEntities.add(entity);
    }

    public void addImportedDocument(String systemId) {
        this.importedDocuments.add(systemId);
    }

    public boolean isImportedDocument(String systemId) {
        return this.importedDocuments.contains(systemId);
    }

    public void addImportedEntity(Entity entity) {
        this.importedEntities.add(entity);
    }

    public void withAllSubEntitiesDo(EntityAction action) {
        if (this.getRoot() != null) {
            action.perform(this.getRoot());
        }
        Iterator iter = this.importedEntities.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        iter = this.includedEntities.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
    }

    public Map getMap(Kind k) {
        HashMap m = (HashMap)this.kinds.get(k.getName());
        if (m == null) {
            m = new HashMap();
            this.kinds.put(k.getName(), m);
        }
        return m;
    }

    public void define(GloballyKnown e) {
        Map map = this.getMap(e.getKind());
        if (e.getName() == null) {
            return;
        }
        QName name = new QName(e.getDefining().getTargetNamespaceURI(), e.getName());
        if (map.containsKey(name)) {
            this.errReceiver.error(e.getLocator(), WsdlMessages.ENTITY_DUPLICATE_WITH_TYPE(e.getElementName().getLocalPart(), e.getName()));
            throw new AbortException();
        }
        map.put(name, e);
    }

    public GloballyKnown find(Kind k, QName name) {
        Map map = this.getMap(k);
        Object result = map.get(name);
        if (result == null) {
            this.errReceiver.error(null, WsdlMessages.ENTITY_NOT_FOUND_BY_Q_NAME(k.getName(), name, this._systemId));
            throw new AbortException();
        }
        return (GloballyKnown)result;
    }

    public void validateLocally() {
        LocallyValidatingAction action = new LocallyValidatingAction();
        this.withAllSubEntitiesDo(action);
        if (action.getException() != null) {
            throw action.getException();
        }
    }

    public abstract void validate(EntityReferenceValidator var1);

    protected abstract Entity getRoot();

    private static class LocallyValidatingAction
    implements EntityAction {
        private ValidationException _exception;

        @Override
        public void perform(Entity entity) {
            block2: {
                try {
                    entity.validateThis();
                    entity.withAllSubEntitiesDo(this);
                }
                catch (ValidationException e) {
                    if (this._exception != null) break block2;
                    this._exception = e;
                }
            }
        }

        public ValidationException getException() {
            return this._exception;
        }
    }
}

