/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.util;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.util.TCPSettings;
import jakarta.xml.ws.soap.MTOMFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class BindingUtils {
    private static List<String> SOAP11_PARAMS;
    private static List<String> SOAP12_PARAMS;
    private static List<String> MTOM11_PARAMS;
    private static List<String> MTOM12_PARAMS;
    private static NegotiatedBindingContent SOAP11_BINDING_CONTENT;
    private static NegotiatedBindingContent SOAP12_BINDING_CONTENT;
    private static NegotiatedBindingContent MTOM11_BINDING_CONTENT;
    private static NegotiatedBindingContent MTOM12_BINDING_CONTENT;

    private static void initiate() {
        SOAP11_PARAMS = Arrays.asList("charset", "SOAPAction");
        SOAP12_PARAMS = Arrays.asList("charset", "action");
        MTOM11_PARAMS = new ArrayList<String>(SOAP11_PARAMS);
        MTOM11_PARAMS.add("boundary");
        MTOM11_PARAMS.add("start-info");
        MTOM11_PARAMS.add("type");
        MTOM12_PARAMS = new ArrayList<String>(SOAP12_PARAMS);
        MTOM12_PARAMS.add("boundary");
        MTOM12_PARAMS.add("start-info");
        MTOM12_PARAMS.add("type");
        SOAP11_BINDING_CONTENT = new NegotiatedBindingContent(new ArrayList<String>(1), SOAP11_PARAMS);
        SOAP12_BINDING_CONTENT = new NegotiatedBindingContent(new ArrayList<String>(1), SOAP12_PARAMS);
        MTOM11_BINDING_CONTENT = new NegotiatedBindingContent(new ArrayList<String>(2), MTOM11_PARAMS);
        MTOM12_BINDING_CONTENT = new NegotiatedBindingContent(new ArrayList<String>(2), MTOM12_PARAMS);
        if (TCPSettings.getInstance().getEncodingMode() == TCPSettings.EncodingMode.FI_STATEFUL) {
            BindingUtils.SOAP11_BINDING_CONTENT.negotiatedMimeTypes.add("application/vnd.sun.stateful.fastinfoset");
            BindingUtils.SOAP12_BINDING_CONTENT.negotiatedMimeTypes.add("application/vnd.sun.stateful.soap+fastinfoset");
        }
        if (TCPSettings.getInstance().getEncodingMode() == TCPSettings.EncodingMode.FI_STATELESS) {
            BindingUtils.SOAP11_BINDING_CONTENT.negotiatedMimeTypes.add("application/fastinfoset");
            BindingUtils.SOAP12_BINDING_CONTENT.negotiatedMimeTypes.add("application/soap+fastinfoset");
        }
        BindingUtils.SOAP11_BINDING_CONTENT.negotiatedMimeTypes.add("text/xml");
        BindingUtils.SOAP12_BINDING_CONTENT.negotiatedMimeTypes.add("application/soap+xml");
        BindingUtils.MTOM11_BINDING_CONTENT.negotiatedMimeTypes.addAll(BindingUtils.SOAP11_BINDING_CONTENT.negotiatedMimeTypes);
        BindingUtils.MTOM11_BINDING_CONTENT.negotiatedMimeTypes.add("multipart/related");
        BindingUtils.MTOM12_BINDING_CONTENT.negotiatedMimeTypes.addAll(BindingUtils.SOAP12_BINDING_CONTENT.negotiatedMimeTypes);
        BindingUtils.MTOM12_BINDING_CONTENT.negotiatedMimeTypes.add("multipart/related");
    }

    public static NegotiatedBindingContent getNegotiatedContentTypesAndParams(WSBinding binding) {
        if (binding.getSOAPVersion().equals((Object)SOAPVersion.SOAP_11)) {
            if (BindingUtils.isMTOMEnabled(binding)) {
                return MTOM11_BINDING_CONTENT;
            }
            return SOAP11_BINDING_CONTENT;
        }
        if (binding.getSOAPVersion().equals((Object)SOAPVersion.SOAP_12)) {
            if (BindingUtils.isMTOMEnabled(binding)) {
                return MTOM12_BINDING_CONTENT;
            }
            return SOAP12_BINDING_CONTENT;
        }
        throw new AssertionError((Object)MessagesMessages.WSTCP_0009_UNKNOWN_BINDING(binding));
    }

    private static boolean isMTOMEnabled(WSBinding binding) {
        return binding.isFeatureEnabled(MTOMFeature.class);
    }

    static {
        BindingUtils.initiate();
    }

    public static final class NegotiatedBindingContent {
        public final List<String> negotiatedMimeTypes;
        public final List<String> negotiatedParams;

        public NegotiatedBindingContent(List<String> negotiatedMimeTypes, List<String> negotiatedParams) {
            this.negotiatedMimeTypes = negotiatedMimeTypes;
            this.negotiatedParams = negotiatedParams;
        }
    }
}

