/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.handler.MessageContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class SubjectAccessor {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private static ThreadLocal<Subject> wssThreadCtx = new ThreadLocal();

    public static Subject getRequesterSubject(Object context) throws XWSSecurityException {
        if (context instanceof ProcessingContext) {
            return (Subject)((ProcessingContext)context).getExtraneousProperty("javax.security.auth.Subject");
        }
        if (context instanceof MessageContext) {
            MessageContext msgContext = (MessageContext)context;
            Subject subject = (Subject)msgContext.get((Object)"javax.security.auth.Subject");
            return subject;
        }
        if (context instanceof WebServiceContext) {
            try {
                WebServiceContext wsCtx = (WebServiceContext)context;
                MessageContext msgContext = wsCtx.getMessageContext();
                if (msgContext != null) {
                    Subject subject = (Subject)msgContext.get((Object)"javax.security.auth.Subject");
                    return subject;
                }
                return null;
            }
            catch (NoClassDefFoundError ncde) {
                log.log(Level.SEVERE, "WSS0761.context.not.instanceof.servletendpointcontext", ncde);
                throw new XWSSecurityException(ncde);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "WSS0761.context.not.instanceof.servletendpointcontext", ex);
                throw new XWSSecurityException(ex);
            }
        }
        return null;
    }

    public static Subject getRequesterSubject() {
        return wssThreadCtx.get();
    }

    public static void setRequesterSubject(Subject sub) {
        wssThreadCtx.set(sub);
    }
}

