/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.Header;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SignedParts
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.SignedParts,
SecurityAssertionValidator {
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean body;
    private boolean attachments;
    private String attachmentProtectionType = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform";
    private boolean populated = false;
    private Set<PolicyAssertion> targets = new HashSet<PolicyAssertion>();
    private SecurityPolicyVersion spVersion;

    public SignedParts() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    }

    public SignedParts(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    public void addBody() {
    }

    @Override
    public boolean hasBody() {
        this.populate();
        return this.body;
    }

    @Override
    public boolean hasAttachments() {
        this.populate();
        return this.attachments;
    }

    @Override
    public String attachmentProtectionType() {
        this.populate();
        return this.attachmentProtectionType;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            if (this.hasNestedAssertions()) {
                Iterator<PolicyAssertion> it = this.getNestedAssertionsIterator();
                while (it.hasNext()) {
                    PolicyAssertion as = it.next();
                    if (PolicyUtil.isBody(as, this.spVersion)) {
                        this.body = true;
                        continue;
                    }
                    if (PolicyUtil.isAttachments(as, this.spVersion)) {
                        this.attachments = true;
                        if (!as.hasParameters()) continue;
                        Iterator<PolicyAssertion> attachIter = as.getParametersIterator();
                        while (attachIter.hasNext()) {
                            PolicyAssertion attachType = attachIter.next();
                            if (PolicyUtil.isAttachmentCompleteTransform(attachType, this.spVersion)) {
                                this.attachmentProtectionType = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform";
                                continue;
                            }
                            if (!PolicyUtil.isAttachmentContentTransform(attachType, this.spVersion)) continue;
                            this.attachmentProtectionType = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform";
                        }
                        continue;
                    }
                    this.targets.add(as);
                }
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public void addHeader(Header header) {
    }

    @Override
    public Iterator getHeaders() {
        this.populate();
        if (this.targets == null) {
            return Collections.emptyList().iterator();
        }
        return this.targets.iterator();
    }
}

