/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.xml.security.core.dsig.TransformsType;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferProcessor;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.encoding.TagInfoset;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.crypto.dsig.CanonicalizationMethod;
import com.sun.xml.ws.security.opt.crypto.dsig.DigestMethod;
import com.sun.xml.ws.security.opt.crypto.dsig.Reference;
import com.sun.xml.ws.security.opt.crypto.dsig.SignatureMethod;
import com.sun.xml.ws.security.opt.crypto.dsig.SignedInfo;
import com.sun.xml.ws.security.opt.crypto.dsig.Transform;
import com.sun.xml.ws.security.opt.crypto.dsig.Transforms;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBSignatureFactory;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBStructure;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBValidateContext;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.dsig.ExcC14NParameterSpec;
import com.sun.xml.ws.security.opt.impl.incoming.GenericSecuredHeader;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContext;
import com.sun.xml.ws.security.opt.impl.incoming.URIResolver;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.ws.security.secext10.TransformationParametersType;
import com.sun.xml.wss.BasicSecurityProfile;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.impl.dsig.SignatureProcessor;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.UnsyncByteArrayOutputStream;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;

public class SignedInfoProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");
    public static final int CANONICALIZATION_METHOD_EVENT = 1;
    public static final int SIGNATURE_METHOD_EVENT = 2;
    public static final int REFERENCE_EVENT = 3;
    public static final int DIGEST_METHOD_EVENT = 4;
    public static final int DIGEST_VALUE_EVENT = 5;
    public static final int TRANSFORM_EVENT = 6;
    public static final int TRANSFORMS_EVENT = 7;
    StAXEXC14nCanonicalizerImpl exc14nFinal = null;
    public static final String CANONICALIZATION_METHOD = "CanonicalizationMethod";
    public static final String SIGNATURE_METHOD = "SignatureMethod";
    public static final String REFERENCE = "Reference";
    public static final String INCLUSIVENAMESPACES = "InclusiveNamespaces";
    public static final String EXC14N_NS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String TRANSFORMS = "Transforms";
    public static final String TRANSFORM = "Transform";
    public static final String DIGEST_METHOD = "DigestMethod";
    public static final String DIGEST_VALUE = "DigestValue";
    private String canonAlgo = "";
    private TagInfoset signatureRoot = null;
    private String signatureMethod = "";
    private HashMap<String, String> currentNSDecls = new HashMap();
    private UnsyncByteArrayOutputStream canonInfo = new UnsyncByteArrayOutputStream();
    private XMLStreamReader reader = null;
    private SecurityContext securityContext = null;
    private ArrayList<Reference> refList = null;
    private URIResolver resolver = null;
    private SignaturePolicy.FeatureBinding fb = null;
    private JAXBFilterProcessingContext pc = null;
    private JAXBSignatureFactory signatureFactory = null;
    MutableXMLStreamBuffer siBuffer = null;

    public SignedInfoProcessor(TagInfoset signature, HashMap<String, String> parentNSDecls, XMLStreamReader reader, JAXBFilterProcessingContext pc, SignaturePolicy signPolicy, MutableXMLStreamBuffer buffer) {
        this.signatureRoot = signature;
        this.siBuffer = buffer;
        this.currentNSDecls.putAll(parentNSDecls);
        this.reader = reader;
        this.pc = pc;
        this.securityContext = pc.getSecurityContext();
        this.resolver = new URIResolver(pc);
        this.signatureFactory = JAXBSignatureFactory.newInstance();
        this.fb = (SignaturePolicy.FeatureBinding)signPolicy.getFeatureBinding();
    }

    public XMLStreamWriter getCanonicalizer() {
        return this.exc14nFinal;
    }

    public SignedInfo process() throws XWSSecurityException {
        try {
            for (int i = 0; i < this.reader.getNamespaceCount(); ++i) {
                this.currentNSDecls.put(this.reader.getNamespacePrefix(i), this.reader.getNamespaceURI(i));
            }
            boolean referencesFound = false;
            if (StreamUtil.moveToNextElement(this.reader)) {
                int refElement = this.getEventType(this.reader);
                while (true) {
                    if (this.reader.getEventType() == 8) break;
                    switch (refElement) {
                        case 1: {
                            this.readCanonicalizationMethod(this.reader);
                            this.fb.setCanonicalizationAlgorithm(this.canonAlgo);
                            break;
                        }
                        case 2: {
                            this.signatureMethod = this.reader.getAttributeValue(null, "Algorithm");
                            break;
                        }
                        case 3: {
                            referencesFound = true;
                            this.processReferences(this.reader);
                            break;
                        }
                    }
                    if (StreamUtil._break(this.reader, "SignedInfo", "http://www.w3.org/2000/09/xmldsig#")) {
                        if (!this.reader.hasNext()) break;
                        this.reader.next();
                        break;
                    }
                    if (this.reader.getEventType() == 8) break;
                    this.reader.next();
                    if (StreamUtil._break(this.reader, "SignedInfo", "http://www.w3.org/2000/09/xmldsig#")) {
                        if (!this.reader.hasNext()) break;
                        this.reader.next();
                        break;
                    }
                    refElement = this.getEventType(this.reader);
                }
            }
            if (!referencesFound) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1725_REFERENCE_ELEMENT_NOTFOUND());
                throw new XWSSecurityException(LogStringsMessages.WSS_1725_REFERENCE_ELEMENT_NOTFOUND());
            }
            SignedInfo si = new SignedInfo();
            SignatureMethod sm = new SignatureMethod();
            sm.setAlgorithm(this.signatureMethod);
            si.setSignatureMethod(sm);
            si.setReference(this.getReferenceList());
            StreamReaderBufferProcessor siReader = this.siBuffer.readAsXMLStreamReader();
            while (siReader.hasNext()) {
                if (siReader.getEventType() == 1 && siReader.getLocalName() == "SignedInfo".intern()) break;
                siReader.next();
            }
            int counter = 1;
            while (siReader.hasNext()) {
                StreamUtil.writeCurrentEvent((XMLStreamReader)((Object)siReader), this.exc14nFinal);
                if (counter == 0) break;
                siReader.next();
                if (siReader.getEventType() == 2) {
                    --counter;
                    continue;
                }
                if (siReader.getEventType() != 1) continue;
                ++counter;
            }
            si.setCanonicalizedSI(this.canonInfo.toByteArray());
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Canonicalized Signed Info:" + new String(this.canonInfo.toByteArray()));
            }
            return si;
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1711_ERROR_VERIFYING_SIGNATURE(), ex);
            throw new XWSSecurityException(LogStringsMessages.WSS_1711_ERROR_VERIFYING_SIGNATURE(), ex);
        }
    }

    public void readCanonicalizationMethod(XMLStreamReader reader) throws XWSSecurityException {
        try {
            this.canonAlgo = reader.getAttributeValue(null, "Algorithm");
            if (this.canonAlgo != null && this.canonAlgo.length() == 0) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1718_MISSING_CANON_ALGORITHM());
                throw new XWSSecurityException(LogStringsMessages.WSS_1718_MISSING_CANON_ALGORITHM());
            }
            SignatureProcessor.verifyCanonicalizationMethodAlgorithm(this.canonAlgo);
            String[] prefixList = null;
            if (reader.hasNext()) {
                String pl;
                reader.next();
                if (reader.getEventType() == 1 && reader.getLocalName() == INCLUSIVENAMESPACES && reader.getNamespaceURI() == EXC14N_NS && (pl = reader.getAttributeValue(null, "PrefixList")) != null && pl.length() > 0) {
                    prefixList = pl.split(" ");
                }
            }
            if (EXC14N_NS.equals(this.canonAlgo)) {
                this.exc14nFinal = new StAXEXC14nCanonicalizerImpl();
                if (prefixList != null && prefixList.length > 0) {
                    ArrayList<String> al = new ArrayList<String>(prefixList.length);
                    for (int i = 0; i < prefixList.length; ++i) {
                        al.add(prefixList[i]);
                    }
                    this.exc14nFinal.setInclusivePrefixList(al);
                }
                Iterator<String> itr = this.currentNSDecls.keySet().iterator();
                this.exc14nFinal.setStream(this.canonInfo);
                while (itr.hasNext()) {
                    String prefix = itr.next();
                    String uri = this.currentNSDecls.get(prefix);
                    this.exc14nFinal.writeNamespace(prefix, uri);
                }
            }
        }
        catch (XMLStreamException xse) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1711_ERROR_VERIFYING_SIGNATURE(), xse);
            throw new XWSSecurityException(LogStringsMessages.WSS_1711_ERROR_VERIFYING_SIGNATURE(), xse);
        }
    }

    private void processReferences(XMLStreamReader reader) throws XWSSecurityException {
        try {
            String dm = "";
            String uri = reader.getAttributeValue(null, "URI");
            String digestValue = "";
            Base64Data bd = null;
            ArrayList tList = null;
            while (reader.hasNext() && !StreamUtil._break(reader, REFERENCE, "http://www.w3.org/2000/09/xmldsig#")) {
                reader.next();
                int referenceEvent = this.getReferenceEventType(reader);
                switch (referenceEvent) {
                    case 7: {
                        tList = this.processTransforms(reader, uri);
                        break;
                    }
                    case 4: {
                        dm = reader.getAttributeValue(null, "Algorithm");
                        break;
                    }
                    case 5: {
                        if (reader instanceof XMLStreamReaderEx) {
                            reader.next();
                            CharSequence charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                            String dv = null;
                            if (charSeq instanceof Base64Data) {
                                bd = (Base64Data)charSeq;
                                dv = Base64.encode(bd.getExact());
                            } else {
                                dv = StreamUtil.getCV(reader);
                            }
                            digestValue = dv;
                            break;
                        }
                        digestValue = StreamUtil.getCV(reader);
                        break;
                    }
                }
            }
            Reference rt = new Reference();
            DigestMethod digestMethod = new DigestMethod();
            digestMethod.setAlgorithm(dm);
            rt.setDigestMethod(digestMethod);
            if (bd != null) {
                rt.setDigestValue(bd.getExact());
            } else {
                try {
                    rt.setDigestValue(Base64.decode(digestValue));
                }
                catch (Base64DecodingException dec) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1719_ERROR_DIGESTVAL_REFERENCE(uri), dec);
                    throw new XWSSecurityException(LogStringsMessages.WSS_1719_ERROR_DIGESTVAL_REFERENCE(uri));
                }
            }
            rt.setURI(uri);
            Transforms transforms = new Transforms();
            ((TransformsType)transforms).setTransform(tList);
            rt.setTransforms(transforms);
            Target target = new Target("uri", uri);
            SignatureTarget signTarget = new SignatureTarget(target);
            signTarget.setDigestAlgorithm(dm);
            for (int i = 0; tList != null && i < tList.size(); ++i) {
                Transform tr = (Transform)tList.get(i);
                SignatureTarget.Transform sTr = new SignatureTarget.Transform(tr.getAlgorithm());
                signTarget.addTransform(sTr);
            }
            this.fb.addTargetBinding(signTarget);
            if (!this.processReference(rt)) {
                ArrayList<Reference> refCache = this.getReferenceList();
                refCache.add(rt);
            }
        }
        catch (XMLStreamException xe) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1711_ERROR_VERIFYING_SIGNATURE(), xe);
            throw new XWSSecurityException(LogStringsMessages.WSS_1711_ERROR_VERIFYING_SIGNATURE(), xe);
        }
    }

    public boolean processReference(Reference reference) throws XWSSecurityException {
        final String uri = reference.getURI();
        URIReference ref = new URIReference(){

            @Override
            public String getType() {
                return "";
            }

            @Override
            public String getURI() {
                return uri;
            }
        };
        Data data = null;
        try {
            data = this.resolver.dereference(ref, null);
        }
        catch (URIReferenceException ure) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1720_ERROR_URI_DEREF(uri), ure);
            throw new XWSSecurityException(LogStringsMessages.WSS_1720_ERROR_URI_DEREF(uri), ure);
        }
        if (data != null) {
            JAXBValidateContext jvc = new JAXBValidateContext();
            jvc.setURIDereferencer(this.resolver);
            jvc.put("http://wss.sun.com#processingContext", this.pc);
            try {
                if (!reference.validate(jvc)) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1721_REFERENCE_VALIDATION_FAILED(uri));
                    throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1721_REFERENCE_VALIDATION_FAILED(uri), null);
                }
                return true;
            }
            catch (XMLSignatureException xse) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1722_ERROR_REFERENCE_VALIDATION(uri), xse);
                throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1722_ERROR_REFERENCE_VALIDATION(uri), xse);
            }
        }
        return false;
    }

    public ArrayList<Reference> getReferenceList() {
        if (this.refList == null) {
            this.refList = new ArrayList(1);
        }
        return this.refList;
    }

    public int getReferenceEventType(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == TRANSFORMS) {
                return 7;
            }
            if (reader.getLocalName() == DIGEST_METHOD) {
                return 4;
            }
            if (reader.getLocalName() == DIGEST_VALUE) {
                return 5;
            }
        }
        return -1;
    }

    private int getEventType(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == CANONICALIZATION_METHOD) {
                return 1;
            }
            if (reader.getLocalName() == SIGNATURE_METHOD) {
                return 2;
            }
            if (reader.getLocalName() == REFERENCE) {
                return 3;
            }
        }
        return -1;
    }

    private ArrayList processTransforms(XMLStreamReader reader, String uri) throws XWSSecurityException {
        try {
            ArrayList<Transform> trList = new ArrayList<Transform>(1);
            while (reader.hasNext()) {
                if (StreamUtil.isStartElement(reader) && reader.getLocalName() == TRANSFORM) {
                    trList.add(this.processTransform(reader, uri));
                }
                reader.next();
                if (!StreamUtil._break(reader, TRANSFORMS, "http://www.w3.org/2000/09/xmldsig#")) continue;
            }
            return trList;
        }
        catch (XMLStreamException xse) {
            throw new XWSSecurityException(xse);
        }
    }

    private Transform processTransform(XMLStreamReader reader, String uri) throws XWSSecurityException {
        try {
            ExcC14NParameterSpec exc14nSpec = null;
            String value = reader.getAttributeValue(null, "Algorithm");
            if (EXC14N_NS.equals(value)) {
                exc14nSpec = this.readEXC14nTransform(reader);
                return (Transform)this.signatureFactory.newTransform(value, exc14nSpec);
            }
            if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(value)) {
                if (this.pc.isBSP()) {
                    BasicSecurityProfile.log_bsp_3104();
                }
                return (Transform)this.signatureFactory.newTransform(value, exc14nSpec);
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(value)) {
                StreamUtil.moveToNextStartOREndElement(reader);
                if (reader.getLocalName() == "TransformationParameters") {
                    Transform tr = (Transform)this.signatureFactory.newTransform(value, this.readSTRTransform(reader));
                    String id = "";
                    int index = uri.indexOf("#");
                    id = index >= 0 ? uri.substring(index + 1) : uri;
                    tr.setReferenceId(id);
                    return tr;
                }
            } else {
                if ("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform".equals(value)) {
                    return (Transform)this.signatureFactory.newTransform(value, exc14nSpec);
                }
                if ("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform".equals(value)) {
                    return (Transform)this.signatureFactory.newTransform(value, exc14nSpec);
                }
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1723_UNSUPPORTED_TRANSFORM_ELEMENT(value));
                SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_ALGORITHM, LogStringsMessages.WSS_1723_UNSUPPORTED_TRANSFORM_ELEMENT(value), null);
            }
            return null;
        }
        catch (Exception xe) {
            throw new XWSSecurityException("Transform error", xe);
        }
    }

    private Object getMessagePart(String id) {
        Object header;
        HeaderList headers = (HeaderList)this.securityContext.getNonSecurityHeaders();
        if (headers != null && headers.size() > 0) {
            ListIterator listItr = headers.listIterator();
            boolean found = false;
            while (listItr.hasNext()) {
                header = (GenericSecuredHeader)listItr.next();
                if (!((GenericSecuredHeader)header).hasID(id)) continue;
                return header;
            }
        }
        ArrayList pshList = this.securityContext.getProcessedSecurityHeaders();
        for (int j = 0; j < pshList.size(); ++j) {
            header = (SecurityHeaderElement)pshList.get(j);
            if (!id.equals(header.getId())) continue;
            return header;
        }
        return null;
    }

    private XMLStructure readSTRTransform(XMLStreamReader reader) throws XWSSecurityException {
        try {
            TransformationParametersType tp = new ObjectFactory().createTransformationParametersType();
            CanonicalizationMethod cm = new CanonicalizationMethod();
            tp.getAny().add(cm);
            JAXBElement<TransformationParametersType> tpElement = new ObjectFactory().createTransformationParameters(tp);
            JAXBStructure transformSpec = new JAXBStructure(tpElement);
            reader.next();
            if (StreamUtil.isStartElement(reader) && reader.getLocalName() == CANONICALIZATION_METHOD) {
                String value = reader.getAttributeValue(null, "Algorithm");
                SignatureProcessor.verifyCanonicalizationMethodAlgorithm(value);
                cm.setAlgorithm(value);
                StreamUtil.moveToNextStartOREndElement(reader);
            }
            return transformSpec;
        }
        catch (Exception ex) {
            throw new XWSSecurityException(ex);
        }
    }

    private ExcC14NParameterSpec readEXC14nTransform(XMLStreamReader reader) throws XMLStreamException {
        String prefixList = "";
        ExcC14NParameterSpec exc14nSpec = null;
        if (reader.hasNext()) {
            reader.next();
            if (StreamUtil.isStartElement(reader) && reader.getLocalName() == INCLUSIVENAMESPACES) {
                prefixList = reader.getAttributeValue(null, "PrefixList");
                String[] pl = null;
                if (prefixList != null && prefixList.length() > 0) {
                    pl = prefixList.split(" ");
                }
                if (pl != null && pl.length > 0) {
                    ArrayList<String> prefixs = new ArrayList<String>();
                    for (int i = 0; i < pl.length; ++i) {
                        prefixs.add(pl[i]);
                    }
                    exc14nSpec = new ExcC14NParameterSpec(prefixs);
                }
                if (reader.hasNext()) {
                    reader.next();
                }
            }
        }
        return exc14nSpec;
    }
}

