/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.filter.TeeFilter;
import com.sun.xml.wss.logging.impl.filter.LogStringsMessages;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DumpFilter {
    private static Level DEFAULT_LOG_LEVEL = Level.INFO;
    private static final String lineSeparator = System.getProperty("line.separator");
    private static Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.filter", "com.sun.xml.wss.logging.impl.filter.LogStrings");

    public static void process(ProcessingContext context) throws XWSSecurityException {
        ByteArrayOutputStream baos = null;
        ByteArrayOutputStream dest = baos = new ByteArrayOutputStream();
        String label = "Sending Message";
        if (context.isInboundMessage()) {
            label = "Received Message";
        }
        String msg1 = "==== " + label + " Start ====" + lineSeparator;
        try {
            TeeFilter teeFilter = new TeeFilter((OutputStream)dest, true);
            teeFilter.process(context.getSOAPMessage());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_1411_UNABLETO_DUMP_SOAPMESSAGE(new Object[]{e.getMessage()}));
            throw new XWSSecurityException("Unable to dump SOAPMessage");
        }
        String msg2 = "==== " + label + " End  ====" + lineSeparator;
        byte[] bytes = baos.toByteArray();
        String logMsg = msg1 + new String(bytes) + msg2;
        log.log(DEFAULT_LOG_LEVEL, logMsg);
    }
}

