
package com.sun.xml.wss.logging.impl.configuration;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LogStringsMessages {

    private final static String BUNDLE_NAME = "com.sun.xml.wss.logging.impl.configuration.LogStrings";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LogStringsMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableWSS_1100_CLASSCAST_TARGET(Object arg0) {
        return MESSAGE_FACTORY.getMessage("WSS1100.classcast.target", arg0);
    }

    /**
     * WS1100: Classcast Exception for Target {0}
     * 
     */
    public static String WSS_1100_CLASSCAST_TARGET(Object arg0) {
        return LOCALIZER.localize(localizableWSS_1100_CLASSCAST_TARGET(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
