/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.logging.impl.opt.LogStringsMessages;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;

public class KeyValueProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt", "com.sun.xml.wss.logging.impl.opt.LogStrings");
    private static final int SECURITY_TOKEN_REFERENCE_ELEMENT = 3;
    private static final int ENCRYPTED_KEY_ELEMENT = 4;
    private static final int KEY_VALUE_ELEMENT = 5;
    private static final int RSA_KEY_VALUE_ELEMENT = 6;
    private static final int DSA_KEY_VALUE_ELEMENT = 7;
    private static final int MODULUS_ELEMENT = 8;
    private static final int EXPONENT_ELEMENT = 9;
    private static final String RSA_KEY_VALUE = "RSAKeyValue";
    private static final String DSA_KEY_VALUE = "DSAKeyValue";
    private static final String ENCRYPTED_KEY = "EncryptedKey";
    private static final String KEY_VALUE = "KeyValue";
    private static final String EXPONENT = "Exponent";
    private static final String MODULUS = "Modulus";
    private XMLStreamWriter canonWriter = null;

    public KeyValueProcessor(JAXBFilterProcessingContext pc, XMLStreamWriter writer) {
        this.canonWriter = writer;
    }

    public Key processKeyValue(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException {
        boolean done = false;
        Key retKey = null;
        block4: while (!done && reader.hasNext() && !this._breaKeyValue(reader)) {
            reader.next();
            int event = this.getKeyValueEventType(reader);
            switch (event) {
                case 6: {
                    if (this.canonWriter != null) {
                        StreamUtil.writeCurrentEvent(reader, this.canonWriter);
                    }
                    retKey = this.processRSAKeyValue(reader);
                    continue block4;
                }
                case 7: {
                    if (this.canonWriter == null) continue block4;
                    StreamUtil.writeCurrentEvent(reader, this.canonWriter);
                    continue block4;
                }
            }
            if (this._breaKeyValue(reader)) {
                done = true;
                continue;
            }
            if (this.canonWriter == null) continue;
            StreamUtil.writeCurrentEvent(reader, this.canonWriter);
        }
        return retKey;
    }

    public Key processRSAKeyValue(XMLStreamReader reader) throws XMLStreamException, XWSSecurityException {
        BigInteger modulus = null;
        BigInteger exponent = null;
        boolean done = false;
        block11: while (!done && reader.hasNext() && !this._breakRSAKeyValue(reader)) {
            reader.next();
            int event = this.getRSAKVEventType(reader);
            switch (event) {
                case 8: {
                    String ev;
                    Base64Data bd;
                    if (this.canonWriter != null) {
                        StreamUtil.writeCurrentEvent(reader, this.canonWriter);
                    }
                    reader.next();
                    StringBuilder sb = null;
                    byte[] value = null;
                    CharSequence charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                    if (charSeq instanceof Base64Data) {
                        bd = (Base64Data)((XMLStreamReaderEx)reader).getPCDATA();
                        value = bd.getExact();
                        modulus = new BigInteger(1, value);
                        if (this.canonWriter == null) continue block11;
                        ev = Base64.encode(value);
                        this.canonWriter.writeCharacters(ev);
                        break;
                    }
                    sb = new StringBuilder();
                    while (true) {
                        if (reader.getEventType() != 4) break;
                        if (reader.getEventType() == 2) break;
                        charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                        for (int i = 0; i < charSeq.length(); ++i) {
                            if (charSeq.charAt(i) == '\n') continue;
                            sb.append(charSeq.charAt(i));
                        }
                        reader.next();
                    }
                    String dv = sb.toString();
                    if (this.canonWriter != null) {
                        this.canonWriter.writeCharacters(dv);
                    }
                    try {
                        value = Base64.decode(dv);
                    }
                    catch (Base64DecodingException dec) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1606_ERROR_RSAKEYINFO_BASE_64_DECODING("EXPONENT"), dec);
                        throw new XWSSecurityException(LogStringsMessages.WSS_1606_ERROR_RSAKEYINFO_BASE_64_DECODING("EXPONENT"));
                    }
                    modulus = new BigInteger(1, value);
                    break;
                }
                case 9: {
                    String ev;
                    Base64Data bd;
                    if (this.canonWriter != null) {
                        StreamUtil.writeCurrentEvent(reader, this.canonWriter);
                    }
                    reader.next();
                    StringBuilder sb = null;
                    byte[] value = null;
                    CharSequence charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                    if (charSeq instanceof Base64Data) {
                        bd = (Base64Data)((XMLStreamReaderEx)reader).getPCDATA();
                        value = bd.getExact();
                        exponent = new BigInteger(1, value);
                        if (this.canonWriter == null) continue block11;
                        ev = Base64.encode(value);
                        this.canonWriter.writeCharacters(ev);
                        break;
                    }
                    sb = new StringBuilder();
                    while (true) {
                        if (reader.getEventType() != 4) break;
                        if (reader.getEventType() == 2) break;
                        charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                        for (int i = 0; i < charSeq.length(); ++i) {
                            sb.append(charSeq.charAt(i));
                        }
                        reader.next();
                    }
                    String dv = sb.toString();
                    if (this.canonWriter != null) {
                        this.canonWriter.writeCharacters(dv);
                    }
                    try {
                        value = Base64.decode(dv);
                    }
                    catch (Base64DecodingException dec) {
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1606_ERROR_RSAKEYINFO_BASE_64_DECODING("EXPONENT"), dec);
                        throw new XWSSecurityException(LogStringsMessages.WSS_1606_ERROR_RSAKEYINFO_BASE_64_DECODING("EXPONENT"));
                    }
                    exponent = new BigInteger(1, value);
                    break;
                }
                default: {
                    if (this._breakRSAKeyValue(reader)) {
                        done = true;
                        break;
                    }
                    if (this.canonWriter == null) continue block11;
                    StreamUtil.writeCurrentEvent(reader, this.canonWriter);
                }
            }
        }
        try {
            KeyFactory rsaFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rsaKeyspec = new RSAPublicKeySpec(modulus, exponent);
            PublicKey pk = rsaFactory.generatePublic(rsaKeyspec);
            return pk;
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1607_ERROR_RSAPUBLIC_KEY(), ex);
            throw new XWSSecurityException(LogStringsMessages.WSS_1607_ERROR_RSAPUBLIC_KEY(), ex);
        }
        catch (InvalidKeySpecException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1607_ERROR_RSAPUBLIC_KEY(), ex);
            throw new XWSSecurityException(LogStringsMessages.WSS_1607_ERROR_RSAPUBLIC_KEY(), ex);
        }
    }

    private int getKeyValueEventType(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == RSA_KEY_VALUE) {
                return 6;
            }
            if (reader.getLocalName() == DSA_KEY_VALUE) {
                return 7;
            }
        }
        return -1;
    }

    private int getRSAKVEventType(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == MODULUS) {
                return 8;
            }
            if (reader.getLocalName() == EXPONENT) {
                return 9;
            }
        }
        return -1;
    }

    private boolean isRSAKeyValue(XMLStreamReader reader) {
        return reader.getLocalName() == RSA_KEY_VALUE;
    }

    private boolean isKeyValue(XMLStreamReader reader) {
        return reader.getLocalName() == KEY_VALUE;
    }

    private boolean _breaKeyValue(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() == 2 && this.isKeyValue(reader)) {
            if (this.canonWriter != null) {
                StreamUtil.writeCurrentEvent(reader, this.canonWriter);
            }
            return true;
        }
        return false;
    }

    private boolean _breakRSAKeyValue(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() == 2 && this.isRSAKeyValue(reader)) {
            if (this.canonWriter != null) {
                StreamUtil.writeCurrentEvent(reader, this.canonWriter);
            }
            return true;
        }
        return false;
    }
}

