/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.util;

import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.CipherOutputStream;

public class BufferedStreamWriter
extends OutputStream {
    int size = 4096;
    byte[] buf = null;
    int pos = 0;
    CipherOutputStream cos = null;

    public BufferedStreamWriter(CipherOutputStream cos) {
        this.buf = new byte[this.size];
        this.cos = cos;
    }

    public BufferedStreamWriter(CipherOutputStream cos, int size) {
        this.buf = new byte[size];
        this.cos = cos;
    }

    @Override
    public void write(byte[] arg0) throws IOException {
        int newPos = this.pos + arg0.length;
        if (newPos >= this.size) {
            this.flush();
            System.arraycopy(arg0, 0, this.buf, 0, arg0.length);
            this.pos = arg0.length;
        } else {
            System.arraycopy(arg0, 0, this.buf, this.pos, arg0.length);
            this.pos = newPos;
        }
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
        int newPos = this.pos + arg2;
        if (newPos >= this.size) {
            this.flush();
            System.arraycopy(arg0, arg1, this.buf, 0, arg2);
            this.pos = arg2;
        } else {
            System.arraycopy(arg0, arg1, this.buf, this.pos, arg2);
            this.pos = newPos;
        }
    }

    @Override
    public void write(int arg0) throws IOException {
        if (this.pos >= this.size) {
            this.flush();
        }
        this.buf[this.pos++] = (byte)arg0;
    }

    @Override
    public void flush() throws IOException {
        this.cos.write(this.buf, 0, this.pos);
        this.pos = 0;
    }
}

